/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.jetbrains.performancePlugin.MessagesBundle;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class GoToCommand
extends AbstractCommand {
    public static final String PREFIX = "%goto";
    private final Project myProject;

    public GoToCommand(@NotNull String text, int line, @NotNull Project project) {
        if (text == null) {
            GoToCommand.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GoToCommand.$$$reportNull$$$0(1);
        }
        super(text, line);
        this.myProject = project;
    }

    protected Promise<Object> _execute(final PlaybackContext context) {
        final ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        String input = this.getText().substring(PREFIX.length()).trim();
        String[] lineAndColumn = input.split(" ");
        int line = Integer.parseInt(lineAndColumn[0]) - 1;
        int column = Integer.parseInt(lineAndColumn[1]) - 1;
        ApplicationManager.getApplication().invokeLater(() -> {
            Editor editor = FileEditorManager.getInstance((Project)this.myProject).getSelectedTextEditor();
            assert (editor != null);
            Document document = editor.getDocument();
            if (line <= document.getLineCount()) {
                int lineStartOffset = document.getLineStartOffset(line);
                int lineLength = document.getLineEndOffset(line) - lineStartOffset;
                if (column > lineLength) {
                    WriteCommandAction.runWriteCommandAction((Project)this.myProject, () -> document.insertString(lineStartOffset + lineLength, (CharSequence)IntStream.range(0, column - lineLength).mapToObj(i -> " ").collect(Collectors.joining())));
                }
                int offset = lineStartOffset + column;
                CaretListener caretListener = new CaretListener(){

                    public void caretPositionChanged(@NotNull CaretEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        context.message(MessagesBundle.message("command.goto.finish", new Object[0]), GoToCommand.this.getLine());
                        actionCallback.setDone();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/performancePlugin/commands/GoToCommand$1", "caretPositionChanged"));
                    }
                };
                editor.getCaretModel().addCaretListener(caretListener);
                actionCallback.doWhenDone(() -> editor.getCaretModel().removeCaretListener(caretListener));
                if (editor.getCaretModel().getOffset() == offset) {
                    context.message(MessagesBundle.message("command.goto.finish", new Object[0]), this.getLine());
                    actionCallback.setDone();
                } else {
                    editor.getCaretModel().moveToOffset(offset);
                    editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
                }
            } else {
                context.error("Line is out of range", this.getLine());
                actionCallback.setRejected();
            }
        });
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "text";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/performancePlugin/commands/GoToCommand";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

