/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.ClickHouse;
import org.jetbrains.dekaf.intermediate.DBExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.CHouseIntermediateFacade;
import org.jetbrains.dekaf.jdbc.ExasolExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateFacade;

public class CHouseJdbcHelper
extends JdbcHelperImpl {
    private static final String CHOUSE_HACKS = "dg.clickhouse.hacks";

    public CHouseJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super(ClickHouse.RDBMS, version, connection);
    }

    public CHouseJdbcHelper() {
        this(null, null);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return CHouseJdbcHelper.extractVersion(version);
    }

    @Override
    @NotNull
    public JdbcIntermediateFacade createFacade(@NotNull DataSource ds) {
        if (ds == null) {
            CHouseJdbcHelper.$$$reportNull$$$0(0);
        }
        CHouseIntermediateFacade cHouseIntermediateFacade = new CHouseIntermediateFacade(ds, 1, false, (DBExceptionRecognizer)ExasolExceptionRecognizer.INSTANCE);
        if (cHouseIntermediateFacade == null) {
            CHouseJdbcHelper.$$$reportNull$$$0(1);
        }
        return cHouseIntermediateFacade;
    }

    @Override
    protected void setTimestamp(@NotNull RemotePreparedStatement statement, int idx, Timestamp timestamp) throws Exception {
        if (statement == null) {
            CHouseJdbcHelper.$$$reportNull$$$0(2);
        }
        statement.setTimestamp(idx, timestamp);
    }

    @Override
    protected void setTime(@NotNull RemotePreparedStatement statement, int idx, Time time) throws RemoteException, SQLException {
        if (statement == null) {
            CHouseJdbcHelper.$$$reportNull$$$0(3);
        }
        statement.setTime(idx, time);
    }

    @Override
    public char getEscapeChar() {
        return '\\';
    }

    @Override
    @NotNull
    protected String getCharsToEscape() {
        if ("%_\\" == null) {
            CHouseJdbcHelper.$$$reportNull$$$0(4);
        }
        return "%_\\";
    }

    @Override
    public boolean supportsEscape() {
        return false;
    }

    @Override
    public int fixJdbcType(@Nullable String typeName, @Nullable String clazz, int type) {
        if (type == 1111 && "uuid".equalsIgnoreCase(typeName)) {
            return 12;
        }
        return super.fixJdbcType(typeName, clazz, type);
    }

    @Override
    protected boolean isDriverFailsOnType(int jdbcType, String typeName) {
        return super.isDriverFailsOnType(jdbcType, typeName) || jdbcType == 2003;
    }

    @Override
    public void adjustType(@NotNull JdbcHelper.Type e) {
        if (e == null) {
            CHouseJdbcHelper.$$$reportNull$$$0(5);
        }
        String nullable = "Nullable(";
        if (e.typeName != null && e.typeName.startsWith(nullable) && e.typeName.endsWith(")")) {
            e.nullable = true;
            e.typeName = e.typeName.substring(nullable.length(), e.typeName.length() - 1);
        }
        if (!"fixedstring".equalsIgnoreCase(e.typeName)) {
            e.length = -1;
        }
    }

    @Override
    public boolean supportsCalendarInPreparedStatement() {
        return false;
    }

    @Override
    public boolean supportsLimitMaxRows() {
        return false;
    }

    @Override
    @Nullable
    public final JdbcHelperImpl detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer) throws Exception {
        if (!JdbcNativeUtil.detectString(product, "ClickHouse")) {
            return null;
        }
        JdbcNativeUtil.logInfo("getDatabaseProductName: " + product);
        return CHouseJdbcHelper.create(delegate, productVer);
    }

    @Override
    public boolean detect(@NotNull Driver driver, @Nullable String url) {
        if (driver == null) {
            CHouseJdbcHelper.$$$reportNull$$$0(6);
        }
        return CHouseJdbcHelper.classNameContains(driver, "clickhouse");
    }

    @Override
    @Nullable
    public final Connection connect(@NotNull Driver driver, String url, @NotNull Properties properties, @NotNull Map<String, Serializable> extra) throws SQLException {
        if (driver == null) {
            CHouseJdbcHelper.$$$reportNull$$$0(7);
        }
        if (properties == null) {
            CHouseJdbcHelper.$$$reportNull$$$0(8);
        }
        if (extra == null) {
            CHouseJdbcHelper.$$$reportNull$$$0(9);
        }
        if ("false".equals(System.getProperty(CHOUSE_HACKS))) {
            return null;
        }
        if (!properties.containsKey("session_id")) {
            String sessionId = "DataGrip_" + UUID.randomUUID().toString();
            properties.setProperty("session_id", sessionId);
            JdbcNativeUtil.logInfo("Generated session_id: " + sessionId);
        }
        return super.connect(driver, url, properties, extra);
    }

    @NotNull
    private static CHouseJdbcHelper create(@Nullable Connection delegate, @Nullable String productVer) throws Exception {
        String versionStr = delegate == null ? productVer : JdbcNativeUtil.getString(delegate, "select version()");
        JdbcNativeUtil.logInfo("version: " + versionStr);
        CHouseJdbcHelper cHouseJdbcHelper = new CHouseJdbcHelper(CHouseJdbcHelper.extractVersion(versionStr), delegate);
        if (cHouseJdbcHelper == null) {
            CHouseJdbcHelper.$$$reportNull$$$0(10);
        }
        return cHouseJdbcHelper;
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    @Override
    public boolean getAutoCommit(Connection delegate) {
        return true;
    }

    @Override
    public boolean supportsTransactions() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 1: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/CHouseJdbcHelper";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extra";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/CHouseJdbcHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createFacade";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharsToEscape";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFacade";
                break;
            }
            case 1: 
            case 4: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setTimestamp";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setTime";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "adjustType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "connect";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

