/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.helpers.AzureJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.JdbcSettings;
import com.intellij.database.remote.jdbc.helpers.MsJdbcHelper;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.containers.ContainerUtilRt;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Driver;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Mssql;
import org.jetbrains.dekaf.intermediate.DBExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateFacade;
import org.jetbrains.dekaf.jdbc.MssqlExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.MssqlIntermediateFacade;

public abstract class MsBaseJdbcHelper
extends JdbcHelperImpl {
    public static final int DATE_TIME_OFFSET = -155;
    private final String myFlavour;
    private static final Set<String> MS_UNLIMITED_TYPES = ContainerUtilRt.newHashSet((Object[])new String[]{"integer", "clob", "blob", "int"});

    public MsBaseJdbcHelper(@NotNull String flavour, @Nullable String version, @Nullable Connection connection) {
        if (flavour == null) {
            MsBaseJdbcHelper.$$$reportNull$$$0(0);
        }
        super(Mssql.RDBMS, version, connection);
        this.myFlavour = flavour;
    }

    @Override
    @NotNull
    public String getDbmsName() {
        String string = this.myFlavour;
        if (string == null) {
            MsBaseJdbcHelper.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public JdbcIntermediateFacade createFacade(@NotNull DataSource ds) {
        if (ds == null) {
            MsBaseJdbcHelper.$$$reportNull$$$0(2);
        }
        MssqlIntermediateFacade mssqlIntermediateFacade = new MssqlIntermediateFacade(ds, 1, false, (DBExceptionRecognizer)MssqlExceptionRecognizer.INSTANCE);
        if (mssqlIntermediateFacade == null) {
            MsBaseJdbcHelper.$$$reportNull$$$0(3);
        }
        return mssqlIntermediateFacade;
    }

    @Override
    public boolean isZonedTimestampColumn(@Nullable String typeName, int jdbcType) {
        return typeName != null && jdbcType == -155 || super.isZonedTimestampColumn(typeName, jdbcType);
    }

    @Override
    public void adjustType(@NotNull JdbcHelper.Type e) {
        if (e == null) {
            MsBaseJdbcHelper.$$$reportNull$$$0(4);
        }
        if (e.typeName == null) {
            return;
        }
        String t = e.typeName.toLowerCase(Locale.ENGLISH);
        if (MS_UNLIMITED_TYPES.contains(t)) {
            e.length = -1;
        }
    }

    @Override
    public boolean isTimestamp(int type) {
        return type == -151 || super.isTimestamp(type);
    }

    @Override
    @NotNull
    protected String getCharsToEscape() {
        if ("%_[]#" == null) {
            MsBaseJdbcHelper.$$$reportNull$$$0(5);
        }
        return "%_[]#";
    }

    @Override
    protected void setBigInteger(@NotNull RemotePreparedStatement statement, @NotNull BigInteger value, int idx) throws Exception {
        if (statement == null) {
            MsBaseJdbcHelper.$$$reportNull$$$0(6);
        }
        if (value == null) {
            MsBaseJdbcHelper.$$$reportNull$$$0(7);
        }
        statement.setObject(idx, value.longValue());
    }

    @Override
    public boolean supportsLimitMaxRows() {
        return false;
    }

    @Override
    public JdbcSettings.SslMode[] supportedSslModes() {
        return JdbcSettings.SslMode.values();
    }

    @Override
    protected void enableSsl(@NotNull Driver driver, @NotNull Properties properties, @NotNull JdbcSettings.SslMode sslMode) {
        if (driver == null) {
            MsBaseJdbcHelper.$$$reportNull$$$0(8);
        }
        if (properties == null) {
            MsBaseJdbcHelper.$$$reportNull$$$0(9);
        }
        if (sslMode == null) {
            MsBaseJdbcHelper.$$$reportNull$$$0(10);
        }
        if (MsBaseJdbcHelper.isJtds(driver)) {
            MsBaseJdbcHelper.setIfEmpty(properties, "SSL", sslMode == JdbcSettings.SslMode.REQUIRE ? "require" : "authenticate");
        } else if (MsBaseJdbcHelper.isMs(driver)) {
            MsBaseJdbcHelper.setIfEmpty(properties, "encrypt", "true");
            if (sslMode == JdbcSettings.SslMode.REQUIRE) {
                MsBaseJdbcHelper.setIfEmpty(properties, "trustServerCertificate", "true");
            }
            if (sslMode == JdbcSettings.SslMode.VERIFY_CA) {
                MsBaseJdbcHelper.setIfEmpty(properties, "fips", "true");
            }
        }
    }

    @Override
    @Nullable
    public final JdbcHelperImpl detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer) throws Exception {
        if (!JdbcNativeUtil.detectString(product, "Azure") && !JdbcNativeUtil.detectString(product, "microsoft|sqlserver")) {
            return null;
        }
        String ver = delegate == null ? productVer : JdbcNativeUtil.getString(delegate, "select @@version");
        JdbcNativeUtil.logInfo("@@version: " + ver);
        return JdbcNativeUtil.detectString(ver, "Azure") ? AzureJdbcHelper.create(delegate, productVer) : MsJdbcHelper.create(delegate, productVer);
    }

    @Override
    public boolean detect(@NotNull Driver driver, @Nullable String url) {
        if (driver == null) {
            MsBaseJdbcHelper.$$$reportNull$$$0(11);
        }
        return MsBaseJdbcHelper.isMs(driver) || MsBaseJdbcHelper.isJtds(driver) && url != null && StringUtilRt.startsWithIgnoreCase((String)url, (String)"jdbc:jtds:sqlserver:");
    }

    @Override
    protected void enableIntegratedSecurity(@NotNull Driver driver, @NotNull Properties properties) {
        if (driver == null) {
            MsBaseJdbcHelper.$$$reportNull$$$0(12);
        }
        if (properties == null) {
            MsBaseJdbcHelper.$$$reportNull$$$0(13);
        }
        if (MsBaseJdbcHelper.isMs(driver)) {
            MsBaseJdbcHelper.setIfEmpty(properties, "integratedSecurity", "true");
        }
    }

    private static boolean isMs(@NotNull Driver driver) {
        if (driver == null) {
            MsBaseJdbcHelper.$$$reportNull$$$0(14);
        }
        return MsBaseJdbcHelper.classNameContains(driver, "com.microsoft.sqlserver");
    }

    private static boolean isJtds(@NotNull Driver driver) {
        if (driver == null) {
            MsBaseJdbcHelper.$$$reportNull$$$0(15);
        }
        return MsBaseJdbcHelper.classNameContains(driver, "net.sourceforge.jtds");
    }

    @Override
    public boolean supportsIlike() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flavour";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/MsBaseJdbcHelper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sslMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/MsBaseJdbcHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbmsName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createFacade";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharsToEscape";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createFacade";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "adjustType";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setBigInteger";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "enableSsl";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "enableIntegratedSecurity";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isMs";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isJtds";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

