/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview;

import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.html.TransparentInlineHolderProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b \u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0014J$\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0011R\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J,\u0010\u0013\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0011R\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0006H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/LinkGeneratingProvider;", "Lorg/intellij/markdown/html/GeneratingProvider;", "baseURI", "Ljava/net/URI;", "(Ljava/net/URI;)V", "getRenderInfo", "Lorg/intellij/plugins/markdown/ui/preview/LinkGeneratingProvider$RenderInfo;", "text", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "makeAbsoluteUrl", "", "destination", "processNode", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "renderLink", "info", "Companion", "RenderInfo", "intellij.markdown"})
public abstract class LinkGeneratingProvider
implements GeneratingProvider {
    private final URI baseURI;
    @NotNull
    private static final TransparentInlineHolderProvider fallbackProvider;
    @NotNull
    private static final TransparentInlineHolderProvider labelProvider;
    public static final Companion Companion;

    public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        RenderInfo renderInfo = this.getRenderInfo(text, node);
        if (renderInfo == null) {
            fallbackProvider.processNode(visitor, text, node);
            return;
        }
        RenderInfo info = renderInfo;
        this.renderLink(visitor, text, node, info);
    }

    @NotNull
    protected CharSequence makeAbsoluteUrl(@NotNull CharSequence destination) {
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        if (StringsKt.startsWith$default((CharSequence)destination, (char)'#', (boolean)false, (int)2, null)) {
            return destination;
        }
        try {
            Object object = this.baseURI;
            return object != null && (object = ((URI)object).resolve(((Object)destination).toString())) != null && (object = ((URI)object).toString()) != null ? (CharSequence)object : destination;
        }
        catch (IllegalArgumentException e) {
            return destination;
        }
    }

    public void renderLink(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node, @NotNull RenderInfo info) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        HtmlGenerator.HtmlGeneratingVisitor htmlGeneratingVisitor = visitor;
        ASTNode aSTNode = node;
        CharSequence charSequence = "a";
        CharSequence[] charSequenceArray = new CharSequence[2];
        charSequenceArray[0] = "href=\"" + this.makeAbsoluteUrl(info.getDestination()) + '\"';
        CharSequence[] charSequenceArray2 = charSequenceArray;
        CharSequence[] charSequenceArray3 = charSequenceArray;
        int n = 1;
        CharSequence charSequence2 = info.getTitle();
        if (charSequence2 != null) {
            CharSequence charSequence3 = charSequence2;
            int n2 = n;
            CharSequence[] charSequenceArray4 = charSequenceArray2;
            CharSequence[] charSequenceArray5 = charSequenceArray3;
            CharSequence charSequence4 = charSequence;
            ASTNode aSTNode2 = aSTNode;
            HtmlGenerator.HtmlGeneratingVisitor htmlGeneratingVisitor2 = htmlGeneratingVisitor;
            boolean bl = false;
            boolean bl2 = false;
            CharSequence it = charSequence3;
            boolean bl3 = false;
            String string2 = "title=\"" + it + '\"';
            htmlGeneratingVisitor = htmlGeneratingVisitor2;
            aSTNode = aSTNode2;
            charSequence = charSequence4;
            charSequenceArray3 = charSequenceArray5;
            charSequenceArray2 = charSequenceArray4;
            n = n2;
            string = string2;
        } else {
            string = null;
        }
        charSequenceArray2[n] = string;
        HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default((HtmlGenerator.HtmlGeneratingVisitor)htmlGeneratingVisitor, (ASTNode)aSTNode, (CharSequence)charSequence, (CharSequence[])charSequenceArray3, (boolean)false, (int)8, null);
        labelProvider.processNode(visitor, text, info.getLabel());
        visitor.consumeTagClose((CharSequence)"a");
    }

    @Nullable
    public abstract RenderInfo getRenderInfo(@NotNull String var1, @NotNull ASTNode var2);

    public LinkGeneratingProvider(@Nullable URI baseURI) {
        this.baseURI = baseURI;
    }

    static {
        Companion = new Companion(null);
        fallbackProvider = new TransparentInlineHolderProvider(0, 0, 3, null);
        labelProvider = new TransparentInlineHolderProvider(1, -1);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J)\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0018"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/LinkGeneratingProvider$RenderInfo;", "", "label", "Lorg/intellij/markdown/ast/ASTNode;", "destination", "", "title", "(Lorg/intellij/markdown/ast/ASTNode;Ljava/lang/CharSequence;Ljava/lang/CharSequence;)V", "getDestination", "()Ljava/lang/CharSequence;", "getLabel", "()Lorg/intellij/markdown/ast/ASTNode;", "getTitle", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.markdown"})
    public static final class RenderInfo {
        @NotNull
        private final ASTNode label;
        @NotNull
        private final CharSequence destination;
        @Nullable
        private final CharSequence title;

        @NotNull
        public final ASTNode getLabel() {
            return this.label;
        }

        @NotNull
        public final CharSequence getDestination() {
            return this.destination;
        }

        @Nullable
        public final CharSequence getTitle() {
            return this.title;
        }

        public RenderInfo(@NotNull ASTNode label, @NotNull CharSequence destination, @Nullable CharSequence title) {
            Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
            Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
            this.label = label;
            this.destination = destination;
            this.title = title;
        }

        @NotNull
        public final ASTNode component1() {
            return this.label;
        }

        @NotNull
        public final CharSequence component2() {
            return this.destination;
        }

        @Nullable
        public final CharSequence component3() {
            return this.title;
        }

        @NotNull
        public final RenderInfo copy(@NotNull ASTNode label, @NotNull CharSequence destination, @Nullable CharSequence title) {
            Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
            Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
            return new RenderInfo(label, destination, title);
        }

        public static /* synthetic */ RenderInfo copy$default(RenderInfo renderInfo, ASTNode aSTNode, CharSequence charSequence, CharSequence charSequence2, int n, Object object) {
            if ((n & 1) != 0) {
                aSTNode = renderInfo.label;
            }
            if ((n & 2) != 0) {
                charSequence = renderInfo.destination;
            }
            if ((n & 4) != 0) {
                charSequence2 = renderInfo.title;
            }
            return renderInfo.copy(aSTNode, charSequence, charSequence2);
        }

        @NotNull
        public String toString() {
            return "RenderInfo(label=" + this.label + ", destination=" + this.destination + ", title=" + this.title + ")";
        }

        public int hashCode() {
            ASTNode aSTNode = this.label;
            CharSequence charSequence = this.destination;
            CharSequence charSequence2 = this.title;
            return ((aSTNode != null ? aSTNode.hashCode() : 0) * 31 + (charSequence != null ? charSequence.hashCode() : 0)) * 31 + (charSequence2 != null ? charSequence2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof RenderInfo)) break block3;
                    RenderInfo renderInfo = (RenderInfo)object;
                    if (!Intrinsics.areEqual((Object)this.label, (Object)renderInfo.label) || !Intrinsics.areEqual((Object)this.destination, (Object)renderInfo.destination) || !Intrinsics.areEqual((Object)this.title, (Object)renderInfo.title)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/LinkGeneratingProvider$Companion;", "", "()V", "fallbackProvider", "Lorg/intellij/markdown/html/TransparentInlineHolderProvider;", "getFallbackProvider", "()Lorg/intellij/markdown/html/TransparentInlineHolderProvider;", "labelProvider", "getLabelProvider", "intellij.markdown"})
    public static final class Companion {
        @NotNull
        public final TransparentInlineHolderProvider getFallbackProvider() {
            return fallbackProvider;
        }

        @NotNull
        public final TransparentInlineHolderProvider getLabelProvider() {
            return labelProvider;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

