/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.completion.feature.impl;

import com.jetbrains.completion.feature.BinaryFeature;
import com.jetbrains.completion.feature.CategoricalFeature;
import com.jetbrains.completion.feature.DoubleFeature;
import com.jetbrains.completion.feature.FeatureInterpreter;
import com.jetbrains.completion.feature.ex.FeatureDefaultValueNotFound;
import com.jetbrains.completion.feature.ex.InconsistentMetadataException;
import com.jetbrains.completion.feature.impl.BinaryFeatureImpl;
import com.jetbrains.completion.feature.impl.CategoricalFeatureImpl;
import com.jetbrains.completion.feature.impl.DoubleFeatureImpl;
import com.jetbrains.completion.feature.impl.FeatureUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\b2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\bH\u0016J2\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\bH\u0016J\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J8\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\b2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\bH\u0016J(\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u00162\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\bH\u0002J$\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\bH\u0002J+\u0010\u0019\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\bH\u0002\u00a2\u0006\u0002\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/completion/feature/impl/FeatureInterpreterImpl;", "Lcom/jetbrains/completion/feature/FeatureInterpreter;", "()V", "binary", "Lcom/jetbrains/completion/feature/BinaryFeature;", "name", "", "description", "", "", "order", "", "categorical", "Lcom/jetbrains/completion/feature/CategoricalFeature;", "categories", "", "combine", "featureName", "categoryName", "double", "Lcom/jetbrains/completion/feature/DoubleFeature;", "extractBinaryValuesMapping", "Lkotlin/Pair;", "Lcom/jetbrains/completion/feature/BinaryFeature$BinaryValueDescriptor;", "extractIndex", "extractUndefinedIndex", "(Ljava/lang/String;Ljava/util/Map;)Ljava/lang/Integer;", "intellij.statsCollector.features"})
public final class FeatureInterpreterImpl
implements FeatureInterpreter {
    @Override
    @NotNull
    public BinaryFeature binary(@NotNull String name, @NotNull Map<String, ? extends Object> description, @NotNull Map<String, Integer> order) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(description, (String)"description");
        Intrinsics.checkParameterIsNotNull(order, (String)"order");
        int index = this.extractIndex(name, order);
        Integer undefinedIndex = this.extractUndefinedIndex(name, order);
        Double d = StringsKt.toDoubleOrNull((String)String.valueOf(description.get("default")));
        if (d == null) {
            throw (Throwable)new FeatureDefaultValueNotFound(name);
        }
        double d2 = d;
        Pair<BinaryFeature.BinaryValueDescriptor, BinaryFeature.BinaryValueDescriptor> values = this.extractBinaryValuesMapping(description);
        return new BinaryFeatureImpl(name, index, undefinedIndex, d2, (BinaryFeature.BinaryValueDescriptor)values.getFirst(), (BinaryFeature.BinaryValueDescriptor)values.getSecond());
    }

    @Override
    @NotNull
    public DoubleFeature double(@NotNull String name, @NotNull Map<String, ? extends Object> description, @NotNull Map<String, Integer> order) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(description, (String)"description");
        Intrinsics.checkParameterIsNotNull(order, (String)"order");
        int index = this.extractIndex(name, order);
        Integer undefinedIndex = this.extractUndefinedIndex(name, order);
        Double d = StringsKt.toDoubleOrNull((String)String.valueOf(description.get("default")));
        if (d == null) {
            throw (Throwable)new FeatureDefaultValueNotFound(name);
        }
        double defaultValue = d;
        return new DoubleFeatureImpl(name, index, undefinedIndex, defaultValue);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CategoricalFeature categorical(@NotNull String name, @NotNull List<String> categories, @NotNull Map<String, Integer> order) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(categories, (String)"categories");
        Intrinsics.checkParameterIsNotNull(order, (String)"order");
        Iterable $this$associate$iv = categories;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            String it = (String)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it, (Object)this.extractIndex(this.combine(name, it), order));
            boolean bl2 = false;
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map categoryToIndex = destination$iv$iv;
        return new CategoricalFeatureImpl(name, categoryToIndex);
    }

    private final int extractIndex(String name, Map<String, Integer> order) {
        Integer n = order.get(name);
        if (n == null) {
            throw (Throwable)new InconsistentMetadataException("Feature with name '" + name + "' not found in feature_order.txt");
        }
        return n;
    }

    private final Integer extractUndefinedIndex(String name, Map<String, Integer> order) {
        return order.get(FeatureUtils.INSTANCE.getUndefinedFeatureName(name));
    }

    private final Pair<BinaryFeature.BinaryValueDescriptor, BinaryFeature.BinaryValueDescriptor> extractBinaryValuesMapping(Map<String, ? extends Object> description) {
        Object object;
        boolean bl = false;
        List result = new ArrayList();
        Object object2 = description;
        boolean bl2 = false;
        for (Map.Entry<String, ? extends Object> entry : object2.entrySet()) {
            object = entry;
            boolean bl3 = false;
            String name = object.getKey();
            object = entry;
            bl3 = false;
            Object value = object.getValue();
            if (Intrinsics.areEqual((Object)name, (Object)"default") || Intrinsics.areEqual((Object)name, (Object)"use_undefined")) continue;
            Double mappedValue = StringsKt.toDoubleOrNull((String)value.toString());
            if (mappedValue == null) {
                throw (Throwable)new InconsistentMetadataException("mapped value for binary feature should be double");
            }
            Collection collection = result;
            BinaryFeature.BinaryValueDescriptor binaryValueDescriptor = new BinaryFeature.BinaryValueDescriptor(name, mappedValue);
            boolean bl4 = false;
            collection.add(binaryValueDescriptor);
        }
        bl = result.size() == 2;
        boolean bl5 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl6 = false;
            String string = "binary feature must contains 2 values, but found " + result;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        List $this$sortBy$iv = result;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            object2 = $this$sortBy$iv;
            bl2 = false;
            object = new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    BinaryFeature.BinaryValueDescriptor it = (BinaryFeature.BinaryValueDescriptor)a;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)((Object)it.getKey());
                    it = (BinaryFeature.BinaryValueDescriptor)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    String string = it.getKey();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                }
            };
            CollectionsKt.sortWith((List)object2, (Comparator)object);
        }
        return TuplesKt.to(result.get(0), result.get(1));
    }

    private final String combine(String featureName, String categoryName) {
        return featureName + '=' + categoryName;
    }
}

