/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.completion.feature.impl;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0003J\u0006\u0010\u0006\u001a\u00020\u0003J\u0006\u0010\u0007\u001a\u00020\u0003J\b\u0010\b\u001a\u0004\u0018\u00010\u0003J\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\nJ\u0006\u0010\f\u001a\u00020\u0003J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0002J\u0018\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\n*\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/completion/feature/impl/MetadataReader;", "", "featuresDirectory", "", "(Ljava/lang/String;)V", "allKnown", "binaryFeatures", "categoricalFeatures", "extractVersion", "featuresOrder", "", "", "floatFeatures", "resourceContent", "fileName", "lineToNumber", "intellij.statsCollector.features"})
public final class MetadataReader {
    private final String featuresDirectory;

    @NotNull
    public final String binaryFeatures() {
        return this.resourceContent("binary.json");
    }

    @NotNull
    public final String floatFeatures() {
        return this.resourceContent("float.json");
    }

    @NotNull
    public final String categoricalFeatures() {
        return this.resourceContent("categorical.json");
    }

    @NotNull
    public final String allKnown() {
        return this.resourceContent("all_features.json");
    }

    @NotNull
    public final Map<String, Integer> featuresOrder() {
        return this.lineToNumber(this.resourceContent("features_order.txt"));
    }

    @Nullable
    public final String extractVersion() {
        URL resource = MetadataReader.class.getClassLoader().getResource(this.featuresDirectory + "/binary.json");
        if (resource == null) {
            return null;
        }
        String string = resource.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"resource.file");
        String result = StringsKt.substringAfterLast((String)StringsKt.substringBeforeLast((String)string, (String)".jar!", (String)""), (String)"-", (String)"");
        return StringsKt.isBlank((CharSequence)result) ? null : result;
    }

    private final String resourceContent(String fileName) {
        InputStream fileStream;
        InputStream inputStream = fileStream = MetadataReader.class.getClassLoader().getResourceAsStream(this.featuresDirectory + '/' + fileName);
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"fileStream");
        InputStream inputStream2 = inputStream;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        Closeable closeable = inputStream2;
        int n = 0;
        closeable = new InputStreamReader((InputStream)closeable, charset);
        n = 8192;
        boolean bl2 = false;
        return TextStreamsKt.readText((Reader)(closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n)));
    }

    private final Map<String, Integer> lineToNumber(@NotNull String $this$lineToNumber) {
        int index = 0;
        boolean bl = false;
        Map map = new LinkedHashMap();
        Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)$this$lineToNumber, (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl2 = false;
            String string = it;
            boolean bl3 = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String featureName = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            int n = index;
            index = n + 1;
            map.put(featureName, n);
        }
        return map;
    }

    public MetadataReader(@NotNull String featuresDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)featuresDirectory, (String)"featuresDirectory");
        this.featuresDirectory = featuresDirectory;
    }
}

