/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains;

import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.containers.hash.HashSet;
import com.jetbrains.ERDiagramNode;
import com.jetbrains.ERUmlRelationships;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.uml.PyUmlEdge;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ERDiagramModel
extends DiagramDataModel<PyClass> {
    protected final HashSet<DiagramNode<PyClass>> myNodes = new HashSet();
    protected final Collection<DiagramEdge<PyClass>> myEdges = new HashSet();
    public static Map<PyClass, Map.Entry<String, String>> ourAdditionalFields = new HashMap();
    protected final HashSet<PyClass> myClasses = new HashSet();
    private final PyClass myInitialElement;
    private final Project myProject;

    protected ERDiagramModel(Project project, PyClass element, DiagramProvider<PyClass> provider) {
        super(project, provider);
        this.myInitialElement = element;
        this.myProject = project;
    }

    protected abstract void init(Project var1, PyClass var2);

    @NotNull
    public Collection<DiagramNode<PyClass>> getNodes() {
        HashSet<DiagramNode<PyClass>> hashSet = this.myNodes;
        if (hashSet == null) {
            ERDiagramModel.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    @NotNull
    public Collection<DiagramEdge<PyClass>> getEdges() {
        Collection<DiagramEdge<PyClass>> collection = this.myEdges;
        if (collection == null) {
            ERDiagramModel.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    public String getNodeName(@NotNull DiagramNode<PyClass> node) {
        String name;
        if (node == null) {
            ERDiagramModel.$$$reportNull$$$0(2);
        }
        String string = (name = ((PyClass)node.getIdentifyingElement()).getName()) == null ? "" : name;
        if (string == null) {
            ERDiagramModel.$$$reportNull$$$0(3);
        }
        return string;
    }

    public DiagramNode<PyClass> addElement(@NotNull PyClass element) {
        if (element == null) {
            ERDiagramModel.$$$reportNull$$$0(4);
        }
        if (this.isAlreadyDrawn(element)) {
            return null;
        }
        return new ERDiagramNode(element, (DiagramProvider<PyClass>)this.getProvider());
    }

    protected boolean isAlreadyDrawn(PyClass element) {
        if (element != null) {
            String elementFQN = element.getQualifiedName();
            for (DiagramNode node : this.myNodes) {
                PyClass container = (PyClass)node.getIdentifyingElement();
                String nodeFQN = container.getName();
                if (elementFQN == null || nodeFQN == null || !elementFQN.equals(nodeFQN)) continue;
                return true;
            }
        }
        return false;
    }

    public void removeNode(DiagramNode<PyClass> node) {
        this.removeElement((PyClass)node.getIdentifyingElement());
    }

    private void removeElement(PyClass element) {
        DiagramNode<PyClass> node = this.findNode(element);
        if (node != null) {
            ArrayList<DiagramEdge<PyClass>> edges = new ArrayList<DiagramEdge<PyClass>>();
            for (DiagramEdge<PyClass> edge : this.myEdges) {
                if (!edge.getTarget().equals(node) && !edge.getSource().equals(node)) continue;
                edges.add(edge);
            }
            this.myEdges.removeAll(edges);
        }
        this.myNodes.remove(node);
    }

    @Nullable
    protected DiagramNode<PyClass> findNode(PyClass element) {
        if (element == null) {
            return null;
        }
        String elementFQN = element.getQualifiedName();
        for (DiagramNode node : this.myNodes) {
            String fqn = ((PyClass)node.getIdentifyingElement()).getQualifiedName();
            if (elementFQN == null || !elementFQN.equals(fqn)) continue;
            return node;
        }
        return null;
    }

    public void refreshDataModel() {
        this.myNodes.clear();
        this.myClasses.clear();
        this.myEdges.clear();
        if (this.myInitialElement != null && this.myInitialElement.isValid()) {
            this.init(this.myProject, this.myInitialElement);
        }
        this.calculateRelations();
    }

    protected abstract void calculateRelations();

    @NotNull
    public ModificationTracker getModificationTracker() {
        PsiModificationTracker psiModificationTracker = PsiManager.getInstance((Project)this.getProject()).getModificationTracker();
        if (psiModificationTracker == null) {
            ERDiagramModel.$$$reportNull$$$0(5);
        }
        return psiModificationTracker;
    }

    public void dispose() {
    }

    protected void addEdges(@NotNull DiagramNode<PyClass> fromNode, @NotNull Map<PyClass, String> res, @NotNull String relation, DiagramProvider<PyClass> provider) {
        if (fromNode == null) {
            ERDiagramModel.$$$reportNull$$$0(6);
        }
        if (res == null) {
            ERDiagramModel.$$$reportNull$$$0(7);
        }
        if (relation == null) {
            ERDiagramModel.$$$reportNull$$$0(8);
        }
        for (Map.Entry<PyClass, String> pyClass : res.entrySet()) {
            this.addEdge(fromNode, relation, provider, pyClass);
        }
    }

    protected void addEdge(DiagramNode<PyClass> fromNode, String relation, DiagramProvider<PyClass> provider, Map.Entry<PyClass, String> pyClass) {
        Object toNode = this.findNode(pyClass.getKey());
        if (toNode == null) {
            toNode = new ERDiagramNode(pyClass.getKey(), provider);
            this.myNodes.add(toNode);
        }
        String label = pyClass.getValue();
        PyUmlEdge edge = new PyUmlEdge(fromNode, (DiagramNode<PyClass>)toNode, (DiagramRelationshipInfo)new ERUmlRelationships(relation, label));
        this.myEdges.add((DiagramEdge<PyClass>)edge);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/ERDiagramModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromNode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "res";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/ERDiagramModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNodeName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addElement";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addEdges";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class MyEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private V value;

        public MyEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V old = this.value;
            this.value = value;
            return old;
        }
    }
}

