/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.conditional;

import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.util.JSParenthesesUtils;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.psiutil.BoolUtils;
import org.jetbrains.annotations.NotNull;

public class JSRemoveConditionalIntention
extends JSIntention {
    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        RemoveConditionalPredicate removeConditionalPredicate = new RemoveConditionalPredicate();
        if (removeConditionalPredicate == null) {
            JSRemoveConditionalIntention.$$$reportNull$$$0(0);
        }
        return removeConditionalPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSRemoveConditionalIntention.$$$reportNull$$$0(1);
        }
        JSConditionalExpression exp = (JSConditionalExpression)element;
        JSExpression condition = exp.getCondition();
        JSExpression thenExpression = exp.getThen();
        assert (thenExpression != null);
        String newExpression = com.sixrr.inspectjs.utils.BoolUtils.isTrueLiteral((JSExpression)thenExpression) ? condition.getText() : BoolUtils.getNegatedExpressionText(condition);
        JSRefactoringUtil.replaceExpressionAndReformat((JSExpression)exp, (String)newExpression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/conditional/JSRemoveConditionalIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/conditional/JSRemoveConditionalIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RemoveConditionalPredicate
    implements JSElementPredicate {
        private RemoveConditionalPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                RemoveConditionalPredicate.$$$reportNull$$$0(0);
            }
            if (!(element instanceof JSConditionalExpression)) {
                return false;
            }
            if (PsiUtilCore.hasErrorElementChild((PsiElement)element)) {
                return false;
            }
            JSConditionalExpression condition = (JSConditionalExpression)element;
            JSExpression thenExpression = JSParenthesesUtils.stripParentheses((JSExpression)condition.getThen());
            JSExpression elseExpression = JSParenthesesUtils.stripParentheses((JSExpression)condition.getElse());
            if (condition.getCondition() == null || thenExpression == null || elseExpression == null) {
                return false;
            }
            return com.sixrr.inspectjs.utils.BoolUtils.isTrueLiteral((JSExpression)elseExpression) && com.sixrr.inspectjs.utils.BoolUtils.isFalseLiteral((JSExpression)thenExpression) || com.sixrr.inspectjs.utils.BoolUtils.isTrueLiteral((JSExpression)thenExpression) && com.sixrr.inspectjs.utils.BoolUtils.isFalseLiteral((JSExpression)elseExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/conditional/JSRemoveConditionalIntention$RemoveConditionalPredicate", "satisfiedBy"));
        }
    }
}

