/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.number;

import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import java.math.BigInteger;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.jetbrains.annotations.NotNull;

public abstract class JSConvertIntegerIntentionBase
extends JSIntention {
    private static final BigInteger VALUE_ZERO = new BigInteger(new byte[]{0});

    @Override
    @NotNull
    public final JSElementPredicate getElementPredicate() {
        ConvertPredicate convertPredicate = new ConvertPredicate();
        if (convertPredicate == null) {
            JSConvertIntegerIntentionBase.$$$reportNull$$$0(0);
        }
        return convertPredicate;
    }

    private static BigInteger getLiteralNumber(JSLiteralExpression expression) {
        Object value = expression.getValue();
        if (!(value instanceof Long)) {
            return VALUE_ZERO;
        }
        return BigInteger.valueOf((Long)value);
    }

    @Override
    public final void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSConvertIntegerIntentionBase.$$$reportNull$$$0(1);
        }
        JSLiteralExpression exp = (JSLiteralExpression)element;
        String newNumberString = JSConvertIntegerIntentionBase.getLiteralNumber(exp).toString(this.getRadix());
        String text = this.getNumberPrefix(exp) + newNumberString + (exp.isBigInteger() ? "n" : "");
        JSRefactoringUtil.replaceExpressionAndReformat((JSExpression)exp, (String)text);
    }

    @NotNull
    protected abstract String getNumberPrefix(@NotNull JSLiteralExpression var1);

    protected abstract int getRadix();

    protected abstract boolean isSatisfy(@NotNull JSLiteralExpression var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/number/JSConvertIntegerIntentionBase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/number/JSConvertIntegerIntentionBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ConvertPredicate
    implements JSElementPredicate {
        private ConvertPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                ConvertPredicate.$$$reportNull$$$0(0);
            }
            if (!(element instanceof JSLiteralExpression)) {
                return false;
            }
            JSLiteralExpression literalExpression = (JSLiteralExpression)element;
            if (!literalExpression.getExpressionKind(true).isInteger()) {
                return false;
            }
            return JSConvertIntegerIntentionBase.this.isSatisfy(literalExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/number/JSConvertIntegerIntentionBase$ConvertPredicate", "satisfiedBy"));
        }
    }
}

