/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.number;

import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.util.JSParenthesesUtils;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.intellij.idea.lang.javascript.intention.number.ShiftUtils;
import org.jetbrains.annotations.NotNull;

public class JSReplaceShiftWithMultiplyIntention
extends JSMutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        IElementType tokenType = ((JSBinaryExpression)element).getOperationSign();
        Pair<String, String> pair = ShiftUtils.shiftOperators.get(tokenType);
        return this.getText(pair.first, pair.second);
    }

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        ShiftByLiteralPredicate shiftByLiteralPredicate = new ShiftByLiteralPredicate();
        if (shiftByLiteralPredicate == null) {
            JSReplaceShiftWithMultiplyIntention.$$$reportNull$$$0(0);
        }
        return shiftByLiteralPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSReplaceShiftWithMultiplyIntention.$$$reportNull$$$0(1);
        }
        if (element instanceof JSAssignmentExpression) {
            JSReplaceShiftWithMultiplyIntention.replaceShiftAssignWithMultiplyOrDivideAssign((JSAssignmentExpression)element);
        } else {
            assert (element instanceof JSBinaryExpression);
            JSReplaceShiftWithMultiplyIntention.replaceShiftWithMultiplyOrDivide((JSBinaryExpression)element);
        }
    }

    private static void replaceShiftAssignWithMultiplyOrDivideAssign(JSAssignmentExpression exp) throws IncorrectOperationException {
        JSExpression lhs = exp.getLOperand();
        assert (lhs != null);
        String lhsText = lhs.getText();
        String expString = JSReplaceShiftWithMultiplyIntention.getExpressionText((JSBinaryExpression)exp, lhsText);
        JSRefactoringUtil.replaceExpressionAndReformat((JSExpression)exp, (String)expString);
    }

    private static void replaceShiftWithMultiplyOrDivide(JSBinaryExpression exp) throws IncorrectOperationException {
        JSExpression lhs = exp.getLOperand();
        assert (lhs != null);
        String expString = JSReplaceShiftWithMultiplyIntention.getExpressionText(exp, JSParenthesesUtils.getParenthesized((JSExpression)lhs, (int)6));
        JSElement parent = (JSElement)exp.getParent();
        if (parent instanceof JSExpression && !(parent instanceof JSParenthesizedExpression) && JSParenthesesUtils.getPrecedence((JSExpression)((JSExpression)parent)) < 6) {
            expString = '(' + expString + ')';
        }
        JSRefactoringUtil.replaceExpressionAndReformat((JSExpression)exp, (String)expString);
    }

    @NotNull
    private static String getExpressionText(JSBinaryExpression exp, String lhsText) {
        JSExpression rhs = exp.getROperand();
        IElementType tokenType = exp.getOperationSign();
        String operatorString = (String)ShiftUtils.shiftOperators.get((Object)tokenType).second;
        assert (rhs != null);
        String string = lhsText + operatorString + ShiftUtils.getExpBase2(rhs);
        if (string == null) {
            JSReplaceShiftWithMultiplyIntention.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/number/JSReplaceShiftWithMultiplyIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/number/JSReplaceShiftWithMultiplyIntention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ShiftByLiteralPredicate
    implements JSElementPredicate {
        private ShiftByLiteralPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            JSBinaryExpression binaryExpression;
            if (element == null) {
                ShiftByLiteralPredicate.$$$reportNull$$$0(0);
            }
            return (binaryExpression = (JSBinaryExpression)ObjectUtils.tryCast((Object)element, JSBinaryExpression.class)) != null && binaryExpression.getLOperand() != null && ShiftUtils.shiftOperators.containsKey(binaryExpression.getOperationSign()) && ShiftUtils.isIntLiteral(binaryExpression.getROperand());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/number/JSReplaceShiftWithMultiplyIntention$ShiftByLiteralPredicate", "satisfiedBy"));
        }
    }
}

