/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.sorting;

import com.intellij.completion.sorting.RankingSupport;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.completion.feature.impl.FeatureTransformer;
import com.jetbrains.completion.ranker.LanguageCompletionRanker;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u001c\u0010\u0012\u001a\u0004\u0018\u00010\f*\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0013\u001a\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/completion/sorting/RankingSupport;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "language2rankerCache", "", "", "Lcom/intellij/completion/sorting/RankingSupport$LanguageRanker;", "language2rankerFactory", "", "Lkotlin/Function0;", "Lcom/jetbrains/completion/ranker/LanguageCompletionRanker;", "availableLanguages", "", "getRanker", "language", "Lcom/intellij/lang/Language;", "tryBuild", "name", "LanguageRanker", "intellij.statsCollector"})
public final class RankingSupport {
    private static final Logger LOG;
    private static final Map<String, Function0<LanguageCompletionRanker>> language2rankerFactory;
    private static final Map<String, LanguageRanker> language2rankerCache;
    public static final RankingSupport INSTANCE;

    @Nullable
    public final LanguageRanker getRanker(@Nullable Language language) {
        LanguageRanker languageRanker;
        if (language == null || !language2rankerFactory.keySet().contains(language.getDisplayName())) {
            return null;
        }
        String string = language.getDisplayName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"language.displayName");
        String name = string;
        if (language2rankerCache.containsKey(name)) {
            return language2rankerCache.get(name);
        }
        Function0<LanguageCompletionRanker> rankerFactory = language2rankerFactory.get(name);
        if (rankerFactory == null) {
            languageRanker = null;
        } else {
            LanguageCompletionRanker languageCompletionRanker = this.tryBuild(rankerFactory, name);
            if (languageCompletionRanker != null) {
                LanguageCompletionRanker languageCompletionRanker2 = languageCompletionRanker;
                boolean bl = false;
                boolean bl2 = false;
                LanguageCompletionRanker it = languageCompletionRanker2;
                boolean bl3 = false;
                languageRanker = new LanguageRanker(name, it);
            } else {
                languageRanker = null;
            }
        }
        LanguageRanker ranker = languageRanker;
        language2rankerCache.put(name, ranker);
        return ranker;
    }

    @NotNull
    public final List<String> availableLanguages() {
        return CollectionsKt.toList((Iterable)language2rankerFactory.keySet());
    }

    private final LanguageCompletionRanker tryBuild(@NotNull Function0<? extends LanguageCompletionRanker> $this$tryBuild, String name) {
        try {
            return (LanguageCompletionRanker)$this$tryBuild.invoke();
        }
        catch (Exception e) {
            LOG.error("Failed to initialize '" + name + "' ranker", (Throwable)e);
            return null;
        }
    }

    private RankingSupport() {
    }

    static {
        RankingSupport rankingSupport;
        INSTANCE = rankingSupport = new RankingSupport();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RankingSupport.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
        language2rankerFactory = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"Java", (Object)((Object)language2rankerFactory.1.INSTANCE)), TuplesKt.to((Object)"Kotlin", (Object)((Object)language2rankerFactory.2.INSTANCE)), TuplesKt.to((Object)"Python", (Object)((Object)language2rankerFactory.3.INSTANCE))});
        boolean bl = false;
        language2rankerCache = new LinkedHashMap();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J0\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u000e2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000eJ\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013J\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/completion/sorting/RankingSupport$LanguageRanker;", "", "displayName", "", "ranker", "Lcom/jetbrains/completion/ranker/LanguageCompletionRanker;", "(Ljava/lang/String;Lcom/jetbrains/completion/ranker/LanguageCompletionRanker;)V", "getDisplayName", "()Ljava/lang/String;", "transformer", "Lcom/jetbrains/completion/feature/impl/FeatureTransformer;", "rank", "", "relevance", "", "userFactors", "unknownFeatures", "", "features", "", "version", "intellij.statsCollector"})
    public static final class LanguageRanker {
        private final FeatureTransformer transformer;
        @NotNull
        private final String displayName;
        private final LanguageCompletionRanker ranker;

        public final double rank(@NotNull Map<String, ? extends Object> relevance, @NotNull Map<String, ? extends Object> userFactors) {
            Intrinsics.checkParameterIsNotNull(relevance, (String)"relevance");
            Intrinsics.checkParameterIsNotNull(userFactors, (String)"userFactors");
            return this.ranker.rank(this.transformer.featureArray(relevance, userFactors));
        }

        @NotNull
        public final List<String> unknownFeatures(@NotNull Set<String> features) {
            Intrinsics.checkParameterIsNotNull(features, (String)"features");
            return this.ranker.getModelMetadata().unknownFeatures(features);
        }

        @Nullable
        public final String version() {
            return this.ranker.getModelMetadata().getVersion();
        }

        @NotNull
        public final String getDisplayName() {
            return this.displayName;
        }

        public LanguageRanker(@NotNull String displayName, @NotNull LanguageCompletionRanker ranker) {
            Intrinsics.checkParameterIsNotNull((Object)displayName, (String)"displayName");
            Intrinsics.checkParameterIsNotNull((Object)ranker, (String)"ranker");
            this.displayName = displayName;
            this.ranker = ranker;
            this.transformer = this.ranker.getModelMetadata().createTransformer();
        }
    }
}

