/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi.refactoring.rename;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.regexp.RegExpCapability;
import org.intellij.lang.regexp.RegExpLexer;
import org.intellij.lang.regexp.RegExpTT;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;
import org.jetbrains.plugins.cucumber.steps.reference.CucumberStepReference;

public class CucumberStepRenameProcessor
extends RenamePsiElementProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            CucumberStepRenameProcessor.$$$reportNull$$$0(0);
        }
        return element instanceof GherkinStep || PsiTreeUtil.getParentOfType((PsiElement)element, GherkinStep.class) != null;
    }

    public static CucumberStepReference getCucumberStepReference(PsiElement element) {
        for (PsiReference ref : element.getReferences()) {
            if (!(ref instanceof CucumberStepReference)) continue;
            return (CucumberStepReference)ref;
        }
        return null;
    }

    @NotNull
    public static List<String> prepareRegexAndGetStaticTexts(@NotNull String source) {
        if (source == null) {
            CucumberStepRenameProcessor.$$$reportNull$$$0(1);
        }
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder preparedRegexp = new StringBuilder();
        RegExpLexer lexer = new RegExpLexer(EnumSet.noneOf(RegExpCapability.class));
        lexer.start((CharSequence)source);
        IElementType previous = null;
        TokenSet toSkip = TokenSet.create((IElementType[])new IElementType[]{RegExpTT.CHARACTER, RegExpTT.CARET, RegExpTT.DOLLAR, RegExpTT.REDUNDANT_ESCAPE});
        StringBuilder currentStaticText = new StringBuilder();
        boolean insideAddedGroup = false;
        Stack<IElementType> elementsWaitingToClose = new Stack<IElementType>();
        while (lexer.getTokenType() != null) {
            if (!toSkip.contains(lexer.getTokenType())) {
                if (!insideAddedGroup) {
                    insideAddedGroup = true;
                    preparedRegexp.append('(');
                    result.add(currentStaticText.toString());
                    currentStaticText = new StringBuilder();
                }
                if (lexer.getTokenType() == RegExpTT.GROUP_BEGIN || lexer.getTokenType() == RegExpTT.NON_CAPT_GROUP) {
                    elementsWaitingToClose.push(RegExpTT.GROUP_END);
                } else if (lexer.getTokenType() == RegExpTT.CLASS_BEGIN) {
                    elementsWaitingToClose.push(RegExpTT.CLASS_END);
                } else if (elementsWaitingToClose.size() > 0 && lexer.getTokenType() == elementsWaitingToClose.peek()) {
                    elementsWaitingToClose.pop();
                }
            } else if (elementsWaitingToClose.size() == 0) {
                if (previous != null && previous != RegExpTT.CHARACTER && insideAddedGroup) {
                    insideAddedGroup = false;
                    preparedRegexp.append(')');
                }
                if (lexer.getTokenType() == RegExpTT.CHARACTER) {
                    currentStaticText.append(lexer.getTokenText());
                }
            }
            preparedRegexp.append(lexer.getTokenText());
            if (lexer.getTokenType() == RegExpTT.GROUP_BEGIN) {
                preparedRegexp.append("?:");
            }
            previous = lexer.getTokenType();
            lexer.advance();
        }
        if (insideAddedGroup) {
            preparedRegexp.append(')');
        }
        result.add(currentStaticText.toString());
        result.add(0, preparedRegexp.toString());
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            CucumberStepRenameProcessor.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static String getNewStepName(String oldStepName, Pattern oldStepDefPattern, List<String> newStaticTexts) {
        Matcher matcher = oldStepDefPattern.matcher(oldStepName);
        if (matcher.find()) {
            ArrayList<String> values = new ArrayList<String>();
            for (int i = 0; i < matcher.groupCount(); ++i) {
                values.add(matcher.group(i + 1));
            }
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < values.size(); ++i) {
                result.append(newStaticTexts.get(i + 1));
                result.append((String)values.get(i));
            }
            result.append(newStaticTexts.get(newStaticTexts.size() - 1));
            return result.toString();
        }
        return null;
    }

    public void renameElement(@NotNull PsiElement element, @NotNull String newName, @NotNull UsageInfo[] usages, @Nullable RefactoringElementListener listener) throws IncorrectOperationException {
        AbstractStepDefinition stepDefinition;
        CucumberStepReference reference;
        if (element == null) {
            CucumberStepRenameProcessor.$$$reportNull$$$0(3);
        }
        if (newName == null) {
            CucumberStepRenameProcessor.$$$reportNull$$$0(4);
        }
        if (usages == null) {
            CucumberStepRenameProcessor.$$$reportNull$$$0(5);
        }
        if ((reference = CucumberStepRenameProcessor.getCucumberStepReference(element)) != null && (stepDefinition = reference.resolveToDefinition()) != null) {
            PsiElement elementToRename = stepDefinition.getElement();
            List<String> newStaticTexts = CucumberStepRenameProcessor.prepareRegexAndGetStaticTexts(newName);
            String oldStepDefPatternText = stepDefinition.getCucumberRegex();
            if (oldStepDefPatternText != null) {
                Pattern oldStepDefPattern = Pattern.compile(CucumberStepRenameProcessor.prepareRegexAndGetStaticTexts(oldStepDefPatternText).get(0));
                for (UsageInfo usage : usages) {
                    PsiElement possibleStep = usage.getElement();
                    if (!(possibleStep instanceof GherkinStep)) continue;
                    String oldStepName = ((GherkinStep)possibleStep).getStepName();
                    String newStepName = CucumberStepRenameProcessor.getNewStepName(oldStepName, oldStepDefPattern, newStaticTexts);
                    ((GherkinStep)possibleStep).setName(newStepName);
                }
                String prefix = oldStepDefPatternText.startsWith("^") ? "^" : "";
                String suffix = oldStepDefPatternText.endsWith("$") ? "$" : "";
                stepDefinition.setCucumberRegex(prefix + newName + suffix);
                if (listener != null && elementToRename != null) {
                    listener.elementRenamed(elementToRename);
                }
            }
        }
    }

    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element, @NotNull SearchScope searchScope, boolean searchInCommentsAndStrings) {
        if (element == null) {
            CucumberStepRenameProcessor.$$$reportNull$$$0(6);
        }
        if (searchScope == null) {
            CucumberStepRenameProcessor.$$$reportNull$$$0(7);
        }
        List<PsiReference> list = Arrays.asList(element.getReferences());
        if (list == null) {
            CucumberStepRenameProcessor.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/psi/refactoring/rename/CucumberStepRenameProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/psi/refactoring/rename/CucumberStepRenameProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareRegexAndGetStaticTexts";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canProcessElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "prepareRegexAndGetStaticTexts";
                break;
            }
            case 2: 
            case 8: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "renameElement";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findReferences";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

