/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.intellij.datalore.actions.publishing.handlers;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.intellij.datalore.DataloreBundle;
import com.jetbrains.intellij.datalore.actions.publishing.handlers.PublishingActionWithResultHandler;
import com.jetbrains.intellij.datalore.actions.publishing.handlers.PublishingUploadHandler;
import com.jetbrains.intellij.datalore.actions.publishing.handlers.UploadFailedException;
import com.jetbrains.intellij.datalore.api.InvalidTokenException;
import com.jetbrains.intellij.datalore.config.PluginConfig;
import com.jetbrains.intellij.datalore.forms.PublishingUploadDialog;
import com.jetbrains.intellij.datalore.models.DatalorePublishingWorkbookResponse;
import com.jetbrains.intellij.datalore.services.AuthService;
import com.jetbrains.intellij.datalore.services.PublishingService;
import com.jetbrains.intellij.datalore.statistics.DataloreActionsCounterCollector;
import com.jetbrains.intellij.datalore.statistics.LoggedActionWithResult;
import com.jetbrains.intellij.datalore.util.BackgroundableCancellableTaskWithTimer;
import com.jetbrains.intellij.datalore.util.StringUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/intellij/datalore/actions/publishing/handlers/PublishingUploadHandler;", "Lcom/jetbrains/intellij/datalore/actions/publishing/handlers/PublishingActionWithResultHandler;", "project", "Lcom/intellij/openapi/project/Project;", "notebook", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "myPluginConfig", "Lcom/jetbrains/intellij/datalore/config/PluginConfig;", "handle", "", "upload", "datalore-intellij-plugin"})
public final class PublishingUploadHandler
extends PublishingActionWithResultHandler {
    private final PluginConfig myPluginConfig;

    @Override
    public void handle() {
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this){
            final /* synthetic */ PublishingUploadHandler this$0;

            public final void run() {
                try {
                    PublishingService.PublishedNotebookState state = this.this$0.getMyPublishingService().getNotebookState(this.this$0.getMyNotebook());
                    if (state == null) {
                        ApplicationManager.getApplication().invokeAndWait(new Runnable(this){
                            final /* synthetic */ handle.1 this$0;

                            public final void run() {
                                PublishingUploadHandler.access$upload(this.this$0.this$0);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                }
                catch (InvalidTokenException e) {
                    DataloreActionsCounterCollector.INSTANCE.countError(LoggedActionWithResult.UPLOAD);
                    this.this$0.getMyAuthService().fireInvalidTokenNotification(this.this$0.getMyProject());
                }
            }
            {
                this.this$0 = publishingUploadHandler;
            }
        });
    }

    private final void upload() {
        PublishingUploadDialog uploadDialog;
        boolean ok;
        if (this.myPluginConfig.getShowUploadDialog() && !(ok = (uploadDialog = new PublishingUploadDialog(this.getMyProject(), this.getMyNotebook())).showAndGet())) {
            return;
        }
        CloseableHttpClient client = HttpClients.createDefault();
        BackgroundableCancellableTaskWithTimer uploadTask2 = new BackgroundableCancellableTaskWithTimer(this, client, this.getMyProject(), DataloreBundle.INSTANCE.message("datalore.publishing.upload.progress", this.getMyNotebookTrimmedName())){
            final /* synthetic */ PublishingUploadHandler this$0;
            final /* synthetic */ CloseableHttpClient $client;

            protected void doRun(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                indicator.setIndeterminate(true);
                try {
                    PublishingService publishingService = this.this$0.getMyPublishingService();
                    VirtualFile virtualFile = this.this$0.getMyNotebook();
                    CloseableHttpClient closeableHttpClient = this.$client;
                    Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpClient, (String)"client");
                    DatalorePublishingWorkbookResponse datalorePublishingWorkbookResponse = publishingService.callUpload(virtualFile, false, closeableHttpClient);
                    if (datalorePublishingWorkbookResponse == null) {
                        throw (Throwable)new UploadFailedException();
                    }
                    DatalorePublishingWorkbookResponse response = datalorePublishingWorkbookResponse;
                    this.this$0.getMyPublishingService().updateNotebookMapping(this.this$0.getMyNotebook(), response.getNotebookMeta());
                }
                catch (InvalidTokenException e) {
                    AuthService authService = this.this$0.getMyAuthService();
                    Project project = this.myProject;
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"myProject");
                    authService.fireInvalidTokenNotification(project);
                    throw (Throwable)e;
                }
            }

            protected void doOnCancel() {
                DataloreActionsCounterCollector.INSTANCE.countCancel(LoggedActionWithResult.UPLOAD);
                this.$client.close();
            }

            public void onSuccess() {
                super.onSuccess();
                PublishingService.PublishedNotebookState notebookState = this.this$0.getMyPublishingService().getNotebookState(this.this$0.getMyNotebook());
                if (notebookState == null) {
                    DataloreActionsCounterCollector.INSTANCE.countError(LoggedActionWithResult.UPLOAD);
                    this.this$0.onFail();
                } else {
                    DataloreActionsCounterCollector.INSTANCE.countSuccess(LoggedActionWithResult.UPLOAD);
                    this.this$0.onSuccess(notebookState);
                }
            }

            public void onThrowable(@NotNull Throwable error) {
                Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                DataloreActionsCounterCollector.INSTANCE.countError(LoggedActionWithResult.UPLOAD);
                if (error instanceof UploadFailedException) {
                    this.this$0.onFail();
                }
                super.onThrowable(error);
            }
            {
                this.this$0 = $outer;
                this.$client = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, 0L, 0L, false, 28, null);
            }
        };
        uploadTask2.queue();
    }

    public PublishingUploadHandler(@NotNull Project project, @NotNull VirtualFile notebook) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)notebook, (String)"notebook");
        super(project, notebook, DataloreBundle.INSTANCE.message("datalore.publishing.upload.notification.ok.title", StringUtilKt.trimInMiddle$default(notebook, 0, 1, null)), DataloreBundle.INSTANCE.message("datalore.publishing.upload.notification.error.title", StringUtilKt.trimInMiddle(notebook, 23)), DataloreBundle.INSTANCE.message("datalore.publishing.upload.notification.error.description", new Object[0]));
        this.myPluginConfig = PluginConfig.Companion.getInstance();
    }

    public static final /* synthetic */ void access$upload(PublishingUploadHandler $this) {
        $this.upload();
    }
}

