/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.intellij.datalore.services;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0018\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u000e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u000e\u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0010"}, d2={"isCompiledPythonFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isExtension", "expectedExtension", "", "isFileToVisit", "isIPynbCheckpoint", "isIPynbFile", "isIPythonNotebook", "isIdeaFile", "isIgnoredFile", "project", "Lcom/intellij/openapi/project/Project;", "isVenvDir", "datalore-intellij-plugin"})
public final class FiltersKt {
    public static final boolean isIdeaFile(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        boolean bl = false;
        boolean bl2 = false;
        VirtualFile $this$with = file;
        boolean bl3 = false;
        String string = $this$with.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path");
        return StringsKt.contains$default((CharSequence)string, (CharSequence)".idea", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)$this$with.getName(), (Object)".datalore") || FiltersKt.isExtension($this$with, "iml");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isVenvDir(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        boolean bl = false;
        boolean bl2 = false;
        VirtualFile $this$with = file;
        boolean bl3 = false;
        if (!$this$with.isDirectory()) return false;
        VirtualFile[] virtualFileArray = $this$with.getChildren();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"children");
        VirtualFile[] $this$any$iv = virtualFileArray;
        boolean $i$f$any = false;
        VirtualFile[] virtualFileArray2 = $this$any$iv;
        int n = virtualFileArray2.length;
        int n2 = 0;
        while (n2 < n) {
            VirtualFile element$iv;
            VirtualFile it = element$iv = virtualFileArray2[n2];
            boolean bl4 = false;
            VirtualFile virtualFile = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"it");
            if (Intrinsics.areEqual((Object)virtualFile.getName(), (Object)"pyvenv.cfg")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static final boolean isCompiledPythonFile(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return FiltersKt.isExtension(file, "pyc");
    }

    public static final boolean isIgnoredFile(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
        ProjectFileIndex projectFileIndex = projectRootManager.getFileIndex();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectFileIndex, (String)"ProjectRootManager.getInstance(project).fileIndex");
        ProjectFileIndex fileIndex = projectFileIndex;
        return fileIndex.isExcluded(file) || FiltersKt.isIdeaFile(file) || FiltersKt.isIPynbCheckpoint(file) || FiltersKt.isIPynbFile(file) || FiltersKt.isCompiledPythonFile(file) || file.isDirectory();
    }

    public static final boolean isIPythonNotebook(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return FiltersKt.isIPynbFile(file) && !FiltersKt.isIPynbCheckpoint(file);
    }

    public static final boolean isFileToVisit(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return !FiltersKt.isIdeaFile(file) && !FiltersKt.isVenvDir(file);
    }

    private static final boolean isIPynbCheckpoint(VirtualFile file) {
        String string = file.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
        return StringsKt.contains$default((CharSequence)string, (CharSequence)".ipynb_checkpoints", (boolean)false, (int)2, null);
    }

    private static final boolean isIPynbFile(VirtualFile file) {
        return FiltersKt.isExtension(file, "ipynb");
    }

    private static final boolean isExtension(VirtualFile file, String expectedExtension) {
        boolean bl = false;
        boolean bl2 = false;
        VirtualFile $this$with = file;
        boolean bl3 = false;
        return $this$with.getExtension() != null && Intrinsics.areEqual((Object)$this$with.getExtension(), (Object)expectedExtension);
    }
}

