/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.intellij.datalore.services;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.PersistentStateComponentWithModificationTracker;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.jetbrains.intellij.datalore.DataloreBundle;
import com.jetbrains.intellij.datalore.actions.publishing.handlers.PublishingUploadHandler;
import com.jetbrains.intellij.datalore.api.DataloreViewController;
import com.jetbrains.intellij.datalore.api.InvalidTokenException;
import com.jetbrains.intellij.datalore.api.NotExistingNotebookException;
import com.jetbrains.intellij.datalore.models.DatalorePublishingContext;
import com.jetbrains.intellij.datalore.models.DatalorePublishingNotebookMeta;
import com.jetbrains.intellij.datalore.models.DatalorePublishingWorkbookResponse;
import com.jetbrains.intellij.datalore.models.DataloreUpdatePrivacyContext;
import com.jetbrains.intellij.datalore.models.DataloreUpdatePublishingContext;
import com.jetbrains.intellij.datalore.services.AuthService;
import com.jetbrains.intellij.datalore.services.PublishingService;
import com.jetbrains.intellij.datalore.util.DataloreIconsKt;
import com.jetbrains.intellij.datalore.util.NotificationUtil;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DatalorePublishingService", storages={@Storage(value="datalore.xml", roamingType=RoamingType.DISABLED)})
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0007\u0018\u0000 12\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003123B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010J \u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\nJ\n\u0010\u001c\u001a\u0004\u0018\u00010\u0002H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u000e\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\nJ\u000e\u0010 \u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\nJ\u000e\u0010!\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\nJ\u0010\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u0002H\u0016J)\u0010$\u001a\u0002H%\"\u0004\b\u0000\u0010%2\u0006\u0010\u000e\u001a\u00020\n2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H%0'H\u0002\u00a2\u0006\u0002\u0010(J\u000e\u0010)\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\nJ\u0016\u0010*\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010+\u001a\u00020,J\u0016\u0010*\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010-\u001a\u00020\rJ \u0010.\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0016J\f\u0010/\u001a\u000200*\u00020\nH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/jetbrains/intellij/datalore/services/PublishingService;", "Lcom/intellij/openapi/components/PersistentStateComponentWithModificationTracker;", "Lcom/jetbrains/intellij/datalore/services/PublishingService$PublishingState;", "myProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "myAuthService", "Lcom/jetbrains/intellij/datalore/services/AuthService;", "myNotebookActionLocks", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "myState", "callUpdate", "Lcom/jetbrains/intellij/datalore/services/PublishingService$PublishedNotebookState;", "notebookFile", "client", "Lorg/apache/http/impl/client/CloseableHttpClient;", "callUpload", "Lcom/jetbrains/intellij/datalore/models/DatalorePublishingWorkbookResponse;", "public", "", "fetchAndUpdateNotebookStatus", "Lorg/apache/http/client/HttpClient;", "fireNotebookDeletedNotification", "", "title", "", "getNotebookState", "getState", "getStateModificationCount", "", "isLocked", "isUploadedBySomeone", "isUploadedForOwner", "loadState", "state", "publishAction", "T", "body", "Lkotlin/Function0;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "removeNotebookState", "updateNotebookMapping", "meta", "Lcom/jetbrains/intellij/datalore/models/DatalorePublishingNotebookMeta;", "newState", "updatePrivacy", "getFileId", "", "Companion", "PublishedNotebookState", "PublishingState", "datalore-intellij-plugin"})
public final class PublishingService
implements PersistentStateComponentWithModificationTracker<PublishingState> {
    private PublishingState myState;
    private final AuthService myAuthService;
    private final Set<VirtualFile> myNotebookActionLocks;
    private final Project myProject;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final DatalorePublishingWorkbookResponse callUpload(@NotNull VirtualFile notebookFile, boolean bl, @NotNull CloseableHttpClient client) {
        Intrinsics.checkParameterIsNotNull((Object)notebookFile, (String)"notebookFile");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        String string = this.myAuthService.getPublishingToken();
        if (string == null) {
            return null;
        }
        String token = string;
        return (DatalorePublishingWorkbookResponse)this.publishAction(notebookFile, (Function0)new Function0<DatalorePublishingWorkbookResponse>(notebookFile, token, bl, client){
            final /* synthetic */ VirtualFile $notebookFile;
            final /* synthetic */ String $token;
            final /* synthetic */ boolean $public;
            final /* synthetic */ CloseableHttpClient $client;

            @Nullable
            public final DatalorePublishingWorkbookResponse invoke() {
                DatalorePublishingWorkbookResponse datalorePublishingWorkbookResponse;
                String string = DataloreViewController.INSTANCE.callUpload(new DatalorePublishingContext(this.$notebookFile, this.$token, this.$public), (HttpClient)this.$client);
                if (string != null) {
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String response = string2;
                    boolean bl3 = false;
                    datalorePublishingWorkbookResponse = DatalorePublishingWorkbookResponse.Companion.fromString(response);
                } else {
                    datalorePublishingWorkbookResponse = null;
                }
                return datalorePublishingWorkbookResponse;
            }
            {
                this.$notebookFile = virtualFile;
                this.$token = string;
                this.$public = bl;
                this.$client = closeableHttpClient;
                super(0);
            }
        });
    }

    @Nullable
    public final PublishedNotebookState callUpdate(@NotNull VirtualFile notebookFile, @NotNull CloseableHttpClient client) {
        Intrinsics.checkParameterIsNotNull((Object)notebookFile, (String)"notebookFile");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        String string = this.myAuthService.getPublishingToken();
        if (string == null) {
            return null;
        }
        String token = string;
        PublishedNotebookState publishedNotebookState = this.getNotebookState(notebookFile);
        if (publishedNotebookState == null) {
            return null;
        }
        PublishedNotebookState state = publishedNotebookState;
        return (PublishedNotebookState)((Object)this.publishAction(notebookFile, (Function0)new Function0<PublishedNotebookState>(this, notebookFile, token, state, client){
            final /* synthetic */ PublishingService this$0;
            final /* synthetic */ VirtualFile $notebookFile;
            final /* synthetic */ String $token;
            final /* synthetic */ PublishedNotebookState $state;
            final /* synthetic */ CloseableHttpClient $client;

            @Nullable
            public final PublishedNotebookState invoke() {
                PublishedNotebookState publishedNotebookState;
                String string = DataloreViewController.INSTANCE.callUpdate(new DataloreUpdatePublishingContext(this.$notebookFile, this.$token, this.$state.getId(), this.$state.getPublic()), (HttpClient)this.$client);
                if (string != null) {
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String response = string2;
                    boolean bl3 = false;
                    DatalorePublishingNotebookMeta meta = DatalorePublishingNotebookMeta.Companion.fromString(response);
                    publishedNotebookState = this.this$0.updateNotebookMapping(this.$notebookFile, meta);
                } else {
                    publishedNotebookState = null;
                }
                return publishedNotebookState;
            }
            {
                this.this$0 = publishingService;
                this.$notebookFile = virtualFile;
                this.$token = string;
                this.$state = publishedNotebookState;
                this.$client = closeableHttpClient;
                super(0);
            }
        }));
    }

    @Nullable
    public final PublishedNotebookState fetchAndUpdateNotebookStatus(@NotNull VirtualFile notebookFile, @NotNull HttpClient client) {
        Intrinsics.checkParameterIsNotNull((Object)notebookFile, (String)"notebookFile");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        String string = this.myAuthService.getPublishingToken();
        if (string == null) {
            return null;
        }
        String token = string;
        PublishedNotebookState publishedNotebookState = this.getNotebookState(notebookFile);
        if (publishedNotebookState == null) {
            return null;
        }
        PublishedNotebookState state = publishedNotebookState;
        return (PublishedNotebookState)((Object)this.publishAction(notebookFile, (Function0)new Function0<PublishedNotebookState>(this, state, token, client, notebookFile){
            final /* synthetic */ PublishingService this$0;
            final /* synthetic */ PublishedNotebookState $state;
            final /* synthetic */ String $token;
            final /* synthetic */ HttpClient $client;
            final /* synthetic */ VirtualFile $notebookFile;

            @Nullable
            public final PublishedNotebookState invoke() {
                PublishedNotebookState publishedNotebookState;
                String string = DataloreViewController.INSTANCE.callGetMeta(this.$state.getId(), this.$token, this.$client);
                if (string != null) {
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String response = string2;
                    boolean bl3 = false;
                    DatalorePublishingNotebookMeta meta = DatalorePublishingNotebookMeta.Companion.fromString(response);
                    publishedNotebookState = this.this$0.updateNotebookMapping(this.$notebookFile, meta);
                } else {
                    publishedNotebookState = null;
                }
                return publishedNotebookState;
            }
            {
                this.this$0 = publishingService;
                this.$state = publishedNotebookState;
                this.$token = string;
                this.$client = httpClient;
                this.$notebookFile = virtualFile;
                super(0);
            }
        }));
    }

    @Nullable
    public final PublishedNotebookState updatePrivacy(@NotNull VirtualFile notebookFile, boolean bl, @NotNull HttpClient client) {
        Intrinsics.checkParameterIsNotNull((Object)notebookFile, (String)"notebookFile");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        String string = this.myAuthService.getPublishingToken();
        if (string == null) {
            return null;
        }
        String token = string;
        PublishedNotebookState publishedNotebookState = this.getNotebookState(notebookFile);
        if (publishedNotebookState == null) {
            return null;
        }
        PublishedNotebookState state = publishedNotebookState;
        return (PublishedNotebookState)((Object)this.publishAction(notebookFile, (Function0)new Function0<PublishedNotebookState>(this, state, bl, token, client, notebookFile){
            final /* synthetic */ PublishingService this$0;
            final /* synthetic */ PublishedNotebookState $state;
            final /* synthetic */ boolean $public;
            final /* synthetic */ String $token;
            final /* synthetic */ HttpClient $client;
            final /* synthetic */ VirtualFile $notebookFile;

            @NotNull
            public final PublishedNotebookState invoke() {
                DataloreViewController.INSTANCE.callUpdatePrivacy(new DataloreUpdatePrivacyContext(this.$state.getId(), this.$public, this.$token), this.$client);
                PublishedNotebookState publishedNotebookState = this.$state;
                VirtualFile virtualFile = this.$notebookFile;
                PublishingService publishingService = this.this$0;
                boolean bl = false;
                boolean bl2 = false;
                PublishedNotebookState $this$apply = publishedNotebookState;
                boolean bl3 = false;
                $this$apply.setPublic(this.$public);
                PublishedNotebookState publishedNotebookState2 = publishedNotebookState;
                return publishingService.updateNotebookMapping(virtualFile, publishedNotebookState2);
            }
            {
                this.this$0 = publishingService;
                this.$state = publishedNotebookState;
                this.$public = bl;
                this.$token = string;
                this.$client = httpClient;
                this.$notebookFile = virtualFile;
                super(0);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T publishAction(VirtualFile notebookFile, Function0<? extends T> body) {
        Object object;
        try {
            this.myNotebookActionLocks.add(notebookFile);
            object = body.invoke();
        }
        catch (NotExistingNotebookException e) {
            this.removeNotebookState(notebookFile);
            throw (Throwable)e;
        }
        catch (InvalidTokenException e) {
            this.myAuthService.publishingSignOut();
            throw (Throwable)e;
        }
        finally {
            this.myNotebookActionLocks.remove(notebookFile);
        }
        return (T)object;
    }

    @Nullable
    public PublishingState getState() {
        return this.myState;
    }

    public void loadState(@NotNull PublishingState state) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)state), (String)"state");
        this.myState = state;
    }

    public long getStateModificationCount() {
        return this.myState.getModificationCount();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PublishedNotebookState updateNotebookMapping(@NotNull VirtualFile notebookFile, @NotNull PublishedNotebookState newState) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkParameterIsNotNull((Object)notebookFile, (String)"notebookFile");
        Intrinsics.checkParameterIsNotNull((Object)((Object)newState), (String)"newState");
        Map<Integer, Map<String, PublishedNotebookState>> map = this.myState.getNotebookMapping();
        Integer key$iv = this.getFileId(notebookFile);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            boolean bl2 = false;
            Map answer$iv = new LinkedHashMap();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        Map files = (Map)object;
        files.put(newState.getOwner(), newState);
        this.myState.intIncrementModificationCount();
        return newState;
    }

    @NotNull
    public final PublishedNotebookState updateNotebookMapping(@NotNull VirtualFile notebookFile, @NotNull DatalorePublishingNotebookMeta meta) {
        Intrinsics.checkParameterIsNotNull((Object)notebookFile, (String)"notebookFile");
        Intrinsics.checkParameterIsNotNull((Object)meta, (String)"meta");
        return this.updateNotebookMapping(notebookFile, PublishedNotebookState.Companion.fromMeta(meta));
    }

    @Nullable
    public final PublishedNotebookState getNotebookState(@NotNull VirtualFile notebookFile) {
        Intrinsics.checkParameterIsNotNull((Object)notebookFile, (String)"notebookFile");
        String string = this.myAuthService.getPublishingTokenOwner();
        if (string == null) {
            return null;
        }
        String owner2 = string;
        Map<String, PublishedNotebookState> map = this.myState.getNotebookMapping().get(this.getFileId(notebookFile));
        return map != null ? map.get(owner2) : null;
    }

    public final void removeNotebookState(@NotNull VirtualFile notebookFile) {
        Intrinsics.checkParameterIsNotNull((Object)notebookFile, (String)"notebookFile");
        String string = this.myAuthService.getPublishingTokenOwner();
        if (string == null) {
            return;
        }
        String owner2 = string;
        Map<String, PublishedNotebookState> map = this.myState.getNotebookMapping().get(this.getFileId(notebookFile));
        PublishedNotebookState publishedNotebookState = map != null ? map.remove(owner2) : null;
        boolean bl = false;
        boolean bl2 = false;
        PublishedNotebookState it = publishedNotebookState;
        boolean bl3 = false;
        this.myState.intIncrementModificationCount();
    }

    public final boolean isUploadedForOwner(@NotNull VirtualFile notebookFile) {
        Intrinsics.checkParameterIsNotNull((Object)notebookFile, (String)"notebookFile");
        String string = this.myAuthService.getPublishingTokenOwner();
        if (string == null) {
            return false;
        }
        String owner2 = string;
        Map<String, PublishedNotebookState> map = this.myState.getNotebookMapping().get(this.getFileId(notebookFile));
        return map != null ? map.containsKey(owner2) : false;
    }

    public final boolean isUploadedBySomeone(@NotNull VirtualFile notebookFile) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)notebookFile, (String)"notebookFile");
        Map<String, PublishedNotebookState> map = this.myState.getNotebookMapping().get(this.getFileId(notebookFile));
        if (map != null) {
            Map<String, PublishedNotebookState> map2 = map;
            boolean bl2 = false;
            bl = !map2.isEmpty();
        } else {
            bl = false;
        }
        return bl;
    }

    public final void fireNotebookDeletedNotification(@NotNull VirtualFile notebookFile, @NotNull String title) {
        Intrinsics.checkParameterIsNotNull((Object)notebookFile, (String)"notebookFile");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Notification notification = new Notification(NotificationUtil.INSTANCE.getDATALORE_NOTIFICATION_GROUP().getDisplayId(), DataloreIconsKt.getFAIL_ICON(), title, null, DataloreBundle.INSTANCE.message("datalore.publishing.common.notification.deleted.description", new Object[0]), NotificationType.WARNING, null);
        notification.addAction(new AnAction(this, notebookFile, DataloreBundle.INSTANCE.message("datalore.publishing.common.notification.deleted.upload_again", new Object[0])){
            final /* synthetic */ PublishingService this$0;
            final /* synthetic */ VirtualFile $notebookFile;

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                new PublishingUploadHandler(PublishingService.access$getMyProject$p(this.this$0), this.$notebookFile).handle();
            }
            {
                this.this$0 = $outer;
                this.$notebookFile = $captured_local_variable$1;
                super($super_call_param$2);
            }
        });
        notification.notify(this.myProject);
    }

    public final boolean isLocked(@NotNull VirtualFile notebookFile) {
        Intrinsics.checkParameterIsNotNull((Object)notebookFile, (String)"notebookFile");
        return this.myNotebookActionLocks.contains(notebookFile);
    }

    private final int getFileId(@NotNull VirtualFile $this$getFileId) {
        VirtualFile virtualFile = $this$getFileId;
        if (virtualFile == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.vfs.VirtualFileWithId");
        }
        return ((VirtualFileWithId)virtualFile).getId();
    }

    public PublishingService(@NotNull Project myProject) {
        Set set;
        Intrinsics.checkParameterIsNotNull((Object)myProject, (String)"myProject");
        this.myProject = myProject;
        this.myState = new PublishingState();
        this.myAuthService = AuthService.Companion.getInstance();
        PublishingService publishingService = this;
        boolean bl = false;
        publishingService.myNotebookActionLocks = set = (Set)new LinkedHashSet();
    }

    public static final /* synthetic */ Project access$getMyProject$p(PublishingService $this) {
        return $this.myProject;
    }

    @JvmStatic
    @NotNull
    public static final PublishingService getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R[\u0010\b\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00040\u00042\u001e\u0010\u0003\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00040\u00048F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/intellij/datalore/services/PublishingService$PublishingState;", "Lcom/intellij/openapi/components/BaseState;", "()V", "<set-?>", "", "", "", "Lcom/jetbrains/intellij/datalore/services/PublishingService$PublishedNotebookState;", "notebookMapping", "getNotebookMapping", "()Ljava/util/Map;", "setNotebookMapping", "(Ljava/util/Map;)V", "notebookMapping$delegate", "Lkotlin/properties/ReadWriteProperty;", "datalore-intellij-plugin"})
    public static final class PublishingState
    extends BaseState {
        static final /* synthetic */ KProperty[] $$delegatedProperties;
        @NotNull
        private final ReadWriteProperty notebookMapping$delegate = this.map().provideDelegate((Object)this, $$delegatedProperties[0]);

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(PublishingState.class), "notebookMapping", "getNotebookMapping()Ljava/util/Map;"))};
        }

        @NotNull
        public final Map<Integer, Map<String, PublishedNotebookState>> getNotebookMapping() {
            return (Map)this.notebookMapping$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        public final void setNotebookMapping(@NotNull Map<Integer, Map<String, PublishedNotebookState>> map) {
            Intrinsics.checkParameterIsNotNull(map, (String)"<set-?>");
            this.notebookMapping$delegate.setValue((Object)this, $$delegatedProperties[0], map);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002R+\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\n\u0010\u000b\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR+\u0010\f\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u000b\u001a\u0004\b\r\u0010\u0007\"\u0004\b\u000e\u0010\tR+\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u000b\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\tR+\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0003\u001a\u00020\u00148F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\u000b\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/intellij/datalore/services/PublishingService$PublishedNotebookState;", "Lcom/intellij/openapi/components/BaseState;", "()V", "<set-?>", "", "id", "getId", "()Ljava/lang/String;", "setId", "(Ljava/lang/String;)V", "id$delegate", "Lkotlin/properties/ReadWriteProperty;", "link", "getLink", "setLink", "link$delegate", "owner", "getOwner", "setOwner", "owner$delegate", "", "public", "getPublic", "()Z", "setPublic", "(Z)V", "public$delegate", "Companion", "datalore-intellij-plugin"})
    public static final class PublishedNotebookState
    extends BaseState {
        static final /* synthetic */ KProperty[] $$delegatedProperties;
        @NotNull
        private final ReadWriteProperty id$delegate = this.property("", id.2.INSTANCE).provideDelegate((Object)this, $$delegatedProperties[0]);
        @NotNull
        private final ReadWriteProperty link$delegate = this.property("", link.2.INSTANCE).provideDelegate((Object)this, $$delegatedProperties[1]);
        @NotNull
        private final ReadWriteProperty public$delegate = this.property(false).provideDelegate((Object)this, $$delegatedProperties[2]);
        @NotNull
        private final ReadWriteProperty owner$delegate = this.property("", owner.2.INSTANCE).provideDelegate((Object)this, $$delegatedProperties[3]);
        public static final Companion Companion;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(PublishedNotebookState.class), "id", "getId()Ljava/lang/String;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(PublishedNotebookState.class), "link", "getLink()Ljava/lang/String;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(PublishedNotebookState.class), "public", "getPublic()Z")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(PublishedNotebookState.class), "owner", "getOwner()Ljava/lang/String;"))};
            Companion = new Companion(null);
        }

        @NotNull
        public final String getId() {
            return (String)this.id$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        public final void setId(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.id$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)string);
        }

        @NotNull
        public final String getLink() {
            return (String)this.link$delegate.getValue((Object)this, $$delegatedProperties[1]);
        }

        public final void setLink(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.link$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)string);
        }

        public final boolean getPublic() {
            return (Boolean)this.public$delegate.getValue((Object)this, $$delegatedProperties[2]);
        }

        public final void setPublic(boolean bl) {
            this.public$delegate.setValue((Object)this, $$delegatedProperties[2], (Object)bl);
        }

        @NotNull
        public final String getOwner() {
            return (String)this.owner$delegate.getValue((Object)this, $$delegatedProperties[3]);
        }

        public final void setOwner(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.owner$delegate.setValue((Object)this, $$delegatedProperties[3], (Object)string);
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/intellij/datalore/services/PublishingService$PublishedNotebookState$Companion;", "", "()V", "fromMeta", "Lcom/jetbrains/intellij/datalore/services/PublishingService$PublishedNotebookState;", "meta", "Lcom/jetbrains/intellij/datalore/models/DatalorePublishingNotebookMeta;", "datalore-intellij-plugin"})
        public static final class Companion {
            @NotNull
            public final PublishedNotebookState fromMeta(@NotNull DatalorePublishingNotebookMeta meta) {
                Intrinsics.checkParameterIsNotNull((Object)meta, (String)"meta");
                PublishedNotebookState publishedNotebookState = new PublishedNotebookState();
                boolean bl = false;
                boolean bl2 = false;
                PublishedNotebookState $this$apply = publishedNotebookState;
                boolean bl3 = false;
                $this$apply.setId(meta.getNotebookId());
                $this$apply.setLink(meta.getLink());
                $this$apply.setPublic(meta.getPublic());
                $this$apply.setOwner(meta.getOwner());
                return publishedNotebookState;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/intellij/datalore/services/PublishingService$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/intellij/datalore/services/PublishingService;", "project", "Lcom/intellij/openapi/project/Project;", "datalore-intellij-plugin"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final PublishingService getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            Object object = ServiceManager.getService((Project)$this$service$iv, PublishingService.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(this, T::class.java)");
            return (PublishingService)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

