/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.connections.execution;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.openapi.diagnostic.Logger;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MIME;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.jupyter.connections.JupyterConnectionParameters;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterRestClient;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterRestClient$getKernelSpecs$;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterRestClientErrorResponseException;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterRestClientException;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterRestClientForbiddenException;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterRestClientKt;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.JupyterErrorMessagesKt;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.JupyterServerErrorResponse;
import org.jetbrains.plugins.notebooks.jupyter.connections.http.DefaultHttpSession;
import org.jetbrains.plugins.notebooks.jupyter.connections.http.HttpSession;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u0000 02\u00020\u0001:\u00010B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fJ\u000e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fJ\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0018\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u000e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u000fJ\u000e\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u000fJ\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019J\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000fH\u0002J\u000e\u0010#\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u000fJ\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019J\u000e\u0010%\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fJ\u0006\u0010&\u001a\u00020'J$\u0010(\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020\u000f2\b\b\u0002\u0010*\u001a\u00020\u0017H\u0002J\u000e\u0010+\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u000fJ\u0016\u0010,\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u000fJ\u000e\u0010/\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fR\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/JupyterRestClient;", "", "connectionParameters", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/JupyterConnectionParameters;", "(Lorg/jetbrains/plugins/notebooks/jupyter/connections/JupyterConnectionParameters;)V", "httpSession", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/http/HttpSession;", "(Lorg/jetbrains/plugins/notebooks/jupyter/connections/http/HttpSession;)V", "executor", "Lorg/apache/http/client/fluent/Executor;", "getExecutor", "()Lorg/apache/http/client/fluent/Executor;", "delete", "", "endpoint", "", "id", "deleteKernel", "deleteSession", "executeAndCheck", "request", "Lorg/apache/http/client/fluent/Request;", "status", "", "get", "", "Lcom/google/gson/JsonObject;", "getKernel", "getKernelSpec", "name", "getKernelSpecs", "getKernels", "getRequestURI", "Ljava/net/URI;", "path", "getSession", "getSessions", "interruptKernel", "ping", "", "post", "body", "expectedStatus", "postKernel", "postSession", "kernelName", "notebookPath", "restartKernel", "Companion", "intellij.python.jupyter"})
public final class JupyterRestClient {
    private final HttpSession httpSession;
    private static final Gson gson;
    private static final Logger LOG;
    public static final Companion Companion;

    private final Executor getExecutor() {
        return this.httpSession.getHttpRequestsExecutor();
    }

    private final URI getRequestURI(String path) {
        URI baseURI = this.httpSession.getBaseURI();
        String string = baseURI.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"baseURI.path");
        String fullPath = JupyterRestClientKt.resolveURIPath(string, path);
        return new URI(baseURI.getScheme(), baseURI.getUserInfo(), baseURI.getHost(), baseURI.getPort(), fullPath, baseURI.getQuery(), baseURI.getFragment());
    }

    public final boolean ping() {
        boolean bl;
        try {
            Request request = Request.Get((URI)this.getRequestURI("/api/kernelspecs"));
            Intrinsics.checkExpressionValueIsNotNull((Object)request, (String)"Request.Get(getRequestURI(KERNELSPECS))");
            this.executeAndCheck(request, 200);
            bl = true;
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final List<JsonObject> getSessions() {
        return this.get("/api/sessions");
    }

    @NotNull
    public final JsonObject getSession(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        return this.get("/api/sessions", id);
    }

    @NotNull
    public final JsonObject postSession(@NotNull String kernelName, @NotNull String notebookPath) {
        String body;
        Intrinsics.checkParameterIsNotNull((Object)kernelName, (String)"kernelName");
        Intrinsics.checkParameterIsNotNull((Object)notebookPath, (String)"notebookPath");
        JsonObject jsonObject = new JsonObject();
        boolean bl = false;
        boolean bl2 = false;
        JsonObject $this$apply = jsonObject;
        boolean bl3 = false;
        $this$apply.addProperty("path", notebookPath);
        $this$apply.addProperty("type", "notebook");
        JsonObject jsonObject2 = new JsonObject();
        String string = "kernel";
        JsonObject jsonObject3 = $this$apply;
        boolean bl4 = false;
        boolean bl5 = false;
        JsonObject $this$apply2 = jsonObject2;
        boolean bl6 = false;
        $this$apply2.addProperty("name", kernelName);
        JsonObject jsonObject4 = jsonObject2;
        jsonObject3.add(string, (JsonElement)jsonObject4);
        bl = false;
        bl2 = false;
        JsonObject it = jsonObject;
        boolean bl7 = false;
        String string2 = body = gson.toJson((JsonElement)it);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"body");
        JsonObject jsonObject5 = JupyterRestClient.post$default(this, "/api/sessions", string2, 0, 4, null);
        if (jsonObject5 == null) {
            Intrinsics.throwNpe();
        }
        return jsonObject5;
    }

    public final void deleteSession(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        this.delete("/api/sessions", id);
    }

    @NotNull
    public final List<JsonObject> getKernelSpecs() {
        JsonElement jsonElement = this.get("/api/kernelspecs", "").get("kernelspecs");
        if (jsonElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.google.gson.JsonObject");
        }
        Set set = ((JsonObject)jsonElement).entrySet();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"(get(KERNELSPECS, \"\")[\"k\u2026as JsonObject).entrySet()");
        Sequence $this$filterIsInstance$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)set), (Function1)getKernelSpecs.1.INSTANCE);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)getKernelSpecs$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        return SequencesKt.toList((Sequence)sequence);
    }

    @NotNull
    public final JsonObject getKernelSpec(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return this.get("/api/kernelspecs", name);
    }

    @NotNull
    public final List<JsonObject> getKernels() {
        return this.get("/api/kernels");
    }

    @NotNull
    public final JsonObject getKernel(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        return this.get("/api/kernels", id);
    }

    @NotNull
    public final JsonObject postKernel(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        JsonObject jsonObject = new JsonObject();
        boolean bl = false;
        boolean bl2 = false;
        JsonObject $this$apply = jsonObject;
        boolean bl3 = false;
        $this$apply.addProperty("name", name);
        JsonObject body = jsonObject;
        String string = gson.toJson((JsonElement)body);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"gson.toJson(body)");
        JsonObject jsonObject2 = JupyterRestClient.post$default(this, "/api/kernels", string, 0, 4, null);
        if (jsonObject2 == null) {
            Intrinsics.throwNpe();
        }
        return jsonObject2;
    }

    public final void deleteKernel(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        this.delete("/api/kernels", id);
    }

    public final void interruptKernel(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        this.post("/api/kernels/" + id + "/interrupt", "", 204);
    }

    public final void restartKernel(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        this.post("/api/kernels/" + id + "/restart", "", 204);
    }

    /*
     * WARNING - void declaration
     */
    private final List<JsonObject> get(String endpoint) {
        void $this$filterIsInstanceTo$iv$iv;
        Request request = Request.Get((URI)this.getRequestURI(endpoint));
        Intrinsics.checkExpressionValueIsNotNull((Object)request, (String)"Request.Get(getRequestURI(endpoint))");
        String response2 = this.executeAndCheck(request, 200);
        Object object = gson.fromJson(response2, JsonArray.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"gson.fromJson(response, JsonArray::class.java)");
        Iterable $this$filterIsInstance$iv = (Iterable)object;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof JsonObject)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final JsonObject get(String endpoint, String id) {
        Request request = Request.Get((URI)this.getRequestURI(endpoint + '/' + id));
        Intrinsics.checkExpressionValueIsNotNull((Object)request, (String)"Request.Get(getRequestURI(\"$endpoint/$id\"))");
        String response2 = this.executeAndCheck(request, 200);
        Object object = gson.fromJson(response2, JsonObject.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"gson.fromJson(response, JsonObject::class.java)");
        return (JsonObject)object;
    }

    private final JsonObject post(String endpoint, String body, int expectedStatus) {
        Request request = Request.Post((URI)this.getRequestURI(endpoint)).bodyString(body, ContentType.APPLICATION_JSON);
        Intrinsics.checkExpressionValueIsNotNull((Object)request, (String)"Request.Post(getRequestU\u2026entType.APPLICATION_JSON)");
        String response2 = this.executeAndCheck(request, expectedStatus);
        CharSequence charSequence = response2;
        boolean bl = false;
        return !(charSequence.length() == 0) ? (JsonObject)gson.fromJson(response2, JsonObject.class) : null;
    }

    static /* synthetic */ JsonObject post$default(JupyterRestClient jupyterRestClient, String string, String string2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 201;
        }
        return jupyterRestClient.post(string, string2, n);
    }

    private final void delete(String endpoint, String id) {
        Request request = Request.Delete((URI)this.getRequestURI(endpoint + '/' + id));
        Intrinsics.checkExpressionValueIsNotNull((Object)request, (String)"Request.Delete(getRequestURI(\"$endpoint/$id\"))");
        this.executeAndCheck(request, 204);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String executeAndCheck(Request request, int status) {
        HttpResponse response2;
        Object object = request;
        Executor executor = this.getExecutor();
        boolean bl = false;
        boolean bl2 = false;
        Object $this$apply = object;
        int n = 0;
        this.httpSession.getHttpHeaders().forEach(new BiConsumer<String, String>((Request)$this$apply){
            final /* synthetic */ Request $this_apply;

            public final void accept(@NotNull String key, @NotNull String value) {
                Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                this.$this_apply.addHeader(key, value);
            }
            {
                this.$this_apply = request;
            }
        });
        Object object2 = object;
        HttpResponse httpResponse = response2 = executor.execute((Request)object2).returnResponse();
        Intrinsics.checkExpressionValueIsNotNull((Object)httpResponse, (String)"response");
        StatusLine statusLine = httpResponse.getStatusLine();
        Intrinsics.checkExpressionValueIsNotNull((Object)statusLine, (String)"response.statusLine");
        if (statusLine.getStatusCode() == 403) {
            throw (Throwable)new JupyterRestClientForbiddenException();
        }
        StatusLine statusLine2 = response2.getStatusLine();
        Intrinsics.checkExpressionValueIsNotNull((Object)statusLine2, (String)"response.statusLine");
        if (statusLine2.getStatusCode() != status) {
            StringBuilder stringBuilder = new StringBuilder().append("Rest Client: HTTP response status ");
            StatusLine statusLine3 = response2.getStatusLine();
            Intrinsics.checkExpressionValueIsNotNull((Object)statusLine3, (String)"response.statusLine");
            StringBuilder stringBuilder2 = stringBuilder.append(statusLine3.getStatusCode()).append(" differs from the expected one ").append(status).append(", ").append("message: ");
            HttpEntity httpEntity = response2.getEntity();
            Intrinsics.checkExpressionValueIsNotNull((Object)httpEntity, (String)"response.entity");
            InputStream inputStream = httpEntity.getContent();
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"response.entity.content");
            object = inputStream;
            object2 = stringBuilder2;
            executor = LOG;
            Charset charset = Charsets.UTF_8;
            bl2 = false;
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)object, charset);
            executor.warn(((StringBuilder)object2).append(TextStreamsKt.readText((Reader)inputStreamReader)).toString());
            JupyterServerErrorResponse message = JupyterErrorMessagesKt.tryParseServerErrorResponseAsJson(response2);
            if (message != null) {
                throw (Throwable)new JupyterRestClientErrorResponseException(message.getMessage(), message.getTraceback());
            }
            StringBuilder stringBuilder3 = new StringBuilder().append("Error with connection to Jupyter: server responded with ");
            StatusLine statusLine4 = response2.getStatusLine();
            Intrinsics.checkExpressionValueIsNotNull((Object)statusLine4, (String)"response.statusLine");
            throw (Throwable)new JupyterRestClientException(stringBuilder3.append(statusLine4.getStatusCode()).append(" on ").append(request).append(". ").append(status).append(" was expected.").toString());
        }
        if (response2.getEntity() == null) {
            return "";
        }
        HttpEntity httpEntity = response2.getEntity();
        Intrinsics.checkExpressionValueIsNotNull((Object)httpEntity, (String)"response.entity");
        InputStream inputStream = httpEntity.getContent();
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"response.entity.content");
        object = inputStream;
        Charset charset = MIME.UTF8_CHARSET;
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"MIME.UTF8_CHARSET");
        Charset charset2 = charset;
        bl2 = false;
        $this$apply = object;
        n = 0;
        $this$apply = new InputStreamReader((InputStream)$this$apply, charset2);
        n = 8192;
        boolean bl3 = false;
        object = $this$apply instanceof BufferedReader ? (BufferedReader)$this$apply : new BufferedReader((Reader)$this$apply, n);
        boolean bl4 = false;
        Throwable throwable = null;
        try {
            BufferedReader it = (BufferedReader)object;
            boolean bl5 = false;
            String string = TextStreamsKt.readText((Reader)it);
            return string;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    public JupyterRestClient(@NotNull HttpSession httpSession) {
        Intrinsics.checkParameterIsNotNull((Object)httpSession, (String)"httpSession");
        this.httpSession = httpSession;
    }

    public JupyterRestClient(@NotNull JupyterConnectionParameters connectionParameters) {
        Intrinsics.checkParameterIsNotNull((Object)connectionParameters, (String)"connectionParameters");
        this(new DefaultHttpSession(connectionParameters));
    }

    static {
        Companion = new Companion(null);
        gson = new Gson();
        Logger logger2 = Logger.getInstance(MethodHandles.lookup().lookupClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(Metho\u2026s.lookup().lookupClass())");
        LOG = logger2;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/JupyterRestClient$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "gson", "Lcom/google/gson/Gson;", "intellij.python.jupyter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

