/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.editor.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.PlatformUtils;
import com.jetbrains.python.inspections.PyInterpreterInspection;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.jupyter.JupyterBundle;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterConnectionSettingsUtilKt;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterRuntimeService;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterServer;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterServersKt;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterVirtualFile;
import org.jetbrains.plugins.notebooks.jupyter.editor.inspections.JupyterInspectionBase;
import org.jetbrains.plugins.notebooks.jupyter.editor.inspections.JupyterInspectionBaseKt;
import org.jetbrains.plugins.notebooks.jupyter.editor.inspections.JupyterKernelInspectionKt;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterKernelSpec;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterKernelSpecKt;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterNotebook;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 (2\u00020\u0001:\u0001(B\u0005\u00a2\u0006\u0002\u0010\u0002J;\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J1\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0004H\u0002\u00a2\u0006\u0002\u0010\u0014J7\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0004\"\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014J \u0010\u0016\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J3\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001bH\u0002\u00a2\u0006\u0002\u0010\u001eJ\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020 H\u0016J \u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u001bH\u0002J \u0010'\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\u001bH\u0002\u00a8\u0006)"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/editor/inspections/JupyterKernelInspection;", "Lorg/jetbrains/plugins/notebooks/jupyter/editor/inspections/JupyterInspectionBase;", "()V", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "module", "Lcom/intellij/openapi/module/Module;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;ZLcom/intellij/openapi/module/Module;Lcom/intellij/openapi/projectRoots/Sdk;)[Lcom/intellij/codeInspection/ProblemDescriptor;", "createKernelInterpreterDescriptors", "quickFixes", "Lcom/intellij/codeInspection/LocalQuickFix;", "(Lcom/intellij/codeInspection/InspectionManager;Lcom/intellij/psi/PsiFile;[Lcom/intellij/codeInspection/LocalQuickFix;)[Lcom/intellij/codeInspection/ProblemDescriptor;", "createMissingNotebookKernelSpecDescriptors", "createTurnProjectInterpreterIntoKernelFix", "jupyterVirtualFile", "Lorg/jetbrains/plugins/notebooks/jupyter/editor/JupyterVirtualFile;", "createUpdateNotebookKernelSpecFix", "serverKernelSpec", "Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterKernelSpec;", "createWrongNotebookKernelSpecDescriptors", "interpreterKernelSpec", "(Lcom/intellij/codeInspection/InspectionManager;Lcom/intellij/psi/PsiFile;Lorg/jetbrains/plugins/notebooks/jupyter/editor/JupyterVirtualFile;Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterKernelSpec;)[Lcom/intellij/codeInspection/ProblemDescriptor;", "getDisplayName", "", "getGroupDisplayName", "turnInterpreterIntoKernel", "", "project", "Lcom/intellij/openapi/project/Project;", "kernelSpec", "updateKernelSpec", "Companion", "intellij.python.jupyter"})
public final class JupyterKernelInspection
extends JupyterInspectionBase {
    private static final Logger LOG;
    public static final Companion Companion;

    @NotNull
    public String getGroupDisplayName() {
        return JupyterBundle.message("INSP.NAME.no.jupyter.package", new Object[0]);
    }

    @NotNull
    public String getDisplayName() {
        return JupyterBundle.message("INSP.GROUP.jupyter", new Object[0]);
    }

    @Override
    @NotNull
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly, @NotNull Module module, @NotNull Sdk sdk) {
        boolean bl;
        JupyterKernelSpec interpreterKernelSpec;
        JupyterVirtualFile jupyterVirtualFile;
        block18: {
            Object v8;
            String projectInterpreterPath;
            JupyterServer jupyterServer;
            block17: {
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
                Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
                Intrinsics.checkParameterIsNotNull((Object)sdk, (String)"sdk");
                if (PySdkUtil.isRemote((Sdk)sdk) || PythonSdkType.isInvalid((Sdk)sdk)) {
                    return new ProblemDescriptor[0];
                }
                PyPackageManager pyPackageManager = PyPackageManager.getInstance((Sdk)sdk);
                Intrinsics.checkExpressionValueIsNotNull((Object)pyPackageManager, (String)"PyPackageManager.getInstance(sdk)");
                if (JupyterInspectionBaseKt.noPackage(pyPackageManager, "ipykernel")) {
                    return new ProblemDescriptor[0];
                }
                VirtualFile virtualFile2 = file.getVirtualFile();
                if (!(virtualFile2 instanceof JupyterVirtualFile)) {
                    virtualFile2 = null;
                }
                JupyterVirtualFile jupyterVirtualFile2 = (JupyterVirtualFile)virtualFile2;
                if (jupyterVirtualFile2 == null) {
                    return new ProblemDescriptor[0];
                }
                jupyterVirtualFile = jupyterVirtualFile2;
                JupyterNotebook notebook = jupyterVirtualFile.getNotebook();
                Project project = file.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
                JupyterServer jupyterServer2 = JupyterConnectionSettingsUtilKt.getJupyterServer(project, file.getVirtualFile());
                if (jupyterServer2 == null) {
                    return new ProblemDescriptor[0];
                }
                jupyterServer = jupyterServer2;
                if (!JupyterConnectionSettingsUtilKt.isLocal(jupyterServer.getConnectionParameters())) {
                    return new ProblemDescriptor[0];
                }
                String string = sdk.getHomePath();
                if (string == null) {
                    return new ProblemDescriptor[0];
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sdk.homePath ?: return emptyArray()");
                projectInterpreterPath = string;
                List<JupyterKernelSpec> list = jupyterServer.getKernelSpecs();
                if (list == null) {
                    return JupyterKernelInspectionKt.access$getNO_PROBLEMS$p();
                }
                List<JupyterKernelSpec> kernelSpecs = list;
                Iterable $this$firstOrNull$iv = kernelSpecs;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    JupyterKernelSpec it = (JupyterKernelSpec)element$iv;
                    boolean bl2 = false;
                    JupyterKernelSpec jupyterKernelSpec = notebook.getKernelSpec();
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)(jupyterKernelSpec != null ? jupyterKernelSpec.getName() : null))) continue;
                    v8 = element$iv;
                    break block17;
                }
                v8 = null;
            }
            JupyterKernelSpec serverKernelSpec = v8;
            List<JupyterKernelSpec> interpreterKernelSpecs = JupyterServersKt.getProjectInterpreterKernelSpecs(jupyterServer, projectInterpreterPath);
            interpreterKernelSpec = (JupyterKernelSpec)CollectionsKt.firstOrNull(interpreterKernelSpecs);
            JupyterKernelSpec notebookKernelSpec = jupyterVirtualFile.getNotebook().getKernelSpec();
            if (interpreterKernelSpec == null) {
                if (notebookKernelSpec == null) {
                    return this.createMissingNotebookKernelSpecDescriptors(manager, file, this.createTurnProjectInterpreterIntoKernelFix(module, sdk, jupyterVirtualFile));
                }
                if (serverKernelSpec == null) {
                    return this.createKernelInterpreterDescriptors(manager, file, new LocalQuickFix[]{this.createTurnProjectInterpreterIntoKernelFix(module, sdk, jupyterVirtualFile)});
                }
                return this.createKernelInterpreterDescriptors(manager, file, new LocalQuickFix[]{this.createTurnProjectInterpreterIntoKernelFix(module, sdk, jupyterVirtualFile), (LocalQuickFix)new PyInterpreterInspection.ConfigureInterpreterFix()});
            }
            if (notebookKernelSpec == null) {
                return this.createMissingNotebookKernelSpecDescriptors(manager, file, this.createUpdateNotebookKernelSpecFix(jupyterVirtualFile, interpreterKernelSpec));
            }
            Iterable $this$all$iv = interpreterKernelSpecs;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    JupyterKernelSpec it = (JupyterKernelSpec)element$iv;
                    boolean bl3 = false;
                    if (Intrinsics.areEqual((Object)notebookKernelSpec.getName(), (Object)it.getName()) ^ true) continue;
                    bl = false;
                    break block18;
                }
                bl = true;
            }
        }
        if (bl) {
            return this.createWrongNotebookKernelSpecDescriptors(manager, file, jupyterVirtualFile, interpreterKernelSpec);
        }
        return JupyterKernelInspectionKt.access$getNO_PROBLEMS$p();
    }

    private final ProblemDescriptor[] createKernelInterpreterDescriptors(InspectionManager manager, PsiFile file, LocalQuickFix[] quickFixes) {
        String string = "Notebook kernel doesn't match %s";
        Object[] objectArray = new Object[]{PlatformUtils.isPyCharm() ? "project interpreter" : "module SDK"};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(this, *args)");
        String description = string2;
        ProblemDescriptor[] problemDescriptorArray = new ProblemDescriptor[1];
        ProblemDescriptor problemDescriptor = manager.createProblemDescriptor((PsiElement)file, description, true, quickFixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        Intrinsics.checkExpressionValueIsNotNull((Object)problemDescriptor, (String)"manager.createProblemDes\u2026_ERROR_OR_WARNING\n      )");
        problemDescriptorArray[0] = problemDescriptor;
        return problemDescriptorArray;
    }

    private final ProblemDescriptor[] createWrongNotebookKernelSpecDescriptors(InspectionManager manager, PsiFile file, JupyterVirtualFile jupyterVirtualFile, JupyterKernelSpec interpreterKernelSpec) {
        ProblemDescriptor[] problemDescriptorArray = new ProblemDescriptor[1];
        ProblemDescriptor problemDescriptor = manager.createProblemDescriptor((PsiElement)file, "Notebook kernel doesn't match project kernel", true, new LocalQuickFix[]{this.createUpdateNotebookKernelSpecFix(jupyterVirtualFile, interpreterKernelSpec)}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        Intrinsics.checkExpressionValueIsNotNull((Object)problemDescriptor, (String)"manager.createProblemDes\u2026_ERROR_OR_WARNING\n      )");
        problemDescriptorArray[0] = problemDescriptor;
        return problemDescriptorArray;
    }

    private final ProblemDescriptor[] createMissingNotebookKernelSpecDescriptors(InspectionManager manager, PsiFile file, LocalQuickFix ... quickFixes) {
        ProblemDescriptor[] problemDescriptorArray = new ProblemDescriptor[1];
        ProblemDescriptor problemDescriptor = manager.createProblemDescriptor((PsiElement)file, "Kernel spec is missing in notebook metadata", true, quickFixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        Intrinsics.checkExpressionValueIsNotNull((Object)problemDescriptor, (String)"manager.createProblemDes\u2026_ERROR_OR_WARNING\n      )");
        problemDescriptorArray[0] = problemDescriptor;
        return problemDescriptorArray;
    }

    private final LocalQuickFix createUpdateNotebookKernelSpecFix(JupyterVirtualFile jupyterVirtualFile, JupyterKernelSpec serverKernelSpec) {
        return new LocalQuickFix(this, jupyterVirtualFile, serverKernelSpec){
            final /* synthetic */ JupyterKernelInspection this$0;
            final /* synthetic */ JupyterVirtualFile $jupyterVirtualFile;
            final /* synthetic */ JupyterKernelSpec $serverKernelSpec;

            @NotNull
            public String getFamilyName() {
                return "Jupyter";
            }

            @NotNull
            public String getName() {
                return "Update notebook kernel";
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
                JupyterKernelInspection.access$updateKernelSpec(this.this$0, project, this.$jupyterVirtualFile, this.$serverKernelSpec);
            }
            {
                this.this$0 = $outer;
                this.$jupyterVirtualFile = $captured_local_variable$1;
                this.$serverKernelSpec = $captured_local_variable$2;
            }
        };
    }

    private final void updateKernelSpec(Project project, JupyterVirtualFile jupyterVirtualFile, JupyterKernelSpec kernelSpec) {
        JupyterRuntimeService.Companion.getInstance(project).switchKernel(jupyterVirtualFile.getOriginalFile(), kernelSpec);
    }

    private final LocalQuickFix createTurnProjectInterpreterIntoKernelFix(Module module, Sdk sdk, JupyterVirtualFile jupyterVirtualFile) {
        return new LocalQuickFix(this, module, sdk, jupyterVirtualFile){
            final /* synthetic */ JupyterKernelInspection this$0;
            final /* synthetic */ Module $module;
            final /* synthetic */ Sdk $sdk;
            final /* synthetic */ JupyterVirtualFile $jupyterVirtualFile;

            @NotNull
            public String getFamilyName() {
                return "Jupyter";
            }

            @NotNull
            public String getName() {
                return "Register project interpreter as kernel";
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
                JupyterKernelSpec kernelSpec = JupyterKernelSpecKt.createKernelSpec(project);
                Project project2 = this.$module.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"module.project");
                JupyterKernelInspection.access$turnInterpreterIntoKernel(this.this$0, project2, this.$sdk, kernelSpec);
                JupyterKernelInspection.access$updateKernelSpec(this.this$0, project, this.$jupyterVirtualFile, kernelSpec);
            }
            {
                this.this$0 = $outer;
                this.$module = $captured_local_variable$1;
                this.$sdk = $captured_local_variable$2;
                this.$jupyterVirtualFile = $captured_local_variable$3;
            }
        };
    }

    private final void turnInterpreterIntoKernel(Project project, Sdk sdk, JupyterKernelSpec kernelSpec) {
        ProcessOutput output;
        GeneralCommandLine commandLine = JupyterKernelInspectionKt.access$createCommandLine(project, sdk, kernelSpec.getName(), kernelSpec.getDisplayName());
        ProcessOutput processOutput = output = PySdkUtil.getProcessOutput((GeneralCommandLine)commandLine, (String)project.getBasePath(), null, (int)5000, null, (boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)processOutput, (String)"output");
        if (processOutput.getExitCode() != 0) {
            String errorMessage = "IPython JupyterKernel installation error. Exit code: " + output.getExitCode();
            Messages.showErrorDialog((Project)project, (String)errorMessage, (String)"IPython Error");
            LOG.error(errorMessage + " Output: " + output.getStderr());
        }
    }

    static {
        Companion = new Companion(null);
        Logger logger2 = Logger.getInstance(MethodHandles.lookup().lookupClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(Metho\u2026s.lookup().lookupClass())");
        LOG = logger2;
    }

    public static final /* synthetic */ void access$updateKernelSpec(JupyterKernelInspection $this, Project project, JupyterVirtualFile jupyterVirtualFile, JupyterKernelSpec kernelSpec) {
        $this.updateKernelSpec(project, jupyterVirtualFile, kernelSpec);
    }

    public static final /* synthetic */ void access$turnInterpreterIntoKernel(JupyterKernelInspection $this, Project project, Sdk sdk, JupyterKernelSpec kernelSpec) {
        $this.turnInterpreterIntoKernel(project, sdk, kernelSpec);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/editor/inspections/JupyterKernelInspection$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.python.jupyter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

