/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.server;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.jupyter.connections.JupyterConnectionParameters;
import org.jetbrains.plugins.notebooks.jupyter.connections.JupyterConnectionParametersSettings;
import org.jetbrains.plugins.notebooks.jupyter.connections.JupyterModuleConnectionSettings;
import org.jetbrains.plugins.notebooks.jupyter.connections.JupyterNotebookProcessHandler;
import org.jetbrains.plugins.notebooks.jupyter.connections.ManagedServerJupyterModuleConnectionSettings;
import org.jetbrains.plugins.notebooks.jupyter.server.JupyterServerExecution;
import org.jetbrains.plugins.notebooks.jupyter.server.JupyterServerExecutionImpl;
import org.jetbrains.plugins.notebooks.jupyter.server.JupyterServerService;
import org.jetbrains.plugins.notebooks.jupyter.server.JupyterServerServiceKt;
import org.jetbrains.plugins.notebooks.jupyter.server.ui.JupyterServerToolWindowKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0016J$\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\bH\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/server/JupyterServerServiceImpl;", "Lorg/jetbrains/plugins/notebooks/jupyter/server/JupyterServerService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "currentExecutions", "", "Lcom/intellij/openapi/module/Module;", "Lorg/jetbrains/plugins/notebooks/jupyter/server/JupyterServerExecutionImpl;", "isDisposed", "", "lock", "", "dispose", "", "getCurrentExecution", "Lorg/jetbrains/plugins/notebooks/jupyter/server/JupyterServerExecution;", "module", "startManagedServer", "settings", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/ManagedServerJupyterModuleConnectionSettings;", "ip", "", "stopManagedServer", "intellij.python.jupyter"})
public final class JupyterServerServiceImpl
implements JupyterServerService,
Disposable {
    private Map<Module, JupyterServerExecutionImpl> currentExecutions;
    private boolean isDisposed;
    private final Object lock;
    private final Project project;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public JupyterServerExecution getCurrentExecution(@NotNull Module module) {
        JupyterServerExecutionImpl jupyterServerExecutionImpl;
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            jupyterServerExecutionImpl = this.currentExecutions.get(module);
        }
        return jupyterServerExecutionImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JupyterServerExecution startManagedServer(@NotNull Module module, @Nullable ManagedServerJupyterModuleConnectionSettings settings, @Nullable String ip) {
        void execution;
        Pair pair;
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            Pair pair2;
            boolean bl3 = false;
            if (this.isDisposed) {
                throw (Throwable)new IllegalStateException("Already disposed");
            }
            JupyterServerExecutionImpl jupyterServerExecutionImpl = this.currentExecutions.get(module);
            boolean bl4 = false;
            boolean bl5 = false;
            JupyterServerExecutionImpl it = jupyterServerExecutionImpl;
            boolean bl6 = false;
            if (it == null || JupyterServerServiceKt.access$isFinished(it.getState())) {
                JupyterServerExecutionImpl newExecution = new JupyterServerExecutionImpl();
                this.currentExecutions.put(module, newExecution);
                pair2 = TuplesKt.to((Object)newExecution, (Object)true);
            } else {
                pair2 = TuplesKt.to((Object)it, (Object)false);
            }
            pair = pair2;
        }
        Pair pair3 = pair;
        JupyterServerExecutionImpl jupyterServerExecutionImpl = (JupyterServerExecutionImpl)pair3.component1();
        boolean startServer2 = (Boolean)pair3.component2();
        if (startServer2) {
            ManagedServerJupyterModuleConnectionSettings managedServerJupyterModuleConnectionSettings = settings;
            if (managedServerJupyterModuleConnectionSettings == null) {
                JupyterModuleConnectionSettings jupyterModuleConnectionSettings = JupyterConnectionParametersSettings.Companion.getConnectionParametersForModule(module);
                if (!(jupyterModuleConnectionSettings instanceof ManagedServerJupyterModuleConnectionSettings)) {
                    jupyterModuleConnectionSettings = null;
                }
                managedServerJupyterModuleConnectionSettings = (ManagedServerJupyterModuleConnectionSettings)jupyterModuleConnectionSettings;
            }
            ManagedServerJupyterModuleConnectionSettings effectiveSettings = managedServerJupyterModuleConnectionSettings;
            execution.startServer$intellij_python_jupyter(module, effectiveSettings, (Function1<? super JupyterNotebookProcessHandler, Unit>)((Function1)new Function1<JupyterNotebookProcessHandler, Unit>((JupyterServerExecutionImpl)execution, module){
                final /* synthetic */ JupyterServerExecutionImpl $execution;
                final /* synthetic */ Module $module;

                public final void invoke(@NotNull JupyterNotebookProcessHandler processHandler2) {
                    Intrinsics.checkParameterIsNotNull((Object)((Object)processHandler2), (String)"processHandler");
                    JupyterServerToolWindowKt.showJupyterServerManagementToolWindow(this.$execution, processHandler2, this.$module);
                }
                {
                    this.$execution = jupyterServerExecutionImpl;
                    this.$module = module;
                    super(1);
                }
            }), (Function1<? super JupyterConnectionParameters, Unit>)((Function1)new Function1<JupyterConnectionParameters, Unit>(this){
                final /* synthetic */ JupyterServerServiceImpl this$0;

                public final void invoke(@NotNull JupyterConnectionParameters connectionParameters) {
                    Intrinsics.checkParameterIsNotNull((Object)connectionParameters, (String)"connectionParameters");
                    JupyterServerToolWindowKt.notifyJupyterServerStarted(JupyterServerServiceImpl.access$getProject$p(this.this$0), connectionParameters);
                }
                {
                    this.this$0 = jupyterServerServiceImpl;
                    super(1);
                }
            }), (Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ JupyterServerServiceImpl this$0;

                public final void invoke() {
                    JupyterServerToolWindowKt.notifyJupyterServerTerminated(JupyterServerServiceImpl.access$getProject$p(this.this$0));
                }
                {
                    this.this$0 = jupyterServerServiceImpl;
                    super(0);
                }
            }), ip);
        }
        return (JupyterServerExecution)execution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopManagedServer(@NotNull Module module) {
        block3: {
            JupyterServerExecutionImpl jupyterServerExecutionImpl;
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            Object object = this.lock;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                boolean bl3 = false;
                JupyterServerExecutionImpl jupyterServerExecutionImpl2 = this.currentExecutions.remove(module);
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl10 : MonitorExitStatement: MONITOREXIT : var2_2
                jupyterServerExecutionImpl = jupyterServerExecutionImpl2;
            }
            if (jupyterServerExecutionImpl == null) break block3;
            jupyterServerExecutionImpl.stopServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.isDisposed = true;
            this.currentExecutions.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    public JupyterServerServiceImpl(@NotNull Project project) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        JupyterServerServiceImpl jupyterServerServiceImpl = this;
        boolean bl = false;
        jupyterServerServiceImpl.currentExecutions = map = (Map)new LinkedHashMap();
        this.lock = new Object();
    }

    public static final /* synthetic */ Project access$getProject$p(JupyterServerServiceImpl $this) {
        return $this.project;
    }
}

