/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.codeInsight.attributes;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.impl.BasicXmlAttributeDescriptor;
import com.intellij.xml.impl.XmlAttributeDescriptorEx;
import icons.AngularJSIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.angular2.codeInsight.Angular2CodeInsightUtils;
import org.angular2.codeInsight.Angular2DeclarationsScope;
import org.angular2.codeInsight.Angular2LibrariesHacks;
import org.angular2.codeInsight.Angular2TypeEvaluator;
import org.angular2.codeInsight.attributes.Angular2AttributeDescriptorsProvider;
import org.angular2.codeInsight.attributes.Angular2AttributeInsertHandler;
import org.angular2.codeInsight.attributes.Angular2EventHandlerDescriptor;
import org.angular2.codeInsight.tags.Angular2XmlElementSourcesResolver;
import org.angular2.codeInsight.template.Angular2TemplateElementsScopeProvider;
import org.angular2.entities.Angular2Directive;
import org.angular2.entities.Angular2DirectiveAttribute;
import org.angular2.entities.Angular2DirectiveProperty;
import org.angular2.entities.Angular2DirectiveSelector;
import org.angular2.entities.Angular2Element;
import org.angular2.lang.expr.psi.Angular2TemplateBindings;
import org.angular2.lang.html.parser.Angular2AttributeNameParser;
import org.angular2.lang.html.parser.Angular2AttributeType;
import org.angular2.lang.html.psi.Angular2HtmlEvent;
import org.angular2.lang.html.psi.PropertyBindingType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Angular2AttributeDescriptor
extends BasicXmlAttributeDescriptor
implements XmlAttributeDescriptorEx,
PsiPresentableMetaData {
    public static final JSType STRING_TYPE = new JSStringType(true, JSTypeSource.EXPLICITLY_DECLARED, JSTypeContext.INSTANCE);
    private static final Collection<String> ONE_TIME_BINDING_EXCLUDES = ContainerUtil.newArrayList((Object[])new String[]{"ngClass"});
    @NotNull
    private final AttributePriority myPriority;
    private final Angular2XmlElementSourcesResolver myResolver;
    @NotNull
    private final String myAttributeName;
    @NotNull
    private final Angular2AttributeNameParser.AttributeInfo myInfo;
    private final boolean myImplied;
    private final AtomicNullableLazyValue<JSType> myJSType;

    @Nullable
    public static Angular2AttributeDescriptor create(@NotNull XmlTag tag, @NotNull String attributeName) {
        if (tag == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(0);
        }
        if (attributeName == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(1);
        }
        return Angular2AttributeDescriptor.create(tag, attributeName, Collections.emptyList());
    }

    @Nullable
    public static Angular2AttributeDescriptor create(@NotNull XmlTag tag, @NotNull String attributeName, @NotNull PsiElement element) {
        if (tag == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(2);
        }
        if (attributeName == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(3);
        }
        if (element == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(4);
        }
        return Angular2AttributeDescriptor.create(tag, attributeName, Collections.singletonList(element));
    }

    @Nullable
    private static Angular2AttributeDescriptor create(@NotNull XmlTag tag, @NotNull String attributeName, @NotNull List<PsiElement> elements) {
        if (tag == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(5);
        }
        if (attributeName == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(6);
        }
        if (elements == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(7);
        }
        if (Angular2AttributeDescriptorsProvider.getCustomNgAttrs().contains(attributeName)) {
            return new Angular2AttributeDescriptor(tag, attributeName, elements, true);
        }
        Angular2AttributeNameParser.AttributeInfo info = Angular2AttributeNameParser.parse(attributeName, tag);
        if (elements.isEmpty() && info.type == Angular2AttributeType.REGULAR) {
            return null;
        }
        boolean implied = !elements.isEmpty() || info.type != Angular2AttributeType.TEMPLATE_BINDINGS && (!(info instanceof Angular2AttributeNameParser.EventInfo) || ((Angular2AttributeNameParser.EventInfo)info).eventType != Angular2HtmlEvent.EventType.REGULAR || info.name.contains(":")) && (!(info instanceof Angular2AttributeNameParser.PropertyBindingInfo) || ((Angular2AttributeNameParser.PropertyBindingInfo)info).bindingType != PropertyBindingType.PROPERTY);
        if (info.type == Angular2AttributeType.EVENT) {
            return new Angular2EventHandlerDescriptor(tag, attributeName, info, elements, implied);
        }
        return new Angular2AttributeDescriptor(tag, attributeName, info, elements, implied);
    }

    @NotNull
    public static List<Angular2AttributeDescriptor> getDirectiveDescriptors(@NotNull Angular2Directive directive, @NotNull XmlTag tag, @NotNull Predicate<String> shouldIncludeOneTimeBinding) {
        if (directive == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(8);
        }
        if (tag == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(9);
        }
        if (shouldIncludeOneTimeBinding == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(10);
        }
        if (!directive.isRegularDirective() && !Angular2TemplateElementsScopeProvider.isTemplateTag(tag)) {
            List<Angular2AttributeDescriptor> list = Collections.emptyList();
            if (list == null) {
                Angular2AttributeDescriptor.$$$reportNull$$$0(11);
            }
            return list;
        }
        List<Angular2AttributeDescriptor> list = new DirectiveAttributesProvider(tag, directive, shouldIncludeOneTimeBinding).get();
        if (list == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(12);
        }
        return list;
    }

    protected Angular2AttributeDescriptor(@NotNull XmlTag xmlTag, @NotNull String attributeName, @NotNull Collection<?> sources, boolean implied) {
        if (xmlTag == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(13);
        }
        if (attributeName == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(14);
        }
        if (sources == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(15);
        }
        this(xmlTag, attributeName, Angular2AttributeNameParser.parse(attributeName, xmlTag), AttributePriority.NORMAL, sources, implied);
    }

    protected Angular2AttributeDescriptor(@NotNull XmlTag xmlTag, @NotNull String attributeName, @NotNull AttributePriority priority, @NotNull Collection<?> sources, boolean implied) {
        if (xmlTag == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(16);
        }
        if (attributeName == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(17);
        }
        if (priority == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(18);
        }
        if (sources == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(19);
        }
        this(xmlTag, attributeName, Angular2AttributeNameParser.parse(attributeName, xmlTag), priority, sources, implied);
    }

    protected Angular2AttributeDescriptor(@NotNull XmlTag xmlTag, @NotNull String attributeName, @NotNull Angular2AttributeNameParser.AttributeInfo info, @NotNull Collection<?> sources, boolean implied) {
        if (xmlTag == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(20);
        }
        if (attributeName == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(21);
        }
        if (info == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(22);
        }
        if (sources == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(23);
        }
        this(xmlTag, attributeName, info, AttributePriority.NORMAL, sources, implied);
    }

    protected Angular2AttributeDescriptor(@NotNull XmlTag tag, @NotNull String attributeName, @NotNull Angular2AttributeNameParser.AttributeInfo info, @NotNull AttributePriority priority, @NotNull Collection<?> sources, boolean implied) {
        if (tag == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(24);
        }
        if (attributeName == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(25);
        }
        if (info == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(26);
        }
        if (priority == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(27);
        }
        if (sources == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(28);
        }
        this.myJSType = AtomicNullableLazyValue.createValue(this::buildJSType);
        this.myAttributeName = attributeName;
        this.myResolver = new Angular2XmlElementSourcesResolver(tag, sources, this::getProperties, this::getSelectors);
        this.myInfo = info;
        this.myPriority = priority;
        this.myImplied = implied;
    }

    public Angular2AttributeDescriptor merge(@Nullable XmlAttributeDescriptor other) {
        if (other == null) {
            return this;
        }
        if (other instanceof Angular2AttributeDescriptor) {
            Angular2AttributeDescriptor ngOther = (Angular2AttributeDescriptor)other;
            assert (this.myAttributeName.equals(ngOther.myAttributeName) && this.myInfo.isEquivalent(ngOther.myInfo)) : "Cannot merge attributes with different names or non-equivalent infos: " + this.myAttributeName + " " + this.myInfo.toString() + " != " + ngOther.myAttributeName + " " + ngOther.myInfo.toString();
            assert (this.myResolver.getScope() == ngOther.myResolver.getScope()) : "Cannot merge attributes from different tags";
            HashSet sources = new HashSet(this.myResolver.getSources());
            sources.addAll(ngOther.myResolver.getSources());
            return new Angular2AttributeDescriptor(this.myResolver.getScope(), this.myAttributeName, this.myInfo, this.myPriority, sources, this.myImplied || ngOther.myImplied);
        }
        assert (other.getName().equalsIgnoreCase(this.myAttributeName)) : "Cannot merge attributes with different names: " + this.myAttributeName + " != " + other.getName();
        HashSet elements = new HashSet(this.myResolver.getSources());
        elements.addAll(other.getDeclarations());
        return new Angular2AttributeDescriptor(this.myResolver.getScope(), this.myAttributeName, elements, true);
    }

    public String getName() {
        return this.myAttributeName;
    }

    public void init(PsiElement element) {
    }

    public boolean isRequired() {
        return false;
    }

    public boolean hasIdType() {
        return "id".equals(this.myAttributeName);
    }

    public boolean hasIdRefType() {
        return false;
    }

    public boolean isEnumerated() {
        return this.getEnumeratedValues().length > 0;
    }

    public boolean isFixed() {
        return false;
    }

    public String getDefaultValue() {
        return null;
    }

    @NotNull
    public List<Angular2Directive> getSourceDirectives() {
        List<Angular2Directive> list = this.myResolver.getSourceDirectives();
        if (list == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(29);
        }
        return list;
    }

    public boolean isImplied() {
        return this.myImplied;
    }

    @NotNull
    public String[] getEnumeratedValues() {
        JSType type;
        if (this.myInfo.type == Angular2AttributeType.REGULAR && (type = this.getJSType()) != null) {
            ArrayList values = new ArrayList();
            if ((type = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive((JSType)type)) instanceof JSBooleanType) {
                String[] stringArray = new String[]{this.myAttributeName};
                if (stringArray == null) {
                    Angular2AttributeDescriptor.$$$reportNull$$$0(30);
                }
                return stringArray;
            }
            JSTypeUtils.processExpandedType(subType -> {
                if (subType instanceof JSStringLiteralTypeImpl) {
                    values.add(((JSStringLiteralTypeImpl)subType).getLiteral());
                }
                return true;
            }, (JSType)type);
            if (!values.isEmpty()) {
                String[] stringArray = ArrayUtilRt.toStringArray(values);
                if (stringArray == null) {
                    Angular2AttributeDescriptor.$$$reportNull$$$0(31);
                }
                return stringArray;
            }
        }
        if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(32);
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    protected PsiElement getEnumeratedValueDeclaration(XmlElement xmlElement, String value) {
        return xmlElement;
    }

    public PsiElement getDeclaration() {
        Collection<PsiElement> declarations = this.getDeclarations();
        return declarations.size() == 1 ? (PsiElement)ContainerUtil.getFirstItem(declarations) : null;
    }

    @NotNull
    public Collection<PsiElement> getDeclarations() {
        Collection<PsiElement> collection = this.myResolver.getDeclarations();
        if (collection == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(33);
        }
        return collection;
    }

    private Collection<? extends PsiElement> getSelectors(@NotNull Angular2Directive directive) {
        if (directive == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(34);
        }
        return ((StreamEx)StreamEx.of(directive.getSelector().getSimpleSelectorsWithPsi()).flatMap(selector -> StreamEx.of(selector.getNotSelectors()).flatCollection(Angular2DirectiveSelector.SimpleSelectorWithPsi::getAttributes).prepend(selector.getAttributes())).filter(s -> this.myInfo.name.equals(s.getName()))).toList();
    }

    @NotNull
    private Collection<PsiElement> getProperties(@NotNull Angular2Directive directive) {
        if (directive == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(35);
        }
        switch (this.myInfo.type) {
            case PROPERTY_BINDING: 
            case TEMPLATE_BINDINGS: 
            case EVENT: {
                List list = ((StreamEx)StreamEx.of(this.myInfo.type == Angular2AttributeType.EVENT ? directive.getOutputs() : directive.getInputs()).filter(input -> this.myInfo.name.equals(input.getName()))).map(Angular2Element::getNavigableElement).toList();
                if (list == null) {
                    Angular2AttributeDescriptor.$$$reportNull$$$0(36);
                }
                return list;
            }
            case BANANA_BOX_BINDING: {
                List list = ((StreamEx)StreamEx.of(directive.getInOuts()).filter(inout -> this.myInfo.name.equals(((Angular2DirectiveProperty)inout.first).getName()))).flatCollection(inout -> ContainerUtil.newArrayList((Object[])new PsiElement[]{((Angular2DirectiveProperty)inout.first).getNavigableElement(), ((Angular2DirectiveProperty)inout.second).getNavigableElement()})).toList();
                if (list == null) {
                    Angular2AttributeDescriptor.$$$reportNull$$$0(37);
                }
                return list;
            }
            case REGULAR: {
                StreamEx inputsPsiElements = ((StreamEx)StreamEx.of(directive.getInputs()).filter(property -> this.myInfo.name.equals(property.getName()) && Angular2AttributeDescriptor.isOneTimeBindingProperty(property))).map(Angular2Element::getNavigableElement);
                StreamEx attributesPsiElements = ((StreamEx)StreamEx.of(directive.getAttributes()).filter(a -> this.myInfo.name.equals(a.getName()))).map(Angular2Element::getNavigableElement);
                List list = ((StreamEx)inputsPsiElements.append((Stream)attributesPsiElements)).toList();
                if (list == null) {
                    Angular2AttributeDescriptor.$$$reportNull$$$0(38);
                }
                return list;
            }
        }
        List<PsiElement> list = Collections.emptyList();
        if (list == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(39);
        }
        return list;
    }

    @Nullable
    public String handleTargetRename(@NotNull @NonNls String newTargetName) {
        if (newTargetName == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(40);
        }
        if (this.myInfo.type != Angular2AttributeType.REGULAR) {
            int start = this.myAttributeName.lastIndexOf(this.myInfo.name);
            return this.myAttributeName.substring(0, start) + newTargetName + this.myAttributeName.substring(start + this.myInfo.name.length());
        }
        return newTargetName;
    }

    public String getTypeName() {
        JSType type = this.getJSType();
        if (type != null) {
            if (this.myInfo instanceof Angular2AttributeNameParser.PropertyBindingInfo && ((Angular2AttributeNameParser.PropertyBindingInfo)this.myInfo).bindingType == PropertyBindingType.PROPERTY || type instanceof JSPrimitiveType || this.isEnumerated()) {
                return StringUtil.shortenTextWithEllipsis((String)type.getTypeText(), (int)25, (int)0, (boolean)true);
            }
            if (this.myInfo instanceof Angular2AttributeNameParser.EventInfo && ((Angular2AttributeNameParser.EventInfo)this.myInfo).eventType == Angular2HtmlEvent.EventType.REGULAR && (type = Angular2TypeEvaluator.getEventVariableType(type)) != null) {
                return type.getTypeText();
            }
        }
        return null;
    }

    @NotNull
    public Pair<LookupElement, String> getLookupElementWithPrefix(@NotNull PrefixMatcher prefixMatcher, @NotNull Angular2DeclarationsScope moduleScope) {
        String typeName;
        Angular2DeclarationsScope.DeclarationProximity proximity;
        if (prefixMatcher == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(41);
        }
        if (moduleScope == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(42);
        }
        LookupElementInfo info = this.buildElementInfo(prefixMatcher);
        String currentPrefix = prefixMatcher.getPrefix();
        Pair hide = (Pair)ObjectUtils.notNull((Object)ContainerUtil.find(info.hidePrefixesAndSuffixes, pair -> currentPrefix.startsWith((String)pair.first)), () -> Pair.pair((Object)"", (Object)""));
        String name = StringUtil.trimStart((String)info.elementName, (String)((String)hide.first));
        Angular2DeclarationsScope.DeclarationProximity declarationProximity = proximity = this.myImplied ? Angular2DeclarationsScope.DeclarationProximity.IN_SCOPE : moduleScope.getDeclarationsProximity(this.getSourceDirectives());
        if (proximity == Angular2DeclarationsScope.DeclarationProximity.NOT_REACHABLE) {
            Pair pair2 = Pair.pair(null, (Object)name);
            if (pair2 == null) {
                Angular2AttributeDescriptor.$$$reportNull$$$0(43);
            }
            return pair2;
        }
        LookupElementBuilder element = LookupElementBuilder.create((String)name).withPresentableText(StringUtil.trimEnd((String)name, (String)((String)hide.second))).withCaseSensitivity(this.myInfo.type != Angular2AttributeType.REGULAR || !this.myImplied).withIcon(this.getIcon()).withBoldness(proximity == Angular2DeclarationsScope.DeclarationProximity.IN_SCOPE && this.myPriority == AttributePriority.HIGH).withInsertHandler((InsertHandler)new Angular2AttributeInsertHandler(this.shouldInsertHandlerRemoveLeftover(), this::shouldCompleteValue, null));
        if (info.lookupStrings != null) {
            element = element.withLookupStrings((Collection)ContainerUtil.map(info.lookupStrings, str -> StringUtil.trimStart((String)str, (String)((String)hide.first))));
        }
        if (proximity != Angular2DeclarationsScope.DeclarationProximity.IN_SCOPE) {
            element = Angular2CodeInsightUtils.wrapWithImportDeclarationModuleHandler(Angular2CodeInsightUtils.decorateLookupElementWithModuleSource(element, this.getSourceDirectives(), proximity, moduleScope), this.myInfo.type == Angular2AttributeType.TEMPLATE_BINDINGS ? Angular2TemplateBindings.class : XmlAttribute.class);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(typeName = this.getTypeName()))) {
            element = element.withTypeText(typeName);
        }
        Pair pair3 = Pair.pair((Object)PrioritizedLookupElement.withPriority((LookupElement)element, (double)this.myPriority.getValue(proximity)), (Object)currentPrefix.substring(((String)hide.first).length()));
        if (pair3 == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(44);
        }
        return pair3;
    }

    protected LookupElementInfo buildElementInfo(@NotNull PrefixMatcher prefixMatcher) {
        String canonicalPrefix;
        if (prefixMatcher == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(45);
        }
        if ((canonicalPrefix = this.myInfo.type.getCanonicalPrefix()) != null && prefixMatcher.getPrefix().startsWith(canonicalPrefix)) {
            return new LookupElementInfo(Objects.requireNonNull(this.myInfo.type.buildName(this.myInfo.getFullName(), true)), Collections.singletonList(Pair.pair((Object)canonicalPrefix, (Object)"")), this.myInfo.type == Angular2AttributeType.EVENT ? ContainerUtil.newArrayList((Object[])new String[]{this.getName(), "on" + this.myInfo.getFullName()}) : null);
        }
        return new LookupElementInfo(this.getName(), Collections.emptyList(), this.myInfo.type == Angular2AttributeType.EVENT ? ContainerUtil.newArrayList((Object[])new String[]{this.getName(), "on" + this.myInfo.getFullName()}) : null);
    }

    protected boolean shouldInsertHandlerRemoveLeftover() {
        return false;
    }

    private boolean shouldCompleteValue() {
        JSType type;
        return this.myInfo.type != Angular2AttributeType.REGULAR || (type = this.getJSType()) != null && !(type instanceof JSBooleanType);
    }

    @NotNull
    public Angular2AttributeNameParser.AttributeInfo getInfo() {
        Angular2AttributeNameParser.AttributeInfo attributeInfo = this.myInfo;
        if (attributeInfo == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(46);
        }
        return attributeInfo;
    }

    @Nullable
    public Icon getIcon() {
        return AngularJSIcons.Angular2;
    }

    @Nullable
    public JSType getJSType() {
        return (JSType)this.myJSType.getValue();
    }

    private JSType buildJSType() {
        Collection<PsiElement> declarations = this.getDeclarations();
        List types = ContainerUtil.mapNotNull(declarations, element -> {
            if (element instanceof JSFunction) {
                JSParameterListElement[] params = ((JSFunction)element).getParameters();
                if (((JSFunction)element).isSetProperty() && params.length == 1) {
                    return params[0].getSimpleType();
                }
            }
            return JSTypeUtils.getTypeOfElement((PsiElement)element);
        });
        if (types.size() == 1) {
            return (JSType)types.get(0);
        }
        if (types.size() > 1) {
            if (this.myInfo.type == Angular2AttributeType.BANANA_BOX_BINDING) {
                return (JSType)types.get(0);
            }
            return JSCompositeTypeImpl.getCommonType((Collection)types, (JSTypeSource)JSTypeSourceFactory.createTypeSource((PsiElement)((PsiElement)ContainerUtil.getFirstItem(declarations)), (boolean)false), (boolean)false);
        }
        return null;
    }

    public static boolean isOneTimeBindingProperty(@NotNull Angular2DirectiveProperty property) {
        if (property == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(47);
        }
        if (ONE_TIME_BINDING_EXCLUDES.contains(property.getName())) {
            return false;
        }
        if (property.isVirtual()) {
            return true;
        }
        JSType type = property.getType();
        if (type == null) {
            return false;
        }
        Map cache = (Map)CachedValuesManager.getCachedValue((PsiElement)property.getSourceElement(), () -> CachedValueProvider.Result.create(new ConcurrentHashMap(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        return cache.computeIfAbsent(property, prop -> Angular2AttributeDescriptor.expandStringLiteralTypes(type).isDirectlyAssignableType(STRING_TYPE, JSTypeComparingContextService.getProcessingContextWithCache((PsiElement)property.getSourceElement()))) == Boolean.TRUE;
    }

    @Contract(value="null -> null")
    private static JSType expandStringLiteralTypes(@Nullable JSType type) {
        if (type == null) {
            return null;
        }
        type = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive((JSType)type);
        return type.transformTypeHierarchy(toApply -> toApply instanceof JSPrimitiveType ? STRING_TYPE : toApply);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 43: 
            case 44: 
            case 46: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 43: 
            case 44: 
            case 46: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 14: 
            case 17: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 8: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directive";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shouldIncludeOneTimeBinding";
                break;
            }
            case 11: 
            case 12: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 43: 
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angular2/codeInsight/attributes/Angular2AttributeDescriptor";
                break;
            }
            case 13: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlTag";
                break;
            }
            case 15: 
            case 19: 
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sources";
                break;
            }
            case 18: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priority";
                break;
            }
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTargetName";
                break;
            }
            case 41: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixMatcher";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleScope";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angular2/codeInsight/attributes/Angular2AttributeDescriptor";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectiveDescriptors";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceDirectives";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnumeratedValues";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarations";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupElementWithPrefix";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDirectiveDescriptors";
                break;
            }
            case 11: 
            case 12: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 43: 
            case 44: 
            case 46: {
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getSelectors";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getProperties";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "handleTargetRename";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getLookupElementWithPrefix";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "buildElementInfo";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isOneTimeBindingProperty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 43: 
            case 44: 
            case 46: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DirectiveAttributesProvider {
        private final Angular2Directive myDirective;
        private final Predicate<String> myShouldIncludeOneTimeBinding;
        private final XmlTag myTag;
        private List<Angular2AttributeDescriptor> myResult;

        DirectiveAttributesProvider(@NotNull XmlTag tag, @NotNull Angular2Directive directive, @NotNull Predicate<String> shouldIncludeOneTimeBinding) {
            if (tag == null) {
                DirectiveAttributesProvider.$$$reportNull$$$0(0);
            }
            if (directive == null) {
                DirectiveAttributesProvider.$$$reportNull$$$0(1);
            }
            if (shouldIncludeOneTimeBinding == null) {
                DirectiveAttributesProvider.$$$reportNull$$$0(2);
            }
            this.myTag = tag;
            this.myDirective = directive;
            this.myShouldIncludeOneTimeBinding = shouldIncludeOneTimeBinding;
        }

        public List<Angular2AttributeDescriptor> get() {
            this.myResult = new ArrayList<Angular2AttributeDescriptor>();
            this.collectDirectiveDescriptors(this.myDirective.getInOuts(), this::createBananaBoxBinding);
            this.collectDirectiveDescriptors(this.myDirective.getInputs(), this::createBinding);
            this.collectDirectiveDescriptors(this.myDirective.getOutputs(), this::createEventHandler);
            this.collectDirectiveDescriptors(this.myDirective.getInputs(), this::createOneTimeBinding);
            this.collectDirectiveDescriptors(this.myDirective.getAttributes(), this::createAttributeBinding);
            Optional.ofNullable(Angular2LibrariesHacks.hackIonicComponentAttributeNames(this.myDirective, this::createOneTimeBinding)).ifPresent(creator -> this.collectDirectiveDescriptors((Collection)this.myDirective.getInputs(), (Function)creator));
            return this.myResult;
        }

        private <T> void collectDirectiveDescriptors(@NotNull Collection<T> list, @NotNull Function<T, ? extends Angular2AttributeDescriptor> factory) {
            if (list == null) {
                DirectiveAttributesProvider.$$$reportNull$$$0(3);
            }
            if (factory == null) {
                DirectiveAttributesProvider.$$$reportNull$$$0(4);
            }
            list.forEach(el -> {
                Boolean cfr_ignored_0 = (Boolean)ObjectUtils.doIfNotNull(factory.apply(el), this.myResult::add);
            });
        }

        @NotNull
        private Angular2AttributeDescriptor createBinding(@NotNull Angular2DirectiveProperty info) {
            if (info == null) {
                DirectiveAttributesProvider.$$$reportNull$$$0(5);
            }
            Angular2AttributeDescriptor angular2AttributeDescriptor = new Angular2AttributeDescriptor(this.myTag, Angular2AttributeType.PROPERTY_BINDING.buildName(info.getName()), AttributePriority.HIGH, Collections.singletonList(this.myDirective), false);
            if (angular2AttributeDescriptor == null) {
                DirectiveAttributesProvider.$$$reportNull$$$0(6);
            }
            return angular2AttributeDescriptor;
        }

        @NotNull
        private Angular2AttributeDescriptor createBananaBoxBinding(@NotNull Pair<Angular2DirectiveProperty, Angular2DirectiveProperty> info) {
            if (info == null) {
                DirectiveAttributesProvider.$$$reportNull$$$0(7);
            }
            Angular2AttributeDescriptor angular2AttributeDescriptor = new Angular2AttributeDescriptor(this.myTag, Angular2AttributeType.BANANA_BOX_BINDING.buildName(((Angular2DirectiveProperty)info.first).getName()), AttributePriority.HIGH, Collections.singletonList(this.myDirective), false);
            if (angular2AttributeDescriptor == null) {
                DirectiveAttributesProvider.$$$reportNull$$$0(8);
            }
            return angular2AttributeDescriptor;
        }

        @Nullable
        private Angular2AttributeDescriptor createOneTimeBinding(@NotNull Angular2DirectiveProperty info) {
            if (info == null) {
                DirectiveAttributesProvider.$$$reportNull$$$0(9);
            }
            return this.createOneTimeBinding(info, info.getName());
        }

        @Nullable
        private Angular2AttributeDescriptor createOneTimeBinding(@NotNull Angular2DirectiveProperty info, String attributeName) {
            if (info == null) {
                DirectiveAttributesProvider.$$$reportNull$$$0(10);
            }
            return this.myShouldIncludeOneTimeBinding.test(attributeName) && Angular2AttributeDescriptor.isOneTimeBindingProperty(info) ? new Angular2AttributeDescriptor(this.myTag, attributeName, AttributePriority.HIGH, Collections.singletonList(this.myDirective), false) : null;
        }

        @NotNull
        private Angular2AttributeDescriptor createAttributeBinding(@NotNull Angular2DirectiveAttribute info) {
            if (info == null) {
                DirectiveAttributesProvider.$$$reportNull$$$0(11);
            }
            Angular2AttributeDescriptor angular2AttributeDescriptor = new Angular2AttributeDescriptor(this.myTag, info.getName(), AttributePriority.HIGH, Collections.singletonList(this.myDirective), false);
            if (angular2AttributeDescriptor == null) {
                DirectiveAttributesProvider.$$$reportNull$$$0(12);
            }
            return angular2AttributeDescriptor;
        }

        @NotNull
        private Angular2EventHandlerDescriptor createEventHandler(@NotNull Angular2DirectiveProperty info) {
            if (info == null) {
                DirectiveAttributesProvider.$$$reportNull$$$0(13);
            }
            Angular2EventHandlerDescriptor angular2EventHandlerDescriptor = new Angular2EventHandlerDescriptor(this.myTag, Angular2AttributeType.EVENT.buildName(info.getName()), AttributePriority.HIGH, Collections.singletonList(this.myDirective), false);
            if (angular2EventHandlerDescriptor == null) {
                DirectiveAttributesProvider.$$$reportNull$$$0(14);
            }
            return angular2EventHandlerDescriptor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 8: 
                case 12: 
                case 14: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 8: 
                case 12: 
                case 14: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "directive";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shouldIncludeOneTimeBinding";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 11: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 6: 
                case 8: 
                case 12: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/angular2/codeInsight/attributes/Angular2AttributeDescriptor$DirectiveAttributesProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/angular2/codeInsight/attributes/Angular2AttributeDescriptor$DirectiveAttributesProvider";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createBinding";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createBananaBoxBinding";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createAttributeBinding";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createEventHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "collectDirectiveDescriptors";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createBinding";
                    break;
                }
                case 6: 
                case 8: 
                case 12: 
                case 14: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createBananaBoxBinding";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "createOneTimeBinding";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "createAttributeBinding";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "createEventHandler";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 8: 
                case 12: 
                case 14: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class LookupElementInfo {
        public final String elementName;
        public final List<Pair<String, String>> hidePrefixesAndSuffixes;
        public final List<String> lookupStrings;

        public LookupElementInfo(@NotNull String elementName, @NotNull List<Pair<String, String>> hidePrefixesAndSuffixes, @Nullable List<String> lookupStrings) {
            if (elementName == null) {
                LookupElementInfo.$$$reportNull$$$0(0);
            }
            if (hidePrefixesAndSuffixes == null) {
                LookupElementInfo.$$$reportNull$$$0(1);
            }
            this.elementName = elementName;
            this.hidePrefixesAndSuffixes = hidePrefixesAndSuffixes;
            this.lookupStrings = lookupStrings;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "elementName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "hidePrefixesAndSuffixes";
                    break;
                }
            }
            objectArray[1] = "org/angular2/codeInsight/attributes/Angular2AttributeDescriptor$LookupElementInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum AttributePriority {
        NONE(0.0),
        LOW(25.0),
        NORMAL(50.0),
        HIGH(100.0);

        private final double myValue;

        private AttributePriority(double value) {
            this.myValue = value;
        }

        public double getValue() {
            return this.myValue;
        }

        public double getValue(Angular2DeclarationsScope.DeclarationProximity proximity) {
            return proximity == Angular2DeclarationsScope.DeclarationProximity.IN_SCOPE || proximity == Angular2DeclarationsScope.DeclarationProximity.EXPORTED_BY_PUBLIC_MODULE ? this.myValue : 0.0;
        }
    }
}

