/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.fix;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.lang.javascript.linter.tslint.TsLintBundle;
import com.intellij.lang.javascript.linter.tslint.execution.TsLinterError;
import com.intellij.lang.javascript.linter.tslint.highlight.TsLintFixInfo;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LineSeparator;
import java.util.Arrays;
import java.util.Comparator;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TsLintErrorFixAction
extends BaseIntentionAction
implements HighPriorityAction {
    @NotNull
    private final TsLinterError myError;
    private final long myModificationStamp;
    private final SmartPsiElementPointer<PsiFile> myPsiFilePointer;
    private static final Comparator<TsLintFixInfo.TsLintFixReplacements> REPLACEMENTS_COMPARATOR = Comparator.comparingInt(value -> value.innerStart + value.innerLength).thenComparingInt(value -> value.innerStart).reversed();

    public TsLintErrorFixAction(@NotNull PsiFile file, @NotNull TsLinterError error, long modificationStamp) {
        if (file == null) {
            TsLintErrorFixAction.$$$reportNull$$$0(0);
        }
        if (error == null) {
            TsLintErrorFixAction.$$$reportNull$$$0(1);
        }
        this.myPsiFilePointer = SmartPointerManager.getInstance((Project)file.getProject()).createSmartPsiElementPointer((PsiElement)file);
        this.myError = error;
        this.myModificationStamp = modificationStamp;
    }

    @NotNull
    public String getText() {
        String string = TsLintErrorFixAction.getText(this.myError.getCode());
        if (string == null) {
            TsLintErrorFixAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = TsLintErrorFixAction.getText(null);
        if (string == null) {
            TsLintErrorFixAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    private static String getText(@Nullable String errorCode) {
        String errorMessage = StringUtil.isNotEmpty((String)errorCode) ? "'" + errorCode + "'" : "current error";
        String string = TsLintBundle.message("tslint.action.fix.problems.current.text", errorMessage);
        if (string == null) {
            TsLintErrorFixAction.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            TsLintErrorFixAction.$$$reportNull$$$0(5);
        }
        return editor != null && editor.getDocument().getModificationStamp() == this.myModificationStamp && this.myError.getFixInfo() != null && file == this.myPsiFilePointer.getElement() && !StringUtil.equals((CharSequence)this.myError.getCode(), (CharSequence)"linebreak-style");
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            TsLintErrorFixAction.$$$reportNull$$$0(6);
        }
        if (!this.isAvailable(project, editor, file)) {
            return;
        }
        TsLintFixInfo info = this.myError.getFixInfo();
        if (info == null) {
            return;
        }
        TsLintFixInfo.TsLintFixReplacements[] replacements = info.innerReplacements;
        if (replacements == null || replacements.length == 0) {
            return;
        }
        Arrays.sort(replacements, REPLACEMENTS_COMPARATOR);
        WriteCommandAction.runWriteCommandAction((Project)project, (String)this.getText(), null, () -> {
            String separator;
            Document document = editor.getDocument();
            if (!TsLintErrorFixAction.applyReplacements(document, separator = FileDocumentManager.getInstance().getLineSeparator(file.getViewProvider().getVirtualFile(), project), replacements)) {
                return;
            }
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        }, (PsiFile[])new PsiFile[0]);
        DaemonCodeAnalyzer.getInstance((Project)project).restart(file);
    }

    private static boolean applyReplacements(@NotNull Document document, @NotNull String separator, @NotNull TsLintFixInfo.TsLintFixReplacements[] replacements) {
        String lf;
        if (document == null) {
            TsLintErrorFixAction.$$$reportNull$$$0(7);
        }
        if (separator == null) {
            TsLintErrorFixAction.$$$reportNull$$$0(8);
        }
        if (replacements == null) {
            TsLintErrorFixAction.$$$reportNull$$$0(9);
        }
        if ((lf = LineSeparator.LF.getSeparatorString()).equals(separator)) {
            return TsLintErrorFixAction.applyFor(document.getTextLength(), replacements, (Consumer<TsLintFixInfo.TsLintFixReplacements>)((Consumer)replacement -> document.replaceString(replacement.innerStart, replacement.innerStart + replacement.innerLength, (CharSequence)StringUtil.notNullize((String)replacement.innerText))));
        }
        StringBuilder newContent = new StringBuilder(StringUtilRt.convertLineSeparators((String)document.getText(), (String)separator));
        if (TsLintErrorFixAction.applyFor(newContent.length(), replacements, (Consumer<TsLintFixInfo.TsLintFixReplacements>)((Consumer)replacement -> newContent.replace(replacement.innerStart, replacement.innerStart + replacement.innerLength, StringUtil.notNullize((String)replacement.innerText))))) {
            document.setText(StringUtilRt.convertLineSeparators((CharSequence)newContent, (String)lf));
            return true;
        }
        return false;
    }

    private static boolean applyFor(int documentLength, @NotNull TsLintFixInfo.TsLintFixReplacements[] replacements, @NotNull Consumer<TsLintFixInfo.TsLintFixReplacements> apply) {
        if (replacements == null) {
            TsLintErrorFixAction.$$$reportNull$$$0(10);
        }
        if (apply == null) {
            TsLintErrorFixAction.$$$reportNull$$$0(11);
        }
        for (TsLintFixInfo.TsLintFixReplacements replacement : replacements) {
            int offset = replacement.innerStart;
            if (offset > documentLength || offset + replacement.innerLength > documentLength) {
                return false;
            }
            apply.consume((Object)replacement);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/tslint/fix/TsLintErrorFixAction";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacements";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apply";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/tslint/fix/TsLintErrorFixAction";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "applyReplacements";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "applyFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

