/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssAttribute;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.CssHighlighter;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class CssHighlightingAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            CssHighlightingAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            CssHighlightingAnnotator.$$$reportNull$$$0(1);
        }
        if (holder.isBatchMode()) {
            return;
        }
        if (element instanceof CssSimpleSelector) {
            PsiElement identifier = ((CssSimpleSelector)element).getNameIdentifier();
            String elementName = ((CssSimpleSelector)element).getElementName();
            if (identifier != null && CssDescriptorsUtil.isPossibleSelector((String)elementName, (PsiElement)element)) {
                CssHighlightingAnnotator.highlight(holder, identifier, CssElementTypes.CSS_TAG_NAME, CssHighlighter.CSS_TAG_NAME);
            }
        } else if (element instanceof CssAttribute) {
            PsiElement identifier = ((CssAttribute)element).getAttributeNameIdentifier();
            if (identifier != null) {
                CssHighlightingAnnotator.highlight(holder, identifier, CssElementTypes.CSS_ATTRIBUTE_NAME, CssHighlighter.CSS_ATTRIBUTE_NAME);
            }
        } else if (element.getNode().getElementType() == CssElementTypes.CSS_IDENT && element.getParent() instanceof CssClass) {
            CssHighlightingAnnotator.highlight(holder, element, CssElementTypes.CSS_CLASS_NAME, CssHighlighter.CSS_CLASS_NAME);
        } else if (element.getNode().getElementType() == CssElementTypes.CSS_ATKEYWORD) {
            CssHighlightingAnnotator.highlight(holder, element, CssElementTypes.CSS_KEYWORD, CssHighlighter.CSS_KEYWORD);
        }
    }

    private static void highlight(@NotNull AnnotationHolder holder, @NotNull PsiElement element, @NotNull IElementType type, @NotNull TextAttributesKey defaultKey) {
        if (holder == null) {
            CssHighlightingAnnotator.$$$reportNull$$$0(2);
        }
        if (element == null) {
            CssHighlightingAnnotator.$$$reportNull$$$0(3);
        }
        if (type == null) {
            CssHighlightingAnnotator.$$$reportNull$$$0(4);
        }
        if (defaultKey == null) {
            CssHighlightingAnnotator.$$$reportNull$$$0(5);
        }
        TextAttributesKey key = CssHighlightingAnnotator.getTextAttributesKey(element, type, defaultKey);
        String annotationMessage = ApplicationManager.getApplication().isUnitTestMode() ? key.getExternalName() : null;
        holder.createInfoAnnotation(element, annotationMessage).setTextAttributes(key);
    }

    private static TextAttributesKey getTextAttributesKey(@NotNull PsiElement element, @NotNull IElementType elementType, @NotNull TextAttributesKey defaultKey) {
        Language language;
        if (element == null) {
            CssHighlightingAnnotator.$$$reportNull$$$0(6);
        }
        if (elementType == null) {
            CssHighlightingAnnotator.$$$reportNull$$$0(7);
        }
        if (defaultKey == null) {
            CssHighlightingAnnotator.$$$reportNull$$$0(8);
        }
        if ((language = CssPsiUtil.getStylesheetLanguage((PsiElement)element)) == null) {
            return defaultKey;
        }
        VirtualFile file = element.getContainingFile().getVirtualFile();
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)element.getProject(), (VirtualFile)file);
        Object[] keys = highlighter.getTokenHighlights(elementType);
        return ArrayUtil.isEmpty((Object[])keys) ? defaultKey : (TextAttributesKey)ArrayUtil.getLastElement((Object[])keys);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultKey";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/css/impl/util/CssHighlightingAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "highlight";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getTextAttributesKey";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

