/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.table;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.css.util.CssConstants;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssPropertyInfo;
import com.intellij.psi.css.CssPropertyValue;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.descriptor.BrowserVersion;
import com.intellij.psi.css.descriptor.CssContextType;
import com.intellij.psi.css.descriptor.CssElementDescriptor;
import com.intellij.psi.css.descriptor.CssMediaGroup;
import com.intellij.psi.css.descriptor.value.CssNullValue;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.impl.util.completion.CssSuffixUserLookup;
import com.intellij.psi.css.impl.util.completion.CssUserLookupBase;
import com.intellij.psi.css.impl.util.table.CssCompletionContext;
import com.intellij.psi.css.impl.util.table.CssPropertyValueImpl;
import com.intellij.psi.css.impl.util.table.CssReferencePropertyValue;
import com.intellij.psi.css.impl.util.table.CssTableValue;
import com.intellij.psi.css.impl.util.table.CssTableValueVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import icons.CssIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCssPropertyDescriptor
implements CssPropertyDescriptor {
    @NonNls
    private static final String EMPTY_STRING = "";
    private Object[] myCachedVariants;

    public boolean isInherited() {
        return this.getInherited();
    }

    @NotNull
    public CssMediaGroup[] getMediaGroups() {
        if (CssConstants.DEFAULT_MEDIA_GROUPS == null) {
            AbstractCssPropertyDescriptor.$$$reportNull$$$0(0);
        }
        return CssConstants.DEFAULT_MEDIA_GROUPS;
    }

    @Nullable
    public String getInitialValue() {
        return EMPTY_STRING;
    }

    @NotNull
    public String getPercentageValue() {
        if (EMPTY_STRING == null) {
            AbstractCssPropertyDescriptor.$$$reportNull$$$0(1);
        }
        return EMPTY_STRING;
    }

    @NotNull
    public String getAppliesToValue() {
        if (EMPTY_STRING == null) {
            AbstractCssPropertyDescriptor.$$$reportNull$$$0(2);
        }
        return EMPTY_STRING;
    }

    @NotNull
    public String getDescription() {
        if (EMPTY_STRING == null) {
            AbstractCssPropertyDescriptor.$$$reportNull$$$0(3);
        }
        return EMPTY_STRING;
    }

    public boolean isValidValue(@NotNull PsiElement element) {
        if (element == null) {
            AbstractCssPropertyDescriptor.$$$reportNull$$$0(4);
        }
        return this.getValue().isValueBelongs(element);
    }

    @NotNull
    public BrowserVersion[] getBrowsers() {
        if (BrowserVersion.EMPTY_ARRAY == null) {
            AbstractCssPropertyDescriptor.$$$reportNull$$$0(5);
        }
        return BrowserVersion.EMPTY_ARRAY;
    }

    public boolean isAllowedInContextType(@NotNull CssContextType contextType) {
        if (contextType == null) {
            AbstractCssPropertyDescriptor.$$$reportNull$$$0(6);
        }
        return true;
    }

    @NotNull
    public String getId() {
        String string = this.getPropertyName();
        if (string == null) {
            AbstractCssPropertyDescriptor.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getPresentableName() {
        String string = this.getId();
        if (string == null) {
            AbstractCssPropertyDescriptor.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public CssElementDescriptor.CssVersion getCssVersion() {
        CssElementDescriptor.CssVersion cssVersion = CssElementDescriptor.CssVersion.UNKNOWN;
        if (cssVersion == null) {
            AbstractCssPropertyDescriptor.$$$reportNull$$$0(9);
        }
        return cssVersion;
    }

    @Deprecated
    @NotNull
    public abstract CssPropertyValue getValue();

    @NotNull
    public PsiElement[] getDeclarations(PsiElement context) {
        if (PsiElement.EMPTY_ARRAY == null) {
            AbstractCssPropertyDescriptor.$$$reportNull$$$0(10);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    public boolean is4ValueProperty() {
        final boolean[] result = new boolean[]{false};
        this.getValue().accept((CssTableValueVisitor)new CssTableValueVisitor.Recursive(){

            public void visitValue(@NotNull CssTableValue value) {
                if (value == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (4 == value.getMaxCount()) {
                    result[0] = true;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/css/impl/util/table/AbstractCssPropertyDescriptor$1", "visitValue"));
            }
        });
        return result[0];
    }

    public CssPropertyValue getReferencedPropertyValue(final @NotNull String name) {
        if (name == null) {
            AbstractCssPropertyDescriptor.$$$reportNull$$$0(11);
        }
        final CssPropertyValue[] result = new CssPropertyValue[]{null};
        this.getValue().accept((CssTableValueVisitor)new CssTableValueVisitor.Recursive<CssPropertyValueImpl>(){

            public void visitValue(@NotNull CssPropertyValueImpl value) {
                String refName;
                if (value == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((refName = value.getRefName()) != null && refName.equals(name)) {
                    result[0] = value;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/css/impl/util/table/AbstractCssPropertyDescriptor$2", "visitValue"));
            }
        });
        return result[0];
    }

    public boolean allowsIntegerWithoutSuffix() {
        Object[] variants = this.getAllVariants();
        boolean containsValuesWithSuffix = false;
        for (Object each : variants) {
            if (each instanceof CssSuffixUserLookup) {
                containsValuesWithSuffix = true;
                continue;
            }
            if (!(each instanceof CssUserLookupBase)) continue;
            if (StringUtil.isNotEmpty((String)((CssUserLookupBase)each).getSuffix())) {
                containsValuesWithSuffix = true;
                continue;
            }
            return true;
        }
        return !containsValuesWithSuffix;
    }

    public Object[] getAllVariants() {
        if (this.myCachedVariants == null) {
            final ArrayList result = new ArrayList();
            this.getValue().accept((CssTableValueVisitor)new CssTableValueVisitor.Recursive(){

                void visitValue(@NotNull CssTableValue value) {
                    if (value == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    Object v = value.getValue();
                    if (!value.isGroup() && v != null && !result.contains(v)) {
                        result.add(v);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/css/impl/util/table/AbstractCssPropertyDescriptor$3", "visitValue"));
                }
            });
            this.myCachedVariants = ArrayUtil.toObjectArray(result);
        }
        return this.myCachedVariants;
    }

    @Nullable
    public String[] getRefNames() {
        final HashSet result = new HashSet();
        this.getValue().accept((CssTableValueVisitor)new CssTableValueVisitor<CssPropertyValueImpl>(){

            public void visit(@NotNull CssPropertyValueImpl value) {
                String refName;
                if (value == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (value.isGroup() && !(value instanceof CssReferencePropertyValue)) {
                    for (CssPropertyValue each : value.getChildren()) {
                        each.accept((CssTableValueVisitor)this);
                    }
                }
                if (value instanceof CssReferencePropertyValue && (refName = value.getRefName()) != null) {
                    result.add(refName);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/css/impl/util/table/AbstractCssPropertyDescriptor$4", "visit"));
            }
        });
        return result.isEmpty() ? null : ArrayUtilRt.toStringArray(result);
    }

    @NotNull
    public Object[] getVariants(@NotNull PsiElement contextElement) {
        if (contextElement == null) {
            AbstractCssPropertyDescriptor.$$$reportNull$$$0(12);
        }
        List<PsiElement> elements = AbstractCssPropertyDescriptor.buildContextPath(contextElement, false);
        List<CssPropertyValue> variants = Collections.singletonList(this.getValue());
        CssCompletionContext c = null;
        int currentElementOffset = contextElement.getTextOffset();
        PsiElement position = contextElement.getContainingFile().getOriginalFile().findElementAt(currentElementOffset);
        if (position == null && currentElementOffset > 0) {
            position = contextElement.getContainingFile().getOriginalFile().findElementAt(currentElementOffset - 1);
        }
        if (position == null) {
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                AbstractCssPropertyDescriptor.$$$reportNull$$$0(13);
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        for (PsiElement element : elements) {
            ArrayList<CssPropertyValue> tempVariants = new ArrayList<CssPropertyValue>();
            boolean current = element == position.getParent();
            c = CssCompletionContext.createContext((PsiElement)element, c, (boolean)current);
            if (!this.getValue().isCompleted(c)) {
                for (CssPropertyValue each : variants) {
                    tempVariants.addAll(each.getVariants(c, contextElement));
                }
                if (tempVariants.isEmpty()) {
                    tempVariants.addAll(this.getValue().getVariants(c, contextElement));
                }
            }
            variants = tempVariants;
            if (!current) continue;
            break;
        }
        Object[] objectArray = AbstractCssPropertyDescriptor.gatherVariants(contextElement, variants.toArray(new CssPropertyValueImpl[0]));
        if (objectArray == null) {
            AbstractCssPropertyDescriptor.$$$reportNull$$$0(14);
        }
        return objectArray;
    }

    protected static Object[] gatherVariants(final PsiElement context, CssPropertyValueImpl ... variants) {
        final HashSet result = new HashSet();
        CssTableValueVisitor<CssPropertyValueImpl> visitor = new CssTableValueVisitor<CssPropertyValueImpl>(){

            public void visit(@NotNull CssPropertyValueImpl value) {
                if (value == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (value.isComplete()) {
                    if (value instanceof CssReferencePropertyValue) {
                        CssPropertyDescriptor descriptor = ((CssReferencePropertyValue)value).getRefDescriptor();
                        result.addAll(Arrays.asList(descriptor.getVariants(context)));
                    } else if (value.isGroup()) {
                        if (!AbstractCssPropertyDescriptor.addDynamicVariants(value, result, context)) {
                            for (CssPropertyValue each : value.getChildren()) {
                                each.accept((CssTableValueVisitor)this);
                            }
                        }
                    } else if (!AbstractCssPropertyDescriptor.addDynamicVariants(value, result, context) && value.getValue() != null) {
                        result.add(value.getValue());
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/css/impl/util/table/AbstractCssPropertyDescriptor$5", "visit"));
            }
        };
        for (CssPropertyValueImpl variant : variants) {
            variant.accept((CssTableValueVisitor)visitor);
        }
        return ArrayUtil.toObjectArray(result);
    }

    private static boolean addDynamicVariants(CssPropertyValueImpl value, Set<Object> result, PsiElement context) {
        List<? extends CssPropertyValue> dynamicVariants = value.getDynamicVariants(context);
        for (CssPropertyValue cssPropertyValue : dynamicVariants) {
            result.add(cssPropertyValue.getValue());
        }
        return !dynamicVariants.isEmpty();
    }

    protected static List<PsiElement> buildContextPath(@NotNull PsiElement context, boolean strict) {
        if (context == null) {
            AbstractCssPropertyDescriptor.$$$reportNull$$$0(15);
        }
        PsiElement psi = context.getParent() instanceof CssTerm ? context.getParent() : context;
        PsiElement originalElement = CompletionUtilCoreImpl.getOriginalElement((PsiElement)psi);
        CssTermList termList = AbstractCssPropertyDescriptor.extractCssTermList(context);
        LinkedList<PsiElement> result = new LinkedList<PsiElement>();
        if (termList != null) {
            for (PsiElement each : termList.getChildren()) {
                if (!(each instanceof CssTerm) || originalElement == each) continue;
                result.add(each);
            }
        }
        if (!strict) {
            result.add(null);
        }
        return result;
    }

    @Nullable
    protected static CssTermList extractCssTermList(PsiElement context) {
        PsiElement originalElement = PsiUtilCore.getOriginalElement((PsiElement)context, PsiElement.class);
        PsiElement declaration = PsiTreeUtil.getParentOfType((PsiElement)originalElement, CssDeclaration.class, (boolean)false);
        if (declaration == null) {
            while (originalElement != null && !(originalElement instanceof CssDeclaration)) {
                originalElement = originalElement.getPrevSibling();
            }
            declaration = originalElement;
        }
        if (declaration != null) {
            return (CssTermList)PsiTreeUtil.getChildOfType((PsiElement)declaration, CssTermList.class);
        }
        return null;
    }

    @Nullable
    public Icon getIcon() {
        return CssIcons.Property;
    }

    public String toString() {
        return this.getPropertyName();
    }

    @NotNull
    public String[] expand(@NotNull CssDeclaration declaration) {
        if (declaration == null) {
            AbstractCssPropertyDescriptor.$$$reportNull$$$0(16);
        }
        if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
            AbstractCssPropertyDescriptor.$$$reportNull$$$0(17);
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    public PsiElement[] getShorthandPsiValue(@NotNull CssDeclaration decl, @NotNull String propertyName) {
        if (decl == null) {
            AbstractCssPropertyDescriptor.$$$reportNull$$$0(18);
        }
        if (propertyName == null) {
            AbstractCssPropertyDescriptor.$$$reportNull$$$0(19);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @NotNull
    public CssPropertyInfo[] getInfos() {
        if (CssPropertyInfo.EMPTY_ARRAY == null) {
            AbstractCssPropertyDescriptor.$$$reportNull$$$0(20);
        }
        return CssPropertyInfo.EMPTY_ARRAY;
    }

    @NotNull
    public String toCanonicalName(@NotNull String propertyName) {
        if (propertyName == null) {
            AbstractCssPropertyDescriptor.$$$reportNull$$$0(21);
        }
        String string = propertyName;
        if (string == null) {
            AbstractCssPropertyDescriptor.$$$reportNull$$$0(22);
        }
        return string;
    }

    @Nullable
    public String getDocumentationString(@Nullable PsiElement context) {
        return null;
    }

    @NotNull
    public String getElementTypeName() {
        String string = CssBundle.message((String)"css.property.name", (Object[])new Object[0]);
        if (string == null) {
            AbstractCssPropertyDescriptor.$$$reportNull$$$0(23);
        }
        return string;
    }

    @Nullable
    public String getSpecificationUrl() {
        return null;
    }

    @NotNull
    public CssContextType[] getAllowedContextTypes() {
        if (CssContextType.EMPTY_ARRAY == null) {
            AbstractCssPropertyDescriptor.$$$reportNull$$$0(24);
        }
        return CssContextType.EMPTY_ARRAY;
    }

    @NotNull
    public CssValueDescriptor getValueDescriptor() {
        CssNullValue cssNullValue = new CssNullValue();
        if (cssNullValue == null) {
            AbstractCssPropertyDescriptor.$$$reportNull$$$0(25);
        }
        return cssNullValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 6: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 6: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/util/table/AbstractCssPropertyDescriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decl";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMediaGroups";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPercentageValue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppliesToValue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 4: 
            case 6: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/util/table/AbstractCssPropertyDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrowsers";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCssVersion";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarations";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "expand";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfos";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "toCanonicalName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementTypeName";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllowedContextTypes";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isValidValue";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAllowedInContextType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getReferencedPropertyValue";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getVariants";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "buildContextPath";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getShorthandPsiValue";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "toCanonicalName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

