/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.entities;

import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.angular2.Angular2DecoratorUtil;
import org.angular2.entities.Angular2Component;
import org.angular2.entities.Angular2Declaration;
import org.angular2.entities.Angular2Directive;
import org.angular2.entities.Angular2DirectiveSelectorPsiElement;
import org.angular2.entities.Angular2Entity;
import org.angular2.entities.Angular2EntityUtils;
import org.angular2.entities.Angular2Module;
import org.angular2.entities.Angular2Pipe;
import org.angular2.entities.metadata.psi.Angular2MetadataClassBase;
import org.angular2.entities.metadata.psi.Angular2MetadataDirectiveBase;
import org.angular2.entities.metadata.psi.Angular2MetadataEntity;
import org.angular2.entities.metadata.psi.Angular2MetadataFunction;
import org.angular2.entities.metadata.psi.Angular2MetadataModule;
import org.angular2.entities.metadata.psi.Angular2MetadataPipe;
import org.angular2.entities.source.Angular2SourceComponent;
import org.angular2.entities.source.Angular2SourceDirective;
import org.angular2.entities.source.Angular2SourceModule;
import org.angular2.entities.source.Angular2SourcePipe;
import org.angular2.index.Angular2IndexingHandler;
import org.angular2.index.Angular2MetadataDirectiveIndex;
import org.angular2.index.Angular2MetadataEntityClassNameIndex;
import org.angular2.index.Angular2MetadataFunctionIndex;
import org.angular2.index.Angular2MetadataModuleIndex;
import org.angular2.index.Angular2MetadataPipeIndex;
import org.angular2.index.Angular2SourceDirectiveIndex;
import org.angular2.index.Angular2SourceModuleIndex;
import org.angular2.index.Angular2SourcePipeIndex;
import org.angular2.lang.Angular2LangUtil;
import org.angularjs.index.AngularIndexUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Angular2EntitiesProvider {
    static final String TRANSFORM_METHOD = "transform";
    private static final EntityGetter<Angular2Directive> DIRECTIVE_GETTER = new EntityGetter(Angular2Directive.class, Angular2IndexingHandler::isDirective, (dec, el) -> "Directive".equals(dec.getDecoratorName()) ? new Angular2SourceDirective((ES6Decorator)dec, (JSImplicitElement)el) : new Angular2SourceComponent((ES6Decorator)dec, (JSImplicitElement)el), new String[]{"Directive", "Component"});
    private static final EntityGetter<Angular2Pipe> PIPE_GETTER = new EntityGetter(Angular2Pipe.class, Angular2IndexingHandler::isPipe, Angular2SourcePipe::new, new String[]{"Pipe"});
    private static final EntityGetter<Angular2Module> MODULE_GETTER = new EntityGetter(Angular2Module.class, Angular2IndexingHandler::isModule, Angular2SourceModule::new, new String[]{"NgModule"});

    @Nullable
    public static Angular2Entity getEntity(@Nullable PsiElement element) {
        Angular2Declaration result = Angular2EntitiesProvider.getDeclaration(element);
        return result != null ? result : Angular2EntitiesProvider.getModule(element);
    }

    @Nullable
    public static Angular2Declaration getDeclaration(@Nullable PsiElement element) {
        Angular2Directive result = Angular2EntitiesProvider.getDirective(element);
        return result != null ? result : Angular2EntitiesProvider.getPipe(element);
    }

    @Nullable
    public static Angular2Component getComponent(@Nullable PsiElement element) {
        return (Angular2Component)ObjectUtils.tryCast((Object)Angular2EntitiesProvider.getDirective(element), Angular2Component.class);
    }

    @Nullable
    public static Angular2Directive getDirective(@Nullable PsiElement element) {
        return DIRECTIVE_GETTER.get(element);
    }

    @Nullable
    public static Angular2Pipe getPipe(@Nullable PsiElement element) {
        if (element instanceof TypeScriptFunction && TRANSFORM_METHOD.equals(((TypeScriptFunction)element).getName()) && element.getContext() instanceof TypeScriptClass) {
            element = element.getContext();
        }
        return PIPE_GETTER.get(element);
    }

    @Nullable
    public static Angular2MetadataFunction findMetadataFunction(@NotNull JSFunction function) {
        if (function == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(0);
        }
        TypeScriptClass parent = (TypeScriptClass)ObjectUtils.tryCast((Object)function.getContext(), TypeScriptClass.class);
        if (function.getName() == null || parent == null) {
            return null;
        }
        Ref result = new Ref();
        StubIndex.getInstance().processElements(Angular2MetadataFunctionIndex.KEY, (Object)function.getName(), function.getProject(), GlobalSearchScope.allScope((Project)function.getProject()), Angular2MetadataFunction.class, f -> {
            Angular2MetadataClassBase parentClass;
            if (f.isValid() && (parentClass = (Angular2MetadataClassBase)((Object)((Object)ObjectUtils.tryCast((Object)f.getContext(), Angular2MetadataClassBase.class)))) != null && parent.equals(parentClass.getTypeScriptClass())) {
                result.set((Object)f);
                return false;
            }
            return true;
        });
        return (Angular2MetadataFunction)((Object)result.get());
    }

    @Nullable
    public static Angular2Module getModule(@Nullable PsiElement element) {
        return MODULE_GETTER.get(element);
    }

    @NotNull
    public static List<Angular2Directive> findElementDirectivesCandidates(@NotNull Project project, @NotNull String elementName) {
        if (project == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(1);
        }
        if (elementName == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(2);
        }
        List<Angular2Directive> list = Angular2EntitiesProvider.findDirectivesCandidates(project, Angular2EntityUtils.getElementDirectiveIndexName(elementName));
        if (list == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public static List<Angular2Directive> findAttributeDirectivesCandidates(@NotNull Project project, @NotNull String attributeName) {
        if (project == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(4);
        }
        if (attributeName == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(5);
        }
        List<Angular2Directive> list = Angular2EntitiesProvider.findDirectivesCandidates(project, Angular2EntityUtils.getAttributeDirectiveIndexName(attributeName));
        if (list == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public static List<Angular2Pipe> findPipes(@NotNull Project project, @NotNull String name) {
        if (project == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(7);
        }
        if (name == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(8);
        }
        SmartList result = new SmartList();
        AngularIndexUtil.multiResolve(project, Angular2SourcePipeIndex.KEY, name, (Processor<? super JSImplicitElement>)((Processor)arg_0 -> Angular2EntitiesProvider.lambda$findPipes$1((List)result, arg_0)));
        Angular2EntitiesProvider.processMetadataEntities(project, name, Angular2MetadataPipe.class, Angular2MetadataPipeIndex.KEY, arg_0 -> Angular2EntitiesProvider.lambda$findPipes$2((List)result, arg_0));
        SmartList smartList = result;
        if (smartList == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(9);
        }
        return smartList;
    }

    @NotNull
    public static List<Angular2Directive> findDirectives(@NotNull Angular2DirectiveSelectorPsiElement selector) {
        if (selector == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(10);
        }
        if (selector.isElementSelector()) {
            List<Angular2Directive> list = Angular2EntitiesProvider.findElementDirectivesCandidates(selector.getProject(), selector.getName());
            if (list == null) {
                Angular2EntitiesProvider.$$$reportNull$$$0(11);
            }
            return list;
        }
        if (selector.isAttributeSelector()) {
            List<Angular2Directive> list = Angular2EntitiesProvider.findAttributeDirectivesCandidates(selector.getProject(), selector.getName());
            if (list == null) {
                Angular2EntitiesProvider.$$$reportNull$$$0(12);
            }
            return list;
        }
        List<Angular2Directive> list = Collections.emptyList();
        if (list == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(13);
        }
        return list;
    }

    @Nullable
    public static Angular2Component findComponent(@NotNull Angular2DirectiveSelectorPsiElement selector) {
        if (selector == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(14);
        }
        return (Angular2Component)ContainerUtil.find(Angular2EntitiesProvider.findDirectives(selector), Angular2Directive::isComponent);
    }

    @NotNull
    public static Map<String, List<Angular2Directive>> getAllElementDirectives(@NotNull Project project) {
        if (project == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(15);
        }
        Map map = (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> CachedValueProvider.Result.create((Object)((StreamEx)StreamEx.of(AngularIndexUtil.getAllKeys(Angular2SourceDirectiveIndex.KEY, project)).append(AngularIndexUtil.getAllKeys(Angular2MetadataDirectiveIndex.KEY, project)).map(name -> Angular2EntityUtils.isElementDirectiveIndexName(name) ? Angular2EntityUtils.getElementName(name) : null).nonNull().distinct()).collect(Collectors.toMap(Function.identity(), name -> Angular2EntitiesProvider.findDirectivesCandidates(project, Angular2EntityUtils.getElementDirectiveIndexName(name)))), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (map == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(16);
        }
        return map;
    }

    @NotNull
    public static Map<String, List<Angular2Pipe>> getAllPipes(@NotNull Project project) {
        if (project == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(17);
        }
        Map map = (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> CachedValueProvider.Result.create((Object)((StreamEx)StreamEx.of(AngularIndexUtil.getAllKeys(Angular2SourcePipeIndex.KEY, project)).append(AngularIndexUtil.getAllKeys(Angular2MetadataPipeIndex.KEY, project)).distinct()).collect(Collectors.toMap(Function.identity(), name -> Angular2EntitiesProvider.findPipes(project, name))), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (map == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(18);
        }
        return map;
    }

    public static boolean isPipeTransformMethod(@Nullable PsiElement element) {
        return element instanceof TypeScriptFunction && TRANSFORM_METHOD.equals(((TypeScriptFunction)element).getName()) && Angular2EntitiesProvider.getPipe(element) != null;
    }

    public static MultiMap<Angular2Declaration, Angular2Module> getExportedDeclarationToModuleMap(@NotNull Project project) {
        if (project == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(19);
        }
        return (MultiMap)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            MultiMap result = new MultiMap();
            Angular2EntitiesProvider.getAllModules(project).forEach(module -> module.getAllExportedDeclarations().forEach(decl -> result.putValue(decl, module)));
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    public static MultiMap<Angular2Declaration, Angular2Module> getDeclarationToModuleMap(@NotNull Project project) {
        if (project == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(20);
        }
        return (MultiMap)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            MultiMap result = new MultiMap();
            Angular2EntitiesProvider.getAllModules(project).forEach(module -> module.getDeclarations().forEach(decl -> result.putValue(decl, module)));
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    public static List<Angular2Module> getAllModules(@NotNull Project project) {
        if (project == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(21);
        }
        return (List)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            ArrayList result = new ArrayList();
            StubIndex.getInstance().processElements(Angular2SourceModuleIndex.KEY, (Object)"ngModule", project, GlobalSearchScope.allScope((Project)project), JSImplicitElementProvider.class, module -> {
                if (module.isValid()) {
                    ContainerUtil.addIfNotNull((Collection)result, (Object)Angular2EntitiesProvider.getModule((PsiElement)module));
                }
                return true;
            });
            StubIndex.getInstance().processElements(Angular2MetadataModuleIndex.KEY, (Object)"ngModule", project, GlobalSearchScope.allScope((Project)project), Angular2MetadataModule.class, module -> {
                if (module.isValid()) {
                    result.add(module);
                }
                return true;
            });
            return CachedValueProvider.Result.create(result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    @NotNull
    private static List<Angular2Directive> findDirectivesCandidates(@NotNull Project project, @NotNull String indexLookupName) {
        if (project == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(22);
        }
        if (indexLookupName == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(23);
        }
        ArrayList<Angular2Directive> result = new ArrayList<Angular2Directive>();
        StubIndex.getInstance().processElements(Angular2SourceDirectiveIndex.KEY, (Object)indexLookupName, project, GlobalSearchScope.allScope((Project)project), JSImplicitElementProvider.class, provider -> {
            Collection elements;
            JSElementIndexingData indexingData = provider.getIndexingData();
            if (indexingData != null && (elements = indexingData.getImplicitElements()) != null) {
                for (JSImplicitElement element : elements) {
                    Angular2Directive directive;
                    if (!element.isValid() || (directive = Angular2EntitiesProvider.getDirective((PsiElement)element)) == null) continue;
                    result.add(directive);
                    return true;
                }
            }
            return true;
        });
        Angular2EntitiesProvider.processMetadataEntities(project, indexLookupName, Angular2MetadataDirectiveBase.class, Angular2MetadataDirectiveIndex.KEY, el -> {
            result.add((Angular2Directive)el);
            return true;
        });
        ArrayList<Angular2Directive> arrayList = result;
        if (arrayList == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(24);
        }
        return arrayList;
    }

    private static <T extends Angular2MetadataEntity> void processMetadataEntities(@NotNull Project project, @NotNull String name, @NotNull Class<T> entityClass, @NotNull StubIndexKey<String, T> key, @NotNull Processor<? super T> processor) {
        if (project == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(25);
        }
        if (name == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(26);
        }
        if (entityClass == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(27);
        }
        if (key == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(28);
        }
        if (processor == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(29);
        }
        StubIndex.getInstance().processElements(key, (Object)name, project, GlobalSearchScope.allScope((Project)project), entityClass, el -> {
            if (el.isValid()) {
                return processor.process(el);
            }
            return true;
        });
    }

    private static /* synthetic */ boolean lambda$findPipes$2(List result, Angular2MetadataPipe p) {
        result.add(p);
        return true;
    }

    private static /* synthetic */ boolean lambda$findPipes$1(List result, JSImplicitElement pipe) {
        ContainerUtil.addIfNotNull((Collection)result, (Object)Angular2EntitiesProvider.getPipe((PsiElement)pipe));
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 18: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 18: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementName";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angular2/entities/Angular2EntitiesProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 8: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexLookupName";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entityClass";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angular2/entities/Angular2EntitiesProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementDirectivesCandidates";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findAttributeDirectivesCandidates";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findPipes";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findDirectives";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllElementDirectives";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPipes";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "findDirectivesCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findMetadataFunction";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findElementDirectivesCandidates";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 18: 
            case 24: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findAttributeDirectivesCandidates";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findPipes";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findDirectives";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findComponent";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getAllElementDirectives";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getAllPipes";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getExportedDeclarationToModuleMap";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationToModuleMap";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getAllModules";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findDirectivesCandidates";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "processMetadataEntities";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 18: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EntityGetter<T extends Angular2Entity> {
        private final Class<T> myEntityClass;
        private final Condition<? super JSImplicitElement> myImplicitElementTester;
        private final BiFunction<? super ES6Decorator, ? super JSImplicitElement, ? extends T> myEntityConstructor;
        private final String[] myDecoratorNames;

        private EntityGetter(@NotNull Class<T> aClass, @NotNull Condition<? super JSImplicitElement> tester, @NotNull BiFunction<? super ES6Decorator, ? super JSImplicitElement, ? extends T> constructor, String ... names) {
            if (aClass == null) {
                EntityGetter.$$$reportNull$$$0(0);
            }
            if (tester == null) {
                EntityGetter.$$$reportNull$$$0(1);
            }
            if (constructor == null) {
                EntityGetter.$$$reportNull$$$0(2);
            }
            if (names == null) {
                EntityGetter.$$$reportNull$$$0(3);
            }
            this.myEntityClass = aClass;
            this.myImplicitElementTester = tester;
            this.myEntityConstructor = constructor;
            this.myDecoratorNames = names;
        }

        /*
         * Enabled aggressive block sorting
         */
        public T get(@Nullable PsiElement element) {
            block8: {
                if (element instanceof JSImplicitElement) {
                    if (!this.myImplicitElementTester.value((Object)((JSImplicitElement)element))) {
                        return null;
                    }
                    element = element.getContext();
                }
                if (element instanceof TypeScriptClass) {
                    ES6Decorator decorator = Angular2DecoratorUtil.findDecorator((JSAttributeListOwner)((TypeScriptClass)element), this.myDecoratorNames);
                    if (decorator != null) {
                        element = decorator;
                        break block8;
                    } else {
                        if (!Angular2LangUtil.isAngular2Context(element)) {
                            return null;
                        }
                        TypeScriptClass typeScriptClass = (TypeScriptClass)element;
                        String className = typeScriptClass.getName();
                        if (className != null && Objects.requireNonNull(typeScriptClass.getAttributeList()).hasModifier(JSAttributeList.ModifierType.DECLARE)) {
                            Ref result = new Ref();
                            StubIndex.getInstance().processElements(Angular2MetadataEntityClassNameIndex.KEY, (Object)className, typeScriptClass.getProject(), GlobalSearchScope.allScope((Project)typeScriptClass.getProject()), Angular2MetadataEntity.class, e -> {
                                if (e.isValid() && this.myEntityClass.isInstance(e) && e.getTypeScriptClass() == typeScriptClass) {
                                    result.set(e);
                                    return false;
                                }
                                return true;
                            });
                            return (T)((Angular2Entity)result.get());
                        }
                        return null;
                    }
                }
                if (!(element instanceof ES6Decorator) || !Angular2DecoratorUtil.isAngularDecorator((ES6Decorator)element, this.myDecoratorNames)) {
                    return null;
                }
            }
            ES6Decorator dec = (ES6Decorator)element;
            return (T)((Angular2Entity)CachedValuesManager.getCachedValue((PsiElement)dec, () -> {
                JSImplicitElement entityElement = null;
                if (dec.getIndexingData() != null) {
                    entityElement = (JSImplicitElement)ContainerUtil.find((Iterable)((Iterable)ObjectUtils.notNull((Object)dec.getIndexingData().getImplicitElements(), Collections::emptyList)), this.myImplicitElementTester);
                }
                return CachedValueProvider.Result.create((Object)(entityElement != null ? (Angular2Entity)this.myEntityConstructor.apply((ES6Decorator)dec, entityElement) : null), (Object[])new Object[]{dec});
            }));
        }

        public String toString() {
            return Arrays.toString(this.myDecoratorNames) + " - " + super.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "aClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tester";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "constructor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "names";
                    break;
                }
            }
            objectArray[1] = "org/angular2/entities/Angular2EntitiesProvider$EntityGetter";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

