/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.inspections.quickfixes;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.angular2.cli.AngularCliUtil;
import org.angular2.cli.actions.AngularCliAddDependencyAction;
import org.angular2.lang.Angular2Bundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AngularCliAddQuickFix
implements LocalQuickFix,
HighPriorityAction {
    private final VirtualFile myPackageJson;
    private final String myPackageName;
    private final String myVersionSpec;
    private final boolean myReinstall;

    public AngularCliAddQuickFix(@NotNull VirtualFile packageJson, @NotNull String packageName, @NotNull String versionSpec, boolean reinstall) {
        if (packageJson == null) {
            AngularCliAddQuickFix.$$$reportNull$$$0(0);
        }
        if (packageName == null) {
            AngularCliAddQuickFix.$$$reportNull$$$0(1);
        }
        if (versionSpec == null) {
            AngularCliAddQuickFix.$$$reportNull$$$0(2);
        }
        this.myPackageJson = packageJson;
        this.myPackageName = packageName;
        this.myVersionSpec = versionSpec;
        this.myReinstall = reinstall;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = Angular2Bundle.message(this.myReinstall ? "angular.quickfix.json.ng-add.name.reinstall" : "angular.quickfix.json.ng-add.name.run", this.myPackageName);
        if (string == null) {
            AngularCliAddQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = Angular2Bundle.message("angular.quickfix.json.ng-add.family", new Object[0]);
        if (string == null) {
            AngularCliAddQuickFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            AngularCliAddQuickFix.$$$reportNull$$$0(5);
        }
        if (descriptor == null) {
            AngularCliAddQuickFix.$$$reportNull$$$0(6);
        }
        if (AngularCliUtil.hasAngularCLIPackageInstalled(project, this.myPackageJson)) {
            AngularCliAddDependencyAction.runAndShowConsoleLater(project, this.myPackageJson.getParent(), this.myPackageName, this.myVersionSpec.trim(), !this.myReinstall);
        } else {
            AngularCliUtil.notifyAngularCliNotInstalled(project, this.myPackageJson.getParent(), Angular2Bundle.message("angular.quickfix.json.ng-add.error.cant-run", new Object[0]));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionSpec";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angular2/inspections/quickfixes/AngularCliAddQuickFix";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angular2/inspections/quickfixes/AngularCliAddQuickFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

