/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.v8;

import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.StepAction;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.jsonProtocol.EventType;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.jsonProtocol.ResponseResultReader;
import org.jetbrains.rpc.CommandProcessorKt;
import org.jetbrains.v8.BreakEventHandlerKt;
import org.jetbrains.v8.EventMapKt;
import org.jetbrains.v8.V8ScriptManager;
import org.jetbrains.v8.V8SuspendContextManagerKt;
import org.jetbrains.v8.V8Vm;
import org.jetbrains.v8.protocol.IncomingMessage;
import org.jetbrains.v8.protocol.PausedEventData;
import org.jetbrains.v8.protocol.ProtocolResponseReader;
import org.jetbrains.v8.protocol.ScriptHandle;
import org.jetbrains.v8.protocol.ScriptParsedEventData;
import org.jetbrains.v8.protocol.V8ProtocolReader;
import org.jetbrains.v8.protocol.V8ProtocolUtilKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/v8/EventMap;", "", "vm", "Lorg/jetbrains/v8/V8Vm;", "(Lorg/jetbrains/v8/V8Vm;)V", "eventMap", "Lorg/jetbrains/jsonProtocol/EventMap;", "Lorg/jetbrains/v8/protocol/ProtocolResponseReader;", "handleResponseWithHandler", "", "message", "Lorg/jetbrains/v8/protocol/IncomingMessage;", "intellij.javascript.v8.backend"})
public final class EventMap {
    private final org.jetbrains.jsonProtocol.EventMap<ProtocolResponseReader> eventMap;
    private final V8Vm vm;

    public final void handleResponseWithHandler(@NotNull IncomingMessage message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        String string = message.event();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        switch (string) {
            case "exception": 
            case "break": {
                this.vm.getInitialBreakEvent$intellij_javascript_v8_backend().set(message);
                if (this.vm.getBootstrapped() && this.vm.getInitialBreakEvent$intellij_javascript_v8_backend().compareAndSet(message, null)) {
                    BreakEventHandlerKt.processBreak(message, this.vm);
                }
                return;
            }
            case "afterCompile": {
                ScriptHandle scriptHandle = EventMapKt.access$getScriptToAdd(message);
                if (scriptHandle != null) {
                    ScriptHandle scriptHandle2 = scriptHandle;
                    boolean bl = false;
                    boolean bl2 = false;
                    ScriptHandle it = scriptHandle2;
                    boolean bl3 = false;
                    this.vm.getScriptManager().addScript(it, message.refs());
                }
                break;
            }
            case "scriptCollected": {
                V8ScriptManager v8ScriptManager = this.vm.getScriptManager();
                V8ProtocolReader v8ProtocolReader = V8ProtocolUtilKt.getPROTOCOL_READER();
                JsonReaderEx jsonReaderEx = message.body();
                if (jsonReaderEx == null) {
                    Intrinsics.throwNpe();
                }
                v8ScriptManager.scriptCollected(v8ProtocolReader.readScriptCollected(jsonReaderEx).script().id());
                return;
            }
            case "compileError": {
                return;
            }
            default: {
                String string2 = message.event();
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                this.eventMap.handleEvent(string2, message.body());
                return;
            }
        }
    }

    public EventMap(@NotNull V8Vm vm) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)vm), (String)"vm");
        this.vm = vm;
        this.eventMap = new org.jetbrains.jsonProtocol.EventMap((ResponseResultReader)V8ProtocolUtilKt.getPROTOCOL_READER());
        this.eventMap.add((EventType)ScriptParsedEventData.TYPE, (Function1)new Function1<ScriptParsedEventData, Unit>(){

            public final void invoke(@Nullable ScriptParsedEventData it) {
                ScriptParsedEventData scriptParsedEventData = it;
                vm.getScriptManager().addScript(scriptParsedEventData != null ? scriptParsedEventData.script() : null);
            }
        });
        this.eventMap.add((EventType)PausedEventData.TYPE, (Function1)new Function1<PausedEventData, Unit>(){

            public final void invoke(@NotNull PausedEventData it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                int[] breakpoints = it.getBreakpoints();
                if (breakpoints != null && breakpoints.length == 1 && vm.getBreakpointManager().isBreakpointObsolete(ArraysKt.first((int[])breakpoints))) {
                    Logger $this$debug$iv = CommandProcessorKt.getLOG();
                    Exception e$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug$iv.isDebugEnabled()) {
                        Logger logger = $this$debug$iv;
                        boolean bl = false;
                        String string = "Continue, breakpoint " + ArraysKt.first((int[])breakpoints) + " was removed";
                        logger.debug(string, (Throwable)e$iv);
                    }
                    vm.getCommandProcessor().send((Request)V8SuspendContextManagerKt.ContinueMessage$default(StepAction.CONTINUE, 0, 2, null));
                    return;
                }
                BreakEventHandlerKt.processBreakWithFrameInfo(null, null, PausedEventData.TYPE.getMethodName(), it.frame(), breakpoints, it.getObjects(), vm, it.frameCount());
            }
        });
    }
}

