/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.highlight;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.linter.JSLinterSuppressionUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TsLintSuppressionUtil
extends JSLinterSuppressionUtil {
    public static final TsLintSuppressionUtil INSTANCE = new TsLintSuppressionUtil();
    private static final String LINE_COMMENT_PREFIX = "tslint:disable-next-line";
    private static final Pattern LINE_SUPPRESSION_PATTERN = Pattern.compile("(?://|/\\*)\\s*tslint:disable-next-line:\\s*(.*?)(?:\\*/)?");
    private static final Pattern FILE_SUPPRESSION_PATTERN = Pattern.compile("/\\*\\s*tslint:disable:\\s*(.*?)\\s*\\*/");
    private static final String FILE_COMMENT_PREFIX = "tslint:disable";

    private TsLintSuppressionUtil() {
    }

    @Nullable
    protected String getRulesFromFileLevelComment(@NotNull PsiComment comment) {
        Matcher matcher;
        if (comment == null) {
            TsLintSuppressionUtil.$$$reportNull$$$0(0);
        }
        if (comment.getNode().getElementType() != JSTokenTypes.C_STYLE_COMMENT) {
            return null;
        }
        String text = comment.getText();
        if (text.contains(FILE_COMMENT_PREFIX) && (matcher = FILE_SUPPRESSION_PATTERN.matcher(text)).matches()) {
            return matcher.group(1).trim();
        }
        return null;
    }

    @Nullable
    protected String getRulesFromLineSuppressionComment(@NotNull PsiComment comment) {
        Matcher matcher;
        String text;
        if (comment == null) {
            TsLintSuppressionUtil.$$$reportNull$$$0(1);
        }
        if ((text = comment.getText()).contains(LINE_COMMENT_PREFIX) && (matcher = LINE_SUPPRESSION_PATTERN.matcher(text)).matches()) {
            return matcher.group(1).trim();
        }
        return null;
    }

    @NotNull
    protected String getToolName() {
        if ("TSLint" == null) {
            TsLintSuppressionUtil.$$$reportNull$$$0(2);
        }
        return "TSLint";
    }

    @NotNull
    protected String buildFileCommentText(@Nullable String existing, @Nullable String toAdd) {
        String string = TsLintSuppressionUtil.getCommentText(FILE_COMMENT_PREFIX, existing, toAdd);
        if (string == null) {
            TsLintSuppressionUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    protected String buildLineCommentText(@Nullable String ruleCode, @Nullable String existingSuppressions) {
        String string = TsLintSuppressionUtil.getCommentText(LINE_COMMENT_PREFIX, existingSuppressions, ruleCode);
        if (string == null) {
            TsLintSuppressionUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private static String getCommentText(String prefix, @Nullable String existing, @Nullable String toAdd) {
        if (toAdd == null) {
            String string = prefix;
            if (string == null) {
                TsLintSuppressionUtil.$$$reportNull$$$0(5);
            }
            return string;
        }
        String rules = StringUtil.isEmpty((String)existing) ? toAdd : existing + " " + toAdd;
        String string = prefix + (StringUtil.isEmpty((String)rules) ? "" : ":" + rules);
        if (string == null) {
            TsLintSuppressionUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/tslint/highlight/TsLintSuppressionUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/tslint/highlight/TsLintSuppressionUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFileCommentText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildLineCommentText";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRulesFromFileLevelComment";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRulesFromLineSuppressionComment";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

