/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework;

import com.intellij.javascript.testFramework.AbstractTestFileStructure;
import com.intellij.javascript.testFramework.JstdRunElement;
import com.intellij.javascript.testFramework.util.TestMethodNameRefiner;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestFileStructurePack {
    private final List<AbstractTestFileStructure> myTestFileStructures;

    public TestFileStructurePack(@NotNull List<AbstractTestFileStructure> testFileStructures) {
        if (testFileStructures == null) {
            TestFileStructurePack.$$$reportNull$$$0(0);
        }
        this.myTestFileStructures = testFileStructures;
    }

    public boolean isEmpty() {
        for (AbstractTestFileStructure structure : this.myTestFileStructures) {
            if (structure.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public JstdRunElement getJstdRunElement(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            TestFileStructurePack.$$$reportNull$$$0(1);
        }
        TextRange textRange = psiElement.getTextRange();
        for (AbstractTestFileStructure testFileStructure : this.myTestFileStructures) {
            JstdRunElement jstdRunElement = testFileStructure.findJstdRunElement(textRange);
            if (jstdRunElement == null) continue;
            return jstdRunElement;
        }
        return null;
    }

    @Nullable
    public PsiElement findPsiElement(@NotNull String testCaseName, @Nullable String testMethodName, @Nullable TestMethodNameRefiner testMethodNameRefiner) {
        if (testCaseName == null) {
            TestFileStructurePack.$$$reportNull$$$0(2);
        }
        for (AbstractTestFileStructure testFileStructure : this.myTestFileStructures) {
            PsiElement element;
            String refinedTestMethodName = testMethodName;
            if (testMethodNameRefiner != null && testMethodName != null) {
                refinedTestMethodName = testMethodNameRefiner.refine(testFileStructure, testMethodName);
            }
            if ((element = testFileStructure.findPsiElement(testCaseName, refinedTestMethodName)) == null) continue;
            return element;
        }
        return null;
    }

    public boolean contains(@NotNull String testCaseName, @Nullable String testMethodName, @Nullable TestMethodNameRefiner testMethodNameRefiner) {
        if (testCaseName == null) {
            TestFileStructurePack.$$$reportNull$$$0(3);
        }
        for (AbstractTestFileStructure testFileStructure : this.myTestFileStructures) {
            boolean ok;
            String refinedTestMethodName = testMethodName;
            if (testMethodNameRefiner != null && testMethodName != null) {
                refinedTestMethodName = testMethodNameRefiner.refine(testFileStructure, testMethodName);
            }
            if (!(ok = testFileStructure.contains(testCaseName, refinedTestMethodName))) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<String> getTopLevelElements() {
        ArrayList<String> out = new ArrayList<String>();
        for (AbstractTestFileStructure structure : this.myTestFileStructures) {
            if (structure.isEmpty()) continue;
            List<String> topLevel = structure.getTopLevelElements();
            out.addAll(topLevel);
        }
        ArrayList<String> arrayList = out;
        if (arrayList == null) {
            TestFileStructurePack.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    public List<String> getChildrenOf(String topLevelElementName) {
        ArrayList<String> out = new ArrayList<String>();
        for (AbstractTestFileStructure structure : this.myTestFileStructures) {
            List<String> localChildren = structure.getChildrenOf(topLevelElementName);
            out.addAll(localChildren);
        }
        ArrayList<String> arrayList = out;
        if (arrayList == null) {
            TestFileStructurePack.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFileStructures";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testCaseName";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testFramework/TestFileStructurePack";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testFramework/TestFileStructurePack";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelElements";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenOf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getJstdRunElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findPsiElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

