/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.navigation;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.testframework.sm.FileUrlProvider;
import com.intellij.execution.testframework.sm.TestsLocationProviderUtil;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.javascript.testFramework.JsTestFileByTestNameIndex;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructure;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructureBuilder;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructure;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructureBuilder;
import com.intellij.javascript.testFramework.util.EscapeUtils;
import com.intellij.javascript.testFramework.util.JsTestFqn;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSTestFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTestLocationProvider
implements SMTestLocator {
    private static final String PROTOCOL_ID__TEST_SUITE = "suite";
    private static final String PROTOCOL_ID__TEST = "test";
    private final boolean myLocationUrlStartsWithTestFilePath;

    public JSTestLocationProvider() {
        this(false);
    }

    public JSTestLocationProvider(boolean locationUrlStartsWithTestFilePath) {
        this.myLocationUrlStartsWithTestFilePath = locationUrlStartsWithTestFilePath;
    }

    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (protocol == null) {
            JSTestLocationProvider.$$$reportNull$$$0(0);
        }
        if (path == null) {
            JSTestLocationProvider.$$$reportNull$$$0(1);
        }
        if (project == null) {
            JSTestLocationProvider.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            JSTestLocationProvider.$$$reportNull$$$0(3);
        }
        if ("file".equals(protocol)) {
            List list = FileUrlProvider.INSTANCE.getLocation(protocol, path, project, scope);
            if (list == null) {
                JSTestLocationProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        Object location = PROTOCOL_ID__TEST_SUITE.equals(protocol) || PROTOCOL_ID__TEST.equals(protocol) ? this.getTestLocation(project, path) : null;
        if (location != null) {
            List<Location> list = Collections.singletonList(location);
            if (list == null) {
                JSTestLocationProvider.$$$reportNull$$$0(5);
            }
            return list;
        }
        List<Location> list = Collections.emptyList();
        if (list == null) {
            JSTestLocationProvider.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Nullable
    private Location getTestLocation(@NotNull Project project, @NotNull String locationData) {
        List<String> path;
        if (project == null) {
            JSTestLocationProvider.$$$reportNull$$$0(7);
        }
        if (locationData == null) {
            JSTestLocationProvider.$$$reportNull$$$0(8);
        }
        if ((path = EscapeUtils.split(locationData, '.')).isEmpty()) {
            return null;
        }
        String testFilePath = null;
        List<String> names = path;
        if (this.myLocationUrlStartsWithTestFilePath) {
            testFilePath = (String)ContainerUtil.getFirstItem(path);
            names = path.subList(1, path.size());
        }
        if (names.isEmpty()) {
            return null;
        }
        PsiElement element = JSTestLocationProvider.findFqnElement(project, new JsTestFqn(JSTestFileType.JASMINE, names), testFilePath);
        if (element == null) {
            element = JSTestLocationProvider.findFqnElement(project, new JsTestFqn(JSTestFileType.QUNIT, names), testFilePath);
        }
        return element != null ? PsiLocation.fromPsiElement((PsiElement)element) : null;
    }

    public boolean isLocationUrlStartedWithTestFilePath() {
        return this.myLocationUrlStartsWithTestFilePath;
    }

    @Nullable
    private static PsiElement findFqnElement(@NotNull Project project, @NotNull JsTestFqn testFqn, @Nullable String preferredTestFilePath) {
        PsiElement result;
        if (project == null) {
            JSTestLocationProvider.$$$reportNull$$$0(9);
        }
        if (testFqn == null) {
            JSTestLocationProvider.$$$reportNull$$$0(10);
        }
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
        VirtualFile testFile = null;
        if (StringUtil.isNotEmpty((String)preferredTestFilePath)) {
            List files = TestsLocationProviderUtil.findSuitableFilesFor((String)preferredTestFilePath, (Project)project);
            testFile = (VirtualFile)ContainerUtil.getFirstItem((List)files);
        }
        if (testFile != null && (result = JSTestLocationProvider.doFindFqnElement(project, testFqn, Collections.singletonList(testFile))) != null) {
            return result;
        }
        List<VirtualFile> testFiles = JsTestFileByTestNameIndex.findFiles(testFqn, scope, testFile);
        return JSTestLocationProvider.doFindFqnElement(project, testFqn, testFiles);
    }

    @Nullable
    private static PsiElement doFindFqnElement(@NotNull Project project, @NotNull JsTestFqn testFqn, @NotNull List<VirtualFile> testFiles) {
        block6: {
            block5: {
                if (project == null) {
                    JSTestLocationProvider.$$$reportNull$$$0(11);
                }
                if (testFqn == null) {
                    JSTestLocationProvider.$$$reportNull$$$0(12);
                }
                if (testFiles == null) {
                    JSTestLocationProvider.$$$reportNull$$$0(13);
                }
                if (testFqn.getType() != JSTestFileType.JASMINE) break block5;
                JasmineFileStructureBuilder builder = JasmineFileStructureBuilder.getInstance();
                for (VirtualFile file : testFiles) {
                    JasmineFileStructure jasmineFileStructure;
                    PsiElement element;
                    PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                    if (!(psiFile instanceof JSFile) || (element = (jasmineFileStructure = (JasmineFileStructure)builder.fetchCachedTestFileStructure((JSFile)psiFile)).findPsiElement(testFqn.getNames(), null)) == null || !element.isValid()) continue;
                    return element;
                }
                break block6;
            }
            if (testFqn.getType() != JSTestFileType.QUNIT) break block6;
            QUnitFileStructureBuilder builder = QUnitFileStructureBuilder.getInstance();
            for (VirtualFile file : testFiles) {
                PsiElement element;
                String testMethodName;
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                if (!(psiFile instanceof JSFile)) continue;
                QUnitFileStructure qunitFileStructure = (QUnitFileStructure)builder.fetchCachedTestFileStructure((JSFile)psiFile);
                String testCaseName = (String)ContainerUtil.getFirstItem(testFqn.getNames());
                String string = testMethodName = testFqn.getNames().size() > 1 ? testFqn.getNames().get(1) : null;
                if (testCaseName == null || (element = qunitFileStructure.findPsiElement(testCaseName, testMethodName)) == null || !element.isValid()) continue;
                return element;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testFramework/navigation/JSTestLocationProvider";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locationData";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFqn";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testFramework/navigation/JSTestLocationProvider";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTestLocation";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findFqnElement";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doFindFqnElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

