/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.profiler;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.jetbrains.python.profiler.CallTreeNode;
import com.jetbrains.python.profiler.UtilsKt;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003JF\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/python/profiler/CallTreeCellRenderer;", "Lcom/intellij/ui/SimpleColoredRenderer;", "Ljavax/swing/tree/TreeCellRenderer;", "()V", "getTreeCellRendererComponent", "Ljava/awt/Component;", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "intellij.python.profiler"})
public final class CallTreeCellRenderer
extends SimpleColoredRenderer
implements TreeCellRenderer {
    @Override
    @Nullable
    public Component getTreeCellRendererComponent(@Nullable JTree tree, @Nullable Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.clear();
        if (value2 instanceof DefaultMutableTreeNode) {
            Object object = ((DefaultMutableTreeNode)value2).getUserObject();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.python.profiler.CallTreeNode");
            }
            CallTreeNode v = (CallTreeNode)object;
            String format = UtilsKt.formatPercent(v.getPercent());
            this.append(format, new SimpleTextAttributes(0, (Color)JBColor.BLUE));
            this.append("  ");
            String funname = v.getName();
            int funline = v.getLine();
            String filename = v.getFile();
            this.append(funname, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            this.append(" - ");
            this.append(String.valueOf(v.getTime()) + " ms", new SimpleTextAttributes(0, (Color)JBColor.BLUE));
            if (StringUtil.isNotEmpty((String)v.getFile())) {
                this.append(" - ");
                this.append(filename + ":" + funline, SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
            }
        }
        return (Component)((Object)this);
    }
}

