/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.profiler;

import com.google.common.collect.Maps;
import com.jetbrains.python.profiler.CallTreeNode;
import com.jetbrains.python.profiler.CallTreeStat;
import com.jetbrains.python.profiler.ProfileDataKt;
import com.jetbrains.python.profiler.Sample;
import com.jetbrains.python.profiler.UtilsKt;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0000J\b\u0010\u0019\u001a\u00020\u000eH\u0016J\b\u0010\u001a\u001a\u00020\u000eH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u000eH\u0016J\b\u0010\u001f\u001a\u00020\u000eH\u0016J\u0014\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0 H\u0016J\b\u0010!\u001a\u00020\u001dH\u0016J\b\u0010\"\u001a\u00020\u000eH\u0016J\b\u0010#\u001a\u00020\u0005H\u0016J\b\u0010$\u001a\u00020\u0005H\u0016J\b\u0010%\u001a\u00020\u000eH\u0016J\b\u0010&\u001a\u00020\u000eH\u0016J\b\u0010'\u001a\u00020(H\u0016R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/jetbrains/python/profiler/CallTreeNodeData;", "Lcom/jetbrains/python/profiler/CallTreeNode;", "treeStats", "Lcom/jetbrains/python/profiler/CallTreeStat;", "percent", "", "percentOfParent", "samplingInterval", "(Lcom/jetbrains/python/profiler/CallTreeStat;DDD)V", "children", "Ljava/util/ArrayList;", "getChildren", "()Ljava/util/ArrayList;", "hits", "", "lineHits", "Ljava/util/HashMap;", "getLineHits", "()Ljava/util/HashMap;", "ownTime", "parsedSample", "Lcom/jetbrains/python/profiler/Sample;", "addChild", "", "node", "getBaseTotalTime", "getCallCount", "", "getFile", "", "getHits", "getLine", "", "getName", "getOwnTimeMs", "getPercent", "getPercentOfParent", "getTime", "getTotalTimeMs", "isVisible", "", "intellij.python.profiler"})
public final class CallTreeNodeData
implements CallTreeNode {
    private final int hits;
    private final Sample parsedSample;
    private final int ownTime;
    @NotNull
    private final ArrayList<CallTreeNode> children;
    @NotNull
    private final HashMap<Integer, Integer> lineHits;
    private final double percent;
    private final double percentOfParent;

    @NotNull
    public final ArrayList<CallTreeNode> getChildren() {
        return this.children;
    }

    @NotNull
    public final HashMap<Integer, Integer> getLineHits() {
        return this.lineHits;
    }

    public final void addChild(@NotNull CallTreeNodeData node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        this.children.add(node);
    }

    @Override
    public boolean isVisible() {
        return this.parsedSample.isVisible();
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.parsedSample.getName();
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    public int getHits() {
        return this.hits;
    }

    @Override
    public double getPercent() {
        return this.percent;
    }

    @Override
    public double getPercentOfParent() {
        return this.percentOfParent;
    }

    @Override
    @NotNull
    public List<CallTreeNode> getChildren() {
        Iterable $this$sortedByDescending$iv = this.children;
        boolean $i$f$sortedByDescending = false;
        Iterable iterable = $this$sortedByDescending$iv;
        boolean bl = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                CallTreeNode node = (CallTreeNode)b;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(node.getTime());
                node = (CallTreeNode)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = node.getTime();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        };
        return CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
    }

    @Override
    public int getTime() {
        return this.ownTime;
    }

    @Override
    @NotNull
    public String getFile() {
        String string = this.parsedSample.getFile();
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    public int getLine() {
        Integer n = this.parsedSample.getLine();
        return n != null ? n : -1;
    }

    @Override
    public int getCallCount() {
        return this.hits;
    }

    @Override
    public int getTotalTimeMs() {
        return this.ownTime;
    }

    @Override
    public int getOwnTimeMs() {
        return this.ownTime;
    }

    @Override
    public int getBaseTotalTime() {
        return this.ownTime;
    }

    @Override
    @NotNull
    public Map<Integer, Integer> getLineHits() {
        return this.lineHits;
    }

    public CallTreeNodeData(@NotNull CallTreeStat treeStats, double percent, double percentOfParent, double samplingInterval) {
        Intrinsics.checkParameterIsNotNull((Object)treeStats, (String)"treeStats");
        this.percent = percent;
        this.percentOfParent = percentOfParent;
        this.hits = treeStats.count;
        String string = treeStats.name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"treeStats.name");
        this.parsedSample = UtilsKt.parseVmProfSampleName(string);
        this.ownTime = ProfileDataKt.hitsToOwnTimeMs(samplingInterval, treeStats.count);
        this.children = new ArrayList();
        HashMap hashMap = Maps.newHashMap(treeStats.line_count);
        Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"Maps.newHashMap(treeStats.line_count)");
        this.lineHits = hashMap;
    }
}

