/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.view.ui.DatabaseScriptDialog;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.sql.psi.SqlElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ToolActions {
    @NotNull
    public static JBIterable<PsiElement> getSelectedElements(@NotNull DataContext dataContext) {
        PsiElement element2;
        if (dataContext == null) {
            ToolActions.$$$reportNull$$$0(0);
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        PsiReference ref = editor == null || file == null ? null : file.findReferenceAt(editor.getCaretModel().getOffset());
        PsiElement psiElement = element2 = ref != null && ref.getElement() instanceof SqlElement ? ref.resolve() : null;
        if (element2 != null) {
            JBIterable jBIterable = JBIterable.of((Object)element2);
            if (jBIterable == null) {
                ToolActions.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.of((Object[])((Object[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext)));
        if (jBIterable == null) {
            ToolActions.$$$reportNull$$$0(2);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/ToolActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/ToolActions";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedElements";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class RefreshMatViewAction
    extends ScriptingActionBase {
        public RefreshMatViewAction() {
            super("Refresh Materialized View", "_Refresh Materialized View", "Refresh selected materialized views", AllIcons.Actions.ForceRefresh);
        }

        @Override
        @NotNull
        protected ScriptCategory getCategory() {
            ScriptCategory scriptCategory = ScriptCategory.REFRESH;
            if (scriptCategory == null) {
                RefreshMatViewAction.$$$reportNull$$$0(0);
            }
            return scriptCategory;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ToolActions$RefreshMatViewAction", "getCategory"));
        }
    }

    public static class TruncateTablesAction
    extends ScriptingActionBase {
        public TruncateTablesAction() {
            super("Truncate Table", "_Truncate", "Truncate selected tables", AllIcons.Actions.GC);
        }

        @Override
        @NotNull
        protected ScriptCategory getCategory() {
            ScriptCategory scriptCategory = ScriptCategory.TRUNCATE;
            if (scriptCategory == null) {
                TruncateTablesAction.$$$reportNull$$$0(0);
            }
            return scriptCategory;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ToolActions$TruncateTablesAction", "getCategory"));
        }
    }

    public static abstract class ScriptingActionBase
    extends DumbAwareAction {
        private final String myTitle;

        public ScriptingActionBase(@NotNull String title, @Nullable String text2, @Nullable String description, @Nullable Icon icon) {
            if (title == null) {
                ScriptingActionBase.$$$reportNull$$$0(0);
            }
            super(text2, description, icon);
            this.myTitle = title;
        }

        public void update(@NotNull AnActionEvent e) {
            JBIterable<DbElement> objects2;
            DbElement selected;
            if (e == null) {
                ScriptingActionBase.$$$reportNull$$$0(1);
            }
            boolean visible = (selected = (DbElement)(objects2 = this.getObjects(e)).first()) != null && DbImplUtil.canConnectTo(selected);
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && DbImplUtil.canModify(selected));
        }

        protected boolean isSupported(@NotNull ScriptGenerator service, @Nullable BasicElement e) {
            if (service == null) {
                ScriptingActionBase.$$$reportNull$$$0(2);
            }
            if (e == null) {
                return false;
            }
            return service.capabilities(e).get(this.getCategory()).get(null);
        }

        @NotNull
        protected abstract ScriptCategory getCategory();

        @NotNull
        protected JBIterable<DbElement> getObjects(@NotNull AnActionEvent e) {
            BasicModel model;
            JBIterable res2;
            DbElement first2;
            if (e == null) {
                ScriptingActionBase.$$$reportNull$$$0(3);
            }
            if ((first2 = (DbElement)(res2 = ToolActions.getSelectedElements(e.getDataContext()).filter(DbElement.class)).first()) == null) {
                JBIterable jBIterable = JBIterable.empty();
                if (jBIterable == null) {
                    ScriptingActionBase.$$$reportNull$$$0(4);
                }
                return jBIterable;
            }
            DbDataSource dataSource = first2.getDataSource();
            BasicElement fe = (BasicElement)ObjectUtils.tryCast((Object)first2.getDelegate(), BasicElement.class);
            BasicModel basicModel = model = fe == null ? null : fe.getModel();
            if (model == null || !this.getCategory().getApplicableDbs().value((Object)model.getDbms())) {
                JBIterable jBIterable = JBIterable.empty();
                if (jBIterable == null) {
                    ScriptingActionBase.$$$reportNull$$$0(5);
                }
                return jBIterable;
            }
            ScriptGenerator service = ScriptGenerators.INSTANCE.byModel(model);
            JBIterable dsElements = res2.filter(o -> o.getDataSource() == dataSource).map(DbElement::getDelegate).filter(BasicElement.class);
            JBIterable jBIterable = ((JBTreeTraverser)((JBTreeTraverser)((JBTreeTraverser)JBTreeTraverser.from(BasicElement::getChildren).withRoots((Iterable)dsElements)).expandAndSkip(o -> !this.isSupported(service, (BasicElement)o))).unique()).bfsTraversal().map(o -> DbImplUtil.findElement(dataSource, o));
            if (jBIterable == null) {
                ScriptingActionBase.$$$reportNull$$$0(6);
            }
            return jBIterable;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            JBIterable<DbElement> selection;
            DbElement first2;
            if (e == null) {
                ScriptingActionBase.$$$reportNull$$$0(7);
            }
            if ((first2 = (DbElement)(selection = this.getObjects(e)).first()) == null) {
                return;
            }
            DbDataSource dataSource = first2.getDataSource();
            BasicModel model = (BasicModel)ObjectUtils.tryCast((Object)dataSource.getModel(), BasicModel.class);
            if (model == null) {
                return;
            }
            final ScriptGenerator service = ScriptGenerators.INSTANCE.byModel(model);
            BasicNamespace namespace = (BasicNamespace)ObjectUtils.tryCast((Object)DbImplUtil.unwrap((DasObject)DbImplUtil.getSearchPathObjectForSwitch(first2)), BasicNamespace.class);
            final ScriptingSingleModelTaskBuilder builder = new ScriptingSingleModelTaskBuilder(model, this.getCategory());
            builder.setCurrentNamespace(namespace);
            selection.filterMap(o -> (BasicElement)ObjectUtils.tryCast((Object)DbImplUtil.unwrap((DasObject)o), BasicElement.class)).addAllTo(builder.getElements());
            final Project project = first2.getProject();
            new DatabaseScriptDialog(dataSource.getProject(), dataSource, ObjectPaths.searchPathOf(namespace), this.myTitle){

                protected void init() {
                    super.init();
                    this.generate();
                }

                @Override
                protected ScriptingTask getTask() {
                    return builder.build();
                }

                @Override
                protected void settingsChanged(ScriptingOptions options) {
                    builder.setOptions(options);
                    this.generate();
                }

                private void generate() {
                    this.updateText(service.makeScript(project, this.getTask()));
                }
            }.initAndShow();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 1: 
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "service";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/ToolActions$ScriptingActionBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/ToolActions$ScriptingActionBase";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getObjects";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isSupported";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getObjects";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

