/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.database.cli.CliArgumentGroup;
import com.intellij.database.cli.CliConfiguration;
import com.intellij.database.cli.CliConfigurationBase;
import com.intellij.database.cli.argument.CliArgument;
import com.intellij.database.cli.argument.CommonMysqlArguments;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.NetUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class MysqlConfigurationBase
extends CliConfigurationBase {
    protected MysqlConfigurationBase(@NotNull CliArgumentGroup<? extends CliArgument>[] group2, @NotNull String[] fileArgs, @NotNull String propertyKey, @NotNull String name2) {
        if (propertyKey == null) {
            MysqlConfigurationBase.$$$reportNull$$$0(0);
        }
        if (name2 == null) {
            MysqlConfigurationBase.$$$reportNull$$$0(1);
        }
        if (group2 == null) {
            MysqlConfigurationBase.$$$reportNull$$$0(2);
        }
        if (fileArgs == null) {
            MysqlConfigurationBase.$$$reportNull$$$0(3);
        }
        super(group2, CommonMysqlArguments.HOST, CommonMysqlArguments.PORT, CommonMysqlArguments.USER, CommonMysqlArguments.PASSWORD_PARAMETERIZABLE, fileArgs, CommonMysqlArguments.SSL_CA, CommonMysqlArguments.SSL_CERT, CommonMysqlArguments.SSL_KEY, "MYSQL_PWD", propertyKey, name2);
    }

    @Override
    @NotNull
    public List<String> tweakAutocompletion(@NotNull List<String> variants) {
        if (variants == null) {
            MysqlConfigurationBase.$$$reportNull$$$0(4);
        }
        ArrayList<String> result2 = new ArrayList<String>(variants);
        ContainerUtil.removeAll(result2, (Object[])CommonMysqlArguments.PASSWORD);
        ContainerUtil.addAll(result2, (Object[])CommonMysqlArguments.PASSWORD_PARAMETERIZABLE);
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            MysqlConfigurationBase.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public String getCommand(@NotNull String command, @NotNull CliConfiguration.Parameters parameters) {
        if (command == null) {
            MysqlConfigurationBase.$$$reportNull$$$0(6);
        }
        if (parameters == null) {
            MysqlConfigurationBase.$$$reportNull$$$0(7);
        }
        String string = super.getCommand(command, MysqlConfigurationBase.modifyHost(parameters));
        if (string == null) {
            MysqlConfigurationBase.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private static CliConfiguration.Parameters modifyHost(@NotNull CliConfiguration.Parameters parameters) {
        if (parameters == null) {
            MysqlConfigurationBase.$$$reportNull$$$0(9);
        }
        CliConfiguration.Parameters parameters2 = parameters.host != null && NetUtils.isLocalhost((String)parameters.host) ? parameters.withHost("127.0.0.1") : parameters;
        if (parameters2 == null) {
            MysqlConfigurationBase.$$$reportNull$$$0(10);
        }
        return parameters2;
    }

    @Override
    @NotNull
    public List<String> getParameterizableArguments() {
        List<String> list = Arrays.asList("-p", "-P", "-u", "-h");
        if (list == null) {
            MysqlConfigurationBase.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Override
    @NotNull
    public Map<String, String> getInfoMap() {
        HashMap<String, String> map2 = new HashMap<String, String>();
        MysqlConfigurationBase.put(map2, "Buffer size network communication", CommonMysqlArguments.NET_BUFFER_LENGTH);
        MysqlConfigurationBase.put(map2, "Max packet length", CommonMysqlArguments.MAX_ALLOWED_PACKET);
        MysqlConfigurationBase.put(map2, "Verbose mode", CommonMysqlArguments.VERBOSE);
        MysqlConfigurationBase.put(map2, "Print version", CommonMysqlArguments.VERSION);
        MysqlConfigurationBase.put(map2, "TLS version to use", CommonMysqlArguments.TLS_VERSION);
        MysqlConfigurationBase.put(map2, "The password to use when connecting to the server", CommonMysqlArguments.PASSWORD_PARAMETERIZABLE);
        MysqlConfigurationBase.put(map2, "Display a help message and exit", CommonMysqlArguments.HELP);
        MysqlConfigurationBase.put(map2, "Interface for connecting to MySQL server", CommonMysqlArguments.BIND_ADDRESS);
        MysqlConfigurationBase.put(map2, "Write host information, program and server version", CommonMysqlArguments.COMMENTS);
        MysqlConfigurationBase.put(map2, "Compress client-server communication", CommonMysqlArguments.COMPRESS);
        MysqlConfigurationBase.put(map2, "User name", CommonMysqlArguments.USER);
        MysqlConfigurationBase.put(map2, "TCP port", CommonMysqlArguments.PORT);
        MysqlConfigurationBase.put(map2, "Host name", CommonMysqlArguments.HOST);
        MysqlConfigurationBase.put(map2, "Write a debugging log", CommonMysqlArguments.DEBUG);
        MysqlConfigurationBase.put(map2, "Debug information on exit", "--debug-check");
        MysqlConfigurationBase.put(map2, "Debug information and resources usage statistics", "--debug-info");
        MysqlConfigurationBase.put(map2, "Hint about client-side authentication plugin", CommonMysqlArguments.DEFAULT_AUTH);
        MysqlConfigurationBase.put(map2, "Use only the given option file", CommonMysqlArguments.DEFAULTS_FILE);
        MysqlConfigurationBase.put(map2, "Read not only the usual option groups", CommonMysqlArguments.DEFAULTS_GROUP_SUFFIX);
        MysqlConfigurationBase.put(map2, "Continue even if an SQL error occurs", CommonMysqlArguments.FORCE);
        MysqlConfigurationBase.put(map2, "Enable cleartext authentication plugin", "--enable-cleartext-plugin");
        MysqlConfigurationBase.put(map2, "Do not read any option files", "--no-defaults");
        MysqlConfigurationBase.put(map2, "Plugins directory", CommonMysqlArguments.PLUGIN_DIR);
        MysqlConfigurationBase.put(map2, "Print program name and options from option files", "--print-defaults");
        MysqlConfigurationBase.put(map2, "Connection protocol to use", CommonMysqlArguments.PROTOCOL);
        MysqlConfigurationBase.put(map2, "For dumping large tables", CommonMysqlArguments.QUICK);
        MysqlConfigurationBase.put(map2, "Refuse connecting if server uses old protocol", "--secure-auth");
        MysqlConfigurationBase.put(map2, "Unix - socket file, Windows - name of the pipe", CommonMysqlArguments.SOCKET);
        MysqlConfigurationBase.put(map2, "Disable --quick", CommonMysqlArguments.SKIP_QUICK);
        MysqlConfigurationBase.put(map2, "Disable --secure-auth", CommonMysqlArguments.SKIP_SECURE_AUTH);
        MysqlConfigurationBase.put(map2, "Write dump output as XML", CommonMysqlArguments.XML);
        MysqlConfigurationBase.put(map2, "Enable secure connection", CommonMysqlArguments.SSL);
        MysqlConfigurationBase.put(map2, "Path X509 key", CommonMysqlArguments.SSL_KEY);
        MysqlConfigurationBase.put(map2, "Security state of connection", CommonMysqlArguments.SSL_MODE);
        MysqlConfigurationBase.put(map2, "Do not use secure connection", CommonMysqlArguments.SKIP_SSL);
        MysqlConfigurationBase.put(map2, "Path list of SSL CAs", CommonMysqlArguments.SSL_CA);
        MysqlConfigurationBase.put(map2, "Directory with SSL CA certificates", CommonMysqlArguments.SSL_CA_PATH);
        MysqlConfigurationBase.put(map2, "Path of X509 certificate", CommonMysqlArguments.SSL_CERT);
        MysqlConfigurationBase.put(map2, "Permitted ciphers for encryption", CommonMysqlArguments.SSL_CIPHER);
        MysqlConfigurationBase.put(map2, "Verify server certificate", CommonMysqlArguments.SSL_VERIFY_SERVER_CERT);
        MysqlConfigurationBase.put(map2, "Certificate revocation list", CommonMysqlArguments.SSL_CRL);
        MysqlConfigurationBase.put(map2, "Certificate revocation list path", CommonMysqlArguments.SSL_CRL_PATH);
        HashMap<String, String> hashMap = map2;
        if (hashMap == null) {
            MysqlConfigurationBase.$$$reportNull$$$0(12);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyKey";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileArgs";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variants";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/cli/MysqlConfigurationBase";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/cli/MysqlConfigurationBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "tweakAutocompletion";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "modifyHost";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterizableArguments";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfoMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "tweakAutocompletion";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCommand";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "modifyHost";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

