/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.console.AutoDisconnectActionDescriptor;
import com.intellij.database.console.ConnectionTimer;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.console.KeepAliveActionDescriptor;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTrackerListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EngineConnectionWatcher {
    private final ConnectionTimer myKeepAliveTimer;
    private final ConnectionTimer myAutoDisconnectTimer;

    public EngineConnectionWatcher(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull JdbcEngine engine) {
        if (project == null) {
            EngineConnectionWatcher.$$$reportNull$$$0(0);
        }
        if (dataSource == null) {
            EngineConnectionWatcher.$$$reportNull$$$0(1);
        }
        if (engine == null) {
            EngineConnectionWatcher.$$$reportNull$$$0(2);
        }
        MyConnectionHolder holder = new MyConnectionHolder(engine);
        this.myKeepAliveTimer = new ConnectionTimer(project, dataSource, holder, new KeepAliveActionDescriptor(), engine);
        this.myAutoDisconnectTimer = new ConnectionTimer(project, dataSource, holder, new AutoDisconnectActionDescriptor(), engine);
        DbPsiFacade.getInstance((Project)project).addModificationTrackerListener((ModificationTrackerListener)new MyModificationTracker(dataSource), (Disposable)engine);
    }

    public void restart() {
        this.myKeepAliveTimer.launch();
        this.myAutoDisconnectTimer.launch();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "engine";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/console/EngineConnectionWatcher";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyModificationTracker
    implements ModificationTrackerListener<DbPsiFacade> {
        private final LocalDataSource myDataSource;
        private boolean myKeepAlive;
        private boolean myAutoClose;
        private int myAutoCloseTimeout;
        private int myKeepAliveTimeout;

        MyModificationTracker(LocalDataSource dataSource) {
            if (dataSource == null) {
                MyModificationTracker.$$$reportNull$$$0(0);
            }
            this.myKeepAlive = dataSource.isKeepAlive();
            this.myAutoClose = dataSource.isAutoClose();
            this.myAutoCloseTimeout = dataSource.getAutoCloseTimeout();
            this.myKeepAliveTimeout = dataSource.getKeepAliveTimeout();
            this.myDataSource = dataSource;
        }

        public void modificationCountChanged(@NotNull DbPsiFacade source) {
            if (source == null) {
                MyModificationTracker.$$$reportNull$$$0(1);
            }
            if (this.myKeepAlive != this.myDataSource.isKeepAlive() || this.myKeepAliveTimeout != this.myDataSource.getKeepAliveTimeout()) {
                this.myKeepAlive = this.myDataSource.isKeepAlive();
                this.myKeepAliveTimeout = this.myDataSource.getKeepAliveTimeout();
                if (this.myKeepAlive) {
                    EngineConnectionWatcher.this.myKeepAliveTimer.relaunch();
                }
            }
            if (this.myAutoClose != this.myDataSource.isAutoClose() || this.myAutoCloseTimeout != this.myDataSource.getAutoCloseTimeout()) {
                this.myAutoClose = this.myDataSource.isAutoClose();
                this.myAutoCloseTimeout = this.myDataSource.getAutoCloseTimeout();
                if (this.myAutoClose) {
                    EngineConnectionWatcher.this.myAutoDisconnectTimer.relaunch();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/EngineConnectionWatcher$MyModificationTracker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modificationCountChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyConnectionHolder
    implements ConnectionTimer.ConnectionHolder {
        private static final Logger LOG = Logger.getInstance(EngineConnectionWatcher.class);
        private final JdbcEngine myEngine;

        MyConnectionHolder(@NotNull JdbcEngine engine) {
            if (engine == null) {
                MyConnectionHolder.$$$reportNull$$$0(0);
            }
            this.myEngine = engine;
        }

        @Override
        public void runAsync(@NotNull Runnable runnable) {
            if (runnable == null) {
                MyConnectionHolder.$$$reportNull$$$0(1);
            }
            this.myEngine.submitRunnable(() -> {
                try {
                    runnable.run();
                }
                catch (Throwable t) {
                    LOG.error(t);
                }
            });
        }

        @Override
        public boolean close() {
            if (!this.myEngine.getTxMarker().isTransactionInProgress()) {
                this.myEngine.releaseConnection();
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public DatabaseConnection getConnection() {
            return this.myEngine.getConnectionIfValid();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "engine";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/EngineConnectionWatcher$MyConnectionHolder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runAsync";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

