/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.console.JdbcConsoleRunContext;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.console.RemoteConsoleProcessSupport;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.DatabaseSshTunnelEstablisher;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.util.DbImplUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ssh.SshSession;
import com.intellij.ssh.SshTransportException;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdbcDriverManagerImpl
extends JdbcDriverManager {
    private final EventDispatcher<ModificationTrackerListener<JdbcDriverManager>> myDispatcher = DataSourceUiUtil.eventDispatcher(ModificationTrackerListener.class);
    private final RemoteConsoleProcessSupport<LocalDataSource, Driver> mySupport;
    private final Project myProject;
    private final Map<LocalDataSource, Pair<SshSession, Integer>> myTunnelMap = ContainerUtil.newConcurrentMap();

    public JdbcDriverManagerImpl(Project project) {
        DbPsiFacade facade = DbPsiFacade.getInstance((Project)project);
        this.myProject = project;
        this.mySupport = new RemoteConsoleProcessSupport<LocalDataSource, Driver>(Driver.class){

            protected void fireModificationCountChanged() {
                JdbcDriverManagerImpl.this.incModificationCount();
                ApplicationManager.getApplication().invokeLater(() -> ((ModificationTrackerListener)JdbcDriverManagerImpl.this.myDispatcher.getMulticaster()).modificationCountChanged((Object)JdbcDriverManagerImpl.this));
            }

            @Override
            protected ConsoleRunConfiguration.RunContext createRunContext(@NotNull LocalDataSource target2) {
                if (target2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return new JdbcConsoleRunContext(target2);
            }

            protected String getName(@NotNull LocalDataSource dataSource) {
                if (dataSource == null) {
                    1.$$$reportNull$$$0(1);
                }
                return dataSource.getName();
            }

            protected void logText(@NotNull ConsoleRunConfiguration configuration, @NotNull ProcessEvent event, @NotNull Key outputType) {
                if (configuration == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (event == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(4);
                }
                String text2 = StringUtil.notNullize((String)event.getText());
                if (outputType == ProcessOutputTypes.STDERR) {
                    LOG.warn(text2.trim());
                } else {
                    LOG.info(text2.trim());
                }
            }

            @Override
            protected RunProfileState getRunProfileState(@NotNull LocalDataSource target2, @NotNull ConsoleRunConfiguration configuration, @NotNull Executor executor) throws ExecutionException {
                if (target2 == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (configuration == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (executor == null) {
                    1.$$$reportNull$$$0(7);
                }
                RunProfileState result2 = super.getRunProfileState(target2, configuration, executor);
                JdbcDriverManagerImpl.this.createTunnel(target2, configuration.CREDENTIALS);
                return result2;
            }

            public void stopAll(boolean waitFor) {
                super.stopAll(waitFor);
                List sessions = ContainerUtil.map(new ArrayList(JdbcDriverManagerImpl.this.myTunnelMap.values()), (Function)Functions.pairFirst());
                JdbcDriverManagerImpl.this.myTunnelMap.clear();
                for (SshSession session2 : sessions) {
                    JdbcDriverManagerImpl.destroyTunnelImpl(session2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "target";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataSource";
                        break;
                    }
                    case 2: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "configuration";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "executor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/console/JdbcDriverManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "createRunContext";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getName";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "logText";
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getRunProfileState";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        facade.addModificationTrackerListener((ModificationTrackerListener)new ModificationTrackerListener<DbPsiFacade>(){

            public void modificationCountChanged(@NotNull DbPsiFacade source) {
                if (source == null) {
                    2.$$$reportNull$$$0(0);
                }
                for (Pair pair : JdbcDriverManagerImpl.this.mySupport.getActiveConfigurations()) {
                    DbDataSource dataSource = source.findDataSource(((LocalDataSource)pair.first).getUniqueId());
                    if (DbImplUtil.getMaybeLocalDataSource((DasDataSource)dataSource) == pair.first) continue;
                    JdbcDriverManagerImpl.this.releaseDriver((LocalDataSource)pair.first, null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/console/JdbcDriverManagerImpl$2", "modificationCountChanged"));
            }
        }, (Disposable)this.myProject);
        Disposer.register((Disposable)this.myProject, this.mySupport);
    }

    @Override
    public ModificationTracker getModificationTracker() {
        return this;
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }

    @Override
    @NotNull
    public ConsoleRunConfiguration getDefaultRunConfiguration(@NotNull LocalDataSource dataSource, @Nullable DatabaseCredentials credentialsStore) {
        if (dataSource == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(0);
        }
        ConsoleRunConfiguration consoleRunConfiguration = JdbcDriverManagerImpl.chooseRunConfiguration(this.myProject, dataSource, credentialsStore);
        if (consoleRunConfiguration == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(1);
        }
        return consoleRunConfiguration;
    }

    @Override
    public List<ConsoleRunConfiguration> getActiveConfigurations(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(2);
        }
        return this.mySupport.getActiveConfigurations(dataSource);
    }

    @Override
    public Driver getDriver(@NotNull LocalDataSource dataSource, @NotNull ConsoleRunConfiguration configuration) throws Exception {
        if (dataSource == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(3);
        }
        if (configuration == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(4);
        }
        return (Driver)this.mySupport.acquire(dataSource, (Object)configuration);
    }

    @Override
    @NotNull
    public Future<?> releaseDriver(@NotNull LocalDataSource dataSource, @Nullable ConsoleRunConfiguration configuration) {
        if (dataSource == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(5);
        }
        Future future = ApplicationManager.getApplication().executeOnPooledThread(() -> {
            JdbcDriverManagerImpl.terminateConnections(dataSource, configuration);
            try {
                this.mySupport.release(dataSource, (Object)configuration).get();
            }
            catch (Exception exception) {
                // empty catch block
            }
            (configuration == null ? DatabaseCredentials.getInstance() : configuration.CREDENTIALS).handleSessionFinished(dataSource);
            if (this.getActiveConfigurations(dataSource).isEmpty()) {
                this.destroyTunnel(dataSource);
            }
        });
        if (future == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(6);
        }
        return future;
    }

    @Override
    public void addModificationTrackerListener(ModificationTrackerListener<JdbcDriverManager> listener, Disposable disposable) {
        this.myDispatcher.addListener(listener, disposable);
    }

    @Override
    @Nullable
    public Integer getLocalPort(@NotNull LocalDataSource source) {
        if (source == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(7);
        }
        Pair<SshSession, Integer> pair = this.myTunnelMap.get(source);
        return (Integer)Pair.getSecond(pair);
    }

    private static ConsoleRunConfiguration chooseRunConfiguration(Project project, LocalDataSource dataSource, DatabaseCredentials credentialsStore) {
        List<ConsoleRunConfiguration> active;
        boolean isTemporary;
        JdbcDriverManager driverManager = JdbcDriverManagerImpl.getDriverManager(project);
        boolean bl = isTemporary = credentialsStore != null && credentialsStore != DatabaseCredentials.getInstance();
        if (!isTemporary && !(active = driverManager.getActiveConfigurations(dataSource)).isEmpty()) {
            return active.get(0);
        }
        ConsoleRunConfiguration configuration = ConsoleRunConfiguration.newConfiguration(project);
        configuration.setOptionsFromDataSource(dataSource);
        if (credentialsStore != null) {
            configuration.CREDENTIALS = credentialsStore;
        }
        return configuration;
    }

    private void createTunnel(@NotNull LocalDataSource dataSource, @NotNull DatabaseCredentials credentialsStore) throws ExecutionException {
        if (dataSource == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(8);
        }
        if (credentialsStore == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(9);
        }
        try {
            Pair<SshSession, Integer> pair = DatabaseSshTunnelEstablisher.createTunnelSync(this.myProject, dataSource, credentialsStore);
            ContainerUtil.putIfNotNull((Object)dataSource, pair, this.myTunnelMap);
        }
        catch (SshTransportException e) {
            throw new ExecutionException("SSH: " + e.getMessage(), (Throwable)e);
        }
        catch (UnsupportedOperationException e) {
            throw new ExecutionException("SSH: " + e.getMessage(), (Throwable)e);
        }
    }

    private static void terminateConnections(@NotNull LocalDataSource dataSource, @Nullable ConsoleRunConfiguration configuration) {
        if (dataSource == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(10);
        }
        try {
            DatabaseConnectionManager.getInstance().terminateConnections(dataSource, configuration);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void destroyTunnel(LocalDataSource dataSource) {
        Pair<SshSession, Integer> pair = this.myTunnelMap.remove(dataSource);
        if (pair == null) {
            return;
        }
        JdbcDriverManagerImpl.destroyTunnelImpl((SshSession)pair.first);
    }

    private static void destroyTunnelImpl(SshSession session2) {
        if (session2 == null) {
            return;
        }
        try {
            session2.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/JdbcDriverManagerImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentialsStore";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/JdbcDriverManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultRunConfiguration";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "releaseDriver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultRunConfiguration";
                break;
            }
            case 1: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getActiveConfigurations";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDriver";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "releaseDriver";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLocalPort";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createTunnel";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "terminateConnections";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

