/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.OperandType;
import com.intellij.database.data.types.PredicatesHelper;
import com.intellij.database.data.types.PredicatesUtilKt;
import com.intellij.database.data.types.PredicatesUtilKt$WhenMappings;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.EqualsOperation;
import com.intellij.database.data.types.domain.LikeOpType;
import com.intellij.database.data.types.domain.Operation;
import com.intellij.database.data.types.domain.OperationKt;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DataType;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.TypeNameColumnDescriptor;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import java.text.ParsePosition;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang.math.NumberUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a6\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u00062\b\u0010\t\u001a\u0004\u0018\u00010\u0006H\u0002\u001a4\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u001a<\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u001a\u001e\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013\u001a0\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f\u001a\u001e\u0010!\u001a\u00020\u001d2\u0016\u0010\"\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u000f0#\u001a(\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020&2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u001a\u000e\u0010'\u001a\u00020(2\u0006\u0010\f\u001a\u00020\r\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"formatter", "Lcom/intellij/database/extractors/ObjectFormatter;", "composeWhereItem", "Lcom/intellij/database/util/DdlBuilder;", "builder", "columnName", "", "literal", "likeWord", "alias", "defaultEqualsPredicate", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "column", "Lcom/intellij/database/model/DasColumn;", "value", "", "type", "Lcom/intellij/database/data/types/OperandType;", "dbms", "Lcom/intellij/database/Dbms;", "version", "Lcom/intellij/database/util/Version;", "defaultLikePredicate", "likeType", "Lcom/intellij/database/data/types/domain/LikeOpType;", "matchCase", "", "equalsPredicate", "getRequiredFormat", "Lcom/intellij/database/run/ui/grid/editors/Formatter;", "types", "", "Lcom/intellij/database/data/types/LogicalType;", "parseOnlyFormatter", "parse", "Lkotlin/Function1;", "supportsOperation", "operation", "Lcom/intellij/database/data/types/domain/Operation;", "toGridColumn", "Lcom/intellij/database/datagrid/DataConsumer$Column;", "intellij.database.impl"})
public final class PredicatesUtilKt {
    private static final ObjectFormatter formatter = new ObjectFormatter();

    @Nullable
    public static final PredicatesHelper.PredicateProducer defaultEqualsPredicate(@NotNull DasColumn column2, @Nullable Object value, @NotNull OperandType type, @NotNull Dbms dbms, @Nullable Version version) {
        String string;
        EqualsOperation equalsOperation;
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        switch (PredicatesUtilKt$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: 
            case 2: {
                equalsOperation = OperationKt.EQUALS_TO_STRING_OPERATION;
                break;
            }
            case 3: {
                equalsOperation = OperationKt.EQUALS_TO_NUMBER_OPERATION;
                break;
            }
            case 4: {
                return null;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        EqualsOperation operation2 = equalsOperation;
        if (!PredicatesUtilKt.supportsOperation(operation2, column2, dbms, version)) {
            return null;
        }
        Object object = value;
        if (object != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object v2 = object2;
            boolean bl3 = false;
            String str = v2.toString();
            switch (PredicatesUtilKt$WhenMappings.$EnumSwitchMapping$1[operation2.getRightOperandType().ordinal()]) {
                case 1: {
                    if (!NumberUtils.isNumber((String)str)) {
                        return null;
                    }
                    string = str;
                    break;
                }
                case 2: {
                    String string2 = DbImplUtil.StringLiteralDecorator.PLAIN.decorate(str, dbms);
                    string = string2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"PLAIN.decorate(str, dbms)");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        } else {
            string = null;
        }
        String literalValue = string;
        return new PredicatesHelper.PredicateProducer(column2, literalValue){
            final /* synthetic */ DasColumn $column;
            final /* synthetic */ String $literalValue;

            public final void produce(@NotNull DdlBuilder builder) {
                Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
                String string = this.$column.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"column.name");
                PredicatesUtilKt.access$composeWhereItem(builder, string, this.$literalValue, null, null);
            }
            {
                this.$column = dasColumn;
                this.$literalValue = string;
            }
        };
    }

    private static final DdlBuilder composeWhereItem(DdlBuilder builder, String columnName, String literal, String likeWord, String alias) {
        if (alias != null) {
            builder.alias(alias).symbol(".");
        }
        builder.identifier(columnName).space();
        if (literal == null) {
            builder.keywords("IS", "NULL");
        } else {
            if (likeWord != null) {
                builder.keyword(likeWord);
            } else {
                builder.symbol("=");
            }
            builder.space().literal(literal);
        }
        return builder;
    }

    @Nullable
    public static final PredicatesHelper.PredicateProducer defaultLikePredicate(@NotNull DasColumn column2, @Nullable Object value, @NotNull LikeOpType likeType, boolean matchCase, @NotNull Dbms dbms, @Nullable Version version) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        Intrinsics.checkParameterIsNotNull((Object)((Object)likeType), (String)"likeType");
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        if (!PredicatesUtilKt.supportsOperation(OperationKt.LIKE_OPERATION, column2, dbms, version)) {
            return null;
        }
        if (value != null && !(value instanceof String)) {
            return null;
        }
        boolean supportsLike = DbImplUtil.getDatabaseDialect(dbms).getLikeSupport(version).isSupported(false);
        if (!matchCase && supportsLike && DbImplUtil.getJdbcHelper(dbms).supportsIlike()) {
            string = "ILIKE";
        } else if (supportsLike) {
            string = "LIKE";
        } else {
            return null;
        }
        String likeWord = string;
        DbImplUtil.StringLiteralDecorator decorator = likeType.getDecorator();
        return new PredicatesHelper.PredicateProducer(value, decorator, dbms, column2, likeWord){
            final /* synthetic */ Object $value;
            final /* synthetic */ DbImplUtil.StringLiteralDecorator $decorator;
            final /* synthetic */ Dbms $dbms;
            final /* synthetic */ DasColumn $column;
            final /* synthetic */ String $likeWord;

            public final void produce(@NotNull DdlBuilder builder) {
                String string;
                Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
                Object object = this.$value;
                if (!(object instanceof String)) {
                    object = null;
                }
                String string2 = (String)object;
                if (string2 != null) {
                    String string3 = string2;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it2 = string3;
                    boolean bl3 = false;
                    string = this.$decorator.decorate(it2, this.$dbms);
                } else {
                    string = null;
                }
                String literal = string;
                String string4 = this.$column.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"column.name");
                PredicatesUtilKt.access$composeWhereItem(builder, string4, literal, this.$likeWord, null);
            }
            {
                this.$value = object;
                this.$decorator = stringLiteralDecorator;
                this.$dbms = dbms;
                this.$column = dasColumn;
                this.$likeWord = string;
            }
        };
    }

    public static final boolean supportsOperation(@NotNull Operation operation2, @NotNull DasColumn column2, @NotNull Dbms dbms, @Nullable Version version) {
        Intrinsics.checkParameterIsNotNull((Object)operation2, (String)"operation");
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        if ((Intrinsics.areEqual((Object)operation2, (Object)OperationKt.LIKE_OPERATION) || Intrinsics.areEqual((Object)operation2, (Object)OperationKt.EQUALS_TO_STRING_OPERATION)) && dbms.isDerby() && StringUtil.equalsIgnoreCase((CharSequence)column2.getDataType().suffix, (CharSequence)"FOR BIT DATA")) {
            return false;
        }
        DomainRegistry domainRegistry = DomainRegistry.get(dbms, version);
        if (domainRegistry == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)domainRegistry, (String)"DomainRegistry.get(dbms, version) ?: return false");
        DomainRegistry registry = domainRegistry;
        Domain domain = registry.getDomain(new TypeNameColumnDescriptor(column2.getDataType().typeName));
        return domain != null && domain.supportsOperation(operation2);
    }

    @NotNull
    public static final PredicatesHelper.PredicateProducer equalsPredicate(@NotNull DasColumn column2, @NotNull String value, @NotNull Dbms dbms) {
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        return new PredicatesHelper.PredicateProducer(column2, value, dbms){
            final /* synthetic */ DasColumn $column;
            final /* synthetic */ String $value;
            final /* synthetic */ Dbms $dbms;

            public final void produce(@NotNull DdlBuilder builder) {
                Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
                builder.identifier((DasObject)this.$column).space().symbol("=").space().plain(DbImplUtil.StringLiteralDecorator.MATCHES.decorate(this.$value, this.$dbms));
            }
            {
                this.$column = dasColumn;
                this.$value = string;
                this.$dbms = dbms;
            }
        };
    }

    @NotNull
    public static final DataConsumer.Column toGridColumn(@NotNull DasColumn column2) {
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        short s = column2.getPosition();
        String string = column2.getName();
        String string2 = column2.getDataType().typeName;
        DataType dataType = column2.getDataType();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"column.dataType");
        return new DataConsumer.Column(s, string, -1, string2, "", dataType.getPrecision(), column2.getDataType().scale, null, null, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final Formatter getRequiredFormat(@NotNull DasColumn column2, @NotNull Dbms dbms, @Nullable Version version, @NotNull Set<? extends LogicalType> types) {
        DomainRegistry registry;
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        Intrinsics.checkParameterIsNotNull(types, (String)"types");
        DomainRegistry domainRegistry = registry = DomainRegistry.get(dbms, version);
        Domain domain = domainRegistry != null ? domainRegistry.getDomain(new TypeNameColumnDescriptor(column2.getDataType().typeName)) : null;
        DataConsumer.Column col = PredicatesUtilKt.toGridColumn(column2);
        Domain domain2 = domain;
        if (!CollectionsKt.contains((Iterable)types, (Object)((Object)(domain2 != null ? domain2.getLogicType() : null)))) {
            return null;
        }
        Domain domain3 = domain;
        if (domain3 == null) return null;
        LogicalType logicalType = domain3.getLogicType();
        if (logicalType == null) return null;
        switch (PredicatesUtilKt$WhenMappings.$EnumSwitchMapping$2[logicalType.ordinal()]) {
            case 1: {
                Formatter formatter = PredicatesUtilKt.formatter.getZonedTimeFormat(col, dbms);
                return formatter;
            }
            case 2: {
                Formatter formatter = PredicatesUtilKt.formatter.getZonedTimestampFormat(col, dbms);
                return formatter;
            }
            case 3: {
                Formatter formatter = PredicatesUtilKt.formatter.getTimestampFormat(col, dbms);
                return formatter;
            }
            case 4: {
                Formatter formatter = PredicatesUtilKt.formatter.getTimeFormat();
                return formatter;
            }
            case 5: {
                Formatter formatter = PredicatesUtilKt.formatter.getDateFormat(col, dbms);
                return formatter;
            }
            case 6: {
                Formatter formatter = PredicatesUtilKt.parseOnlyFormatter((Function1<? super String, ? extends Object>)((Function1)getRequiredFormat.1.INSTANCE));
                return formatter;
            }
            case 7: {
                Formatter formatter = PredicatesUtilKt.parseOnlyFormatter((Function1<? super String, ? extends Object>)((Function1)getRequiredFormat.2.INSTANCE));
                return formatter;
            }
            default: {
                return null;
            }
        }
    }

    @NotNull
    public static final Formatter parseOnlyFormatter(@NotNull Function1<? super String, ? extends Object> parse) {
        Intrinsics.checkParameterIsNotNull(parse, (String)"parse");
        return new Formatter(parse){
            final /* synthetic */ Function1 $parse;

            @Nullable
            public Object parse(@Nullable String value) {
                return this.$parse.invoke((Object)value);
            }

            @NotNull
            public Void parse(@Nullable String value, @Nullable ParsePosition position) {
                throw (Throwable)new UnsupportedOperationException();
            }

            @NotNull
            public Void format(@Nullable Object value) {
                throw (Throwable)new UnsupportedOperationException();
            }
            {
                this.$parse = $captured_local_variable$0;
            }
        };
    }

    public static final /* synthetic */ DdlBuilder access$composeWhereItem(DdlBuilder builder, String columnName, String literal, String likeWord, String alias) {
        return PredicatesUtilKt.composeWhereItem(builder, columnName, literal, likeWord, alias);
    }
}

