/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.domain;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.data.types.domain.Cardinality;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.NumberDomain;
import com.intellij.database.data.types.domain.OperationSupport;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import java.text.DecimalFormat;
import java.text.ParseException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Number2Domain
extends Domain {
    private final Cardinality.ScalableCardinality myCardinality;
    private final boolean myNarrowable;
    private final int myMaxPrecision;
    private final int myMaxScale;

    public Number2Domain(@NotNull String name2, @NotNull ConversionPoint descriptor, int maxPrecision, int maxScale, boolean narrowable) {
        if (name2 == null) {
            Number2Domain.$$$reportNull$$$0(0);
        }
        if (descriptor == null) {
            Number2Domain.$$$reportNull$$$0(1);
        }
        this(name2, descriptor, maxPrecision, maxScale, narrowable, OperationSupport.DEFAULT_OPERATION_SUPPORT);
    }

    public Number2Domain(@NotNull String name2, @NotNull ConversionPoint descriptor, int maxPrecision, int maxScale, boolean narrowable, @NotNull OperationSupport operationSupport) {
        if (name2 == null) {
            Number2Domain.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            Number2Domain.$$$reportNull$$$0(3);
        }
        if (operationSupport == null) {
            Number2Domain.$$$reportNull$$$0(4);
        }
        super(descriptor, PhysicalDomainType.NUMBER, name2, operationSupport);
        this.myMaxPrecision = maxPrecision;
        this.myMaxScale = maxScale;
        this.myCardinality = new Cardinality.ScalableCardinality(maxPrecision);
        this.myNarrowable = narrowable;
    }

    public boolean isNarrowable() {
        return this.myNarrowable;
    }

    public int getMaxPrecision() {
        return this.myMaxPrecision;
    }

    public int getMaxScale() {
        return this.myMaxScale;
    }

    @Override
    @NotNull
    public Compatibility getCompatibility(@NotNull Domain domain) {
        if (domain == null) {
            Number2Domain.$$$reportNull$$$0(5);
        }
        if (domain instanceof IntegerDomain && ((IntegerDomain)domain).getMaxValue() < Math.pow(10.0, this.getMaxPrecision())) {
            Compatibility compatibility = Compatibility.full(this.cardinality(), domain.getLogicType(), this.getLogicType());
            if (compatibility == null) {
                Number2Domain.$$$reportNull$$$0(6);
            }
            return compatibility;
        }
        if (!(domain instanceof NumberDomain) && !(domain instanceof Number2Domain)) {
            Compatibility compatibility = Compatibility.incompatible();
            if (compatibility == null) {
                Number2Domain.$$$reportNull$$$0(7);
            }
            return compatibility;
        }
        Compatibility compatibility = domain instanceof NumberDomain || !this.checkTwoParameter((Number2Domain)domain) ? Compatibility.compatibleLossy(this.cardinality(), domain.getLogicType(), this.getLogicType()) : Compatibility.full(this.cardinality(), domain.getLogicType(), this.getLogicType());
        if (compatibility == null) {
            Number2Domain.$$$reportNull$$$0(8);
        }
        return compatibility;
    }

    @Override
    @NotNull
    public Cardinality cardinality() {
        Cardinality.ScalableCardinality scalableCardinality = this.myCardinality;
        if (scalableCardinality == null) {
            Number2Domain.$$$reportNull$$$0(9);
        }
        return scalableCardinality;
    }

    private boolean checkTwoParameter(@NotNull Number2Domain domain) {
        if (domain == null) {
            Number2Domain.$$$reportNull$$$0(10);
        }
        return domain.getMaxScale() <= this.myMaxScale && domain.getMaxPrecision() <= this.myMaxPrecision;
    }

    @Override
    @Nullable
    public Object trim(@NotNull Object o) {
        if (o == null) {
            Number2Domain.$$$reportNull$$$0(11);
        }
        DecimalFormat format = new DecimalFormat();
        int integerDigits = this.getIntegerDigitsCount();
        int fractionDigits = this.getFractionDigitsCount();
        format.setMaximumIntegerDigits(integerDigits <= 0 ? Integer.MAX_VALUE : integerDigits);
        format.setMaximumFractionDigits(fractionDigits < 0 ? Integer.MAX_VALUE : fractionDigits);
        try {
            String formatted = format.format(o);
            return format.parse(formatted);
        }
        catch (IllegalArgumentException | ParseException exception) {
            return null;
        }
    }

    @Override
    @NotNull
    public Number2Domain narrow(@NotNull SizeProvider provider) {
        if (provider == null) {
            Number2Domain.$$$reportNull$$$0(12);
        }
        if (!this.myNarrowable) {
            Number2Domain number2Domain = this;
            if (number2Domain == null) {
                Number2Domain.$$$reportNull$$$0(13);
            }
            return number2Domain;
        }
        Number2Domain number2Domain = new Number2Domain(this.simpleName(), this.getPoint(), Math.min(provider.getSize(), this.getMaxPrecision()), Math.min(this.propScale(provider.getSize(), provider.getScale()), this.getMaxScale()), true);
        if (number2Domain == null) {
            Number2Domain.$$$reportNull$$$0(14);
        }
        return number2Domain;
    }

    private int propScale(int size, int scale) {
        if (size <= this.getMaxPrecision()) {
            return scale;
        }
        double k = (double)this.getMaxPrecision() / (double)size;
        return (int)((double)scale * k + 0.5);
    }

    @Override
    @NotNull
    public Number2Domain narrow(@NotNull Domain domain) {
        if (domain == null) {
            Number2Domain.$$$reportNull$$$0(15);
        }
        if (!this.myNarrowable) {
            Number2Domain number2Domain = this;
            if (number2Domain == null) {
                Number2Domain.$$$reportNull$$$0(16);
            }
            return number2Domain;
        }
        Number2Domain number2Domain = domain instanceof Number2Domain ? new Number2Domain(this.simpleName(), this.getPoint(), Math.min(((Number2Domain)domain).getMaxPrecision(), this.getMaxPrecision()), Math.min(((Number2Domain)domain).getMaxScale(), this.getMaxScale()), true) : (domain instanceof IntegerDomain ? new Number2Domain(this.simpleName(), this.getPoint(), Math.min(Math.max(0, (int)Math.ceil(Math.log10(((IntegerDomain)domain).getMaxValue()))), this.getMaxPrecision()), 0, true) : (domain instanceof NumberDomain ? new Number2Domain(this.simpleName(), this.getPoint(), this.getMaxPrecision(), this.getMaxScale() / 2, true) : this));
        if (number2Domain == null) {
            Number2Domain.$$$reportNull$$$0(17);
        }
        return number2Domain;
    }

    @Override
    @NotNull
    public String name() {
        String string = this.myNarrowable && this.getMaxPrecision() > 0 && this.getMaxScale() >= 0 ? this.simpleName() + "(" + this.getMaxPrecision() + "," + this.getMaxScale() + ")" : super.name();
        if (string == null) {
            Number2Domain.$$$reportNull$$$0(18);
        }
        return string;
    }

    protected int getFractionDigitsCount() {
        return this.getMaxScale();
    }

    protected int getIntegerDigitsCount() {
        return this.getMaxPrecision() - this.getMaxScale();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationSupport";
                break;
            }
            case 5: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domain";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/data/types/domain/Number2Domain";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/data/types/domain/Number2Domain";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompatibility";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "cardinality";
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "narrow";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCompatibility";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkTwoParameter";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "trim";
                break;
            }
            case 12: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "narrow";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

