/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.Dbms;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.datagrid.DataBusGridDataHookUp;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseMutatorImpl;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicTypedElement;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.script.generator.dml.DmlGenerator;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.OrderBy;
import com.intellij.database.script.generator.dml.SelectTask;
import com.intellij.database.script.generator.dml.WhereClause;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.sql.SQLException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DatabaseGridDataHookUp
extends DataBusGridDataHookUp
implements DataRequest.TxIsolationOwner,
DataRequest.DepartmentHolder {
    private final DatabaseMutatorImpl myMutator;
    private final DatabaseDepartment myDepartment;
    protected volatile DatabaseSession mySession;
    private DasTable myDatabaseTable;
    private SqlTableType myTableType;
    private boolean myReadOnly;

    DatabaseGridDataHookUp(@NotNull Project project, @NotNull DatabaseSession session2, @NotNull DatabaseDepartment department) {
        if (project == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(0);
        }
        if (session2 == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(1);
        }
        if (department == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(2);
        }
        super(project, session2.getMessageBus());
        this.mySession = session2;
        this.myDepartment = department;
        this.myMutator = new DatabaseMutatorImpl(this.getModel(), this);
    }

    public void setSession(@NotNull DatabaseSession session2) {
        if (session2 == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(3);
        }
        this.mySession = session2;
        this.setDataBus(session2.getMessageBus());
    }

    @Override
    public boolean isChildOf(@NotNull DataRequest.Owner owner) {
        if (owner == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(4);
        }
        return this == owner || this.getSession().isChildOf(owner);
    }

    @Override
    @NotNull
    public DatabaseDepartment getDepartment() {
        DatabaseDepartment databaseDepartment = this.myDepartment;
        if (databaseDepartment == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(5);
        }
        return databaseDepartment;
    }

    @Nullable
    public DatabaseMutatorImpl getMutator() {
        return this.myMutator;
    }

    @Override
    @NotNull
    protected DatabaseLoader createLoader() {
        DatabaseLoader databaseLoader = new DatabaseLoader();
        if (databaseLoader == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(6);
        }
        return databaseLoader;
    }

    @Override
    public boolean isReadOnly() {
        if (this.myReadOnly) {
            return true;
        }
        DbDataSource dataSource = this.getDataSource();
        if (!dataSource.isWritable()) {
            return true;
        }
        ObjectKind kind = this.myDatabaseTable != null ? this.myDatabaseTable.getKind() : null;
        return !DbImplUtil.isEditableTable(this.getDbms(), kind);
    }

    @Override
    public void setTxIsolation(int isolation) {
        this.mySession.setTxIsolation(isolation);
    }

    @Override
    public int getTxIsolation() {
        return this.mySession.getTxIsolation();
    }

    @Override
    @NotNull
    public DataRequest.TxMarker getCurrentTx() {
        DataRequest.TxMarker txMarker = this.mySession.getCurrentTx();
        if (txMarker == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(7);
        }
        return txMarker;
    }

    @Override
    public void setCurrentTx(@NotNull DataRequest.TxMarker txMarker) {
        if (txMarker == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(8);
        }
        this.mySession.setCurrentTx(txMarker);
    }

    @Nullable
    public DasTable getDatabaseTable() {
        if (this.myDatabaseTable instanceof DbElement) {
            return ((DbElement)this.myDatabaseTable).isValid() ? this.myDatabaseTable : null;
        }
        return this.myDatabaseTable;
    }

    public void setDatabaseTable(@Nullable DasTable databaseTable) {
        this.myDatabaseTable = databaseTable;
    }

    @NotNull
    protected DatabaseSession getSession() {
        DatabaseSession databaseSession = this.mySession;
        if (databaseSession == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(9);
        }
        return databaseSession;
    }

    @Override
    @NotNull
    public DbDataSource getDataSource() {
        LocalDataSource target2 = (LocalDataSource)this.mySession.getTarget();
        DbDataSource dbDataSource = (DbDataSource)ObjectUtils.notNull((Object)DbImplUtil.getDbDataSource(this.getProject(), target2));
        if (dbDataSource == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(10);
        }
        return dbDataSource;
    }

    @Override
    @NotNull
    public Dbms getDbms() {
        Dbms dbms = this.getDataSource().getDbms();
        if (dbms == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(11);
        }
        return dbms;
    }

    @Nullable
    public DasColumn getDatabaseColumn(@Nullable DataConsumer.Column column2) {
        if (column2 == null) {
            return null;
        }
        DasTable dasTable = this.getDatabaseTable();
        return dasTable != null ? (DasColumn)JBIterable.from((Iterable)DasUtil.getColumns((DasObject)dasTable)).filter(DasUtil.byName((String)column2.name)).first() : null;
    }

    @Nullable
    public SqlTableType getTableType() {
        if (this.myTableType == null || this.myTableType.getColumnCount() != this.myModel.getColumnCount()) {
            return null;
        }
        List columns = this.myModel.getColumns();
        for (DataConsumer.Column column2 : columns) {
            String nameFromColumn;
            String nameFromType = StringUtil.nullize((String)this.myTableType.getColumnName(column2.columnNum));
            if (StringUtil.equals((CharSequence)nameFromType, (CharSequence)(nameFromColumn = StringUtil.nullize((String)column2.name)))) continue;
            return null;
        }
        return this.myTableType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "department";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/DatabaseGridDataHookUp";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "txMarker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/DatabaseGridDataHookUp";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDepartment";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createLoader";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentTx";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSession";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSource";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setSession";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isChildOf";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentTx";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class DatabaseLoader
    extends DataBusGridDataHookUp.DataBusLoader {
        private boolean myLastColumnIsRowId;

        @Override
        public void setColumns(@NotNull DataRequest.Context context, int resultSetIndex, DataConsumer.Column[] columns, int firstRowNum) {
            boolean sameQuery;
            if (context == null) {
                DatabaseLoader.$$$reportNull$$$0(0);
            }
            DatabaseGridDataHookUp.this.myReadOnly = (sameQuery = Comparing.equal((String)this.getQueryText(), (String)context.getQuery())) ? DatabaseGridDataHookUp.this.myReadOnly : !DbSqlUtil.isResultEditable(context.request, DatabaseGridDataHookUp.this.myDatabaseTable);
            ConsoleDataRequest request = (ConsoleDataRequest)ObjectUtils.tryCast((Object)context.request, ConsoleDataRequest.class);
            DatabaseGridDataHookUp.this.myTableType = request != null ? (SqlTableType)ObjectUtils.tryCast((Object)request.resultType, SqlTableType.class) : null;
            DatabaseGridDataHookUp.this.myMutator.clearPendingChanges();
            super.setColumns(context, resultSetIndex, columns, firstRowNum);
        }

        @Override
        protected DataConsumer.Column[] prepareColumns(@NotNull DataConsumer.Column[] columns) {
            if (columns == null) {
                DatabaseLoader.$$$reportNull$$$0(1);
            }
            for (int i2 = 0; i2 < columns.length; ++i2) {
                DataConsumer.Column column2 = columns[i2];
                DasColumn databaseColumn = DatabaseGridDataHookUp.this.getDatabaseColumn(column2);
                if (databaseColumn != null && (column2.type == 0 || column2.type == 1111)) {
                    columns[column2.columnNum] = column2 = new DataConsumer.Column(column2.columnNum, column2.name, this.getJdbcType(databaseColumn), column2.typeName, column2.clazz);
                    continue;
                }
                if (i2 != columns.length - 1 || !this.myLastColumnIsRowId) continue;
                columns[i2] = DbImplUtil.makeRowId(column2);
            }
            return columns;
        }

        @Override
        protected void setQueryText(@Nullable String query) {
            super.setQueryText(query);
            DatabaseGridDataHookUp.this.myPageModel.setTotalRowCountUpdateable(this.canCountRows(query));
        }

        protected boolean canCountRows(@Nullable String query) {
            return StringUtil.isNotEmpty((String)query) && DmlUtilKt.dmlGenerator(DatabaseGridDataHookUp.this.getDbms()).wrap(DbImplUtil.createBuilderForUIExec(DatabaseGridDataHookUp.this.getDbms(), null), query, DatabaseGridDataHookUp.this.getProject(), DmlTaskKt.countAll().build()) != null;
        }

        @Override
        public void updateTotalRowCount(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            String text2;
            if (source == null) {
                DatabaseLoader.$$$reportNull$$$0(2);
            }
            if ((text2 = DatabaseGridDataHookUp.this.getUnlimitedQueryText(false)) == null || !this.canCountRows(text2)) {
                DatabaseGridDataHookUp.this.notifyRequestFinished(source, false);
                return;
            }
            DbDataSource system = DatabaseGridDataHookUp.this.getDataSource();
            Dbms dbms = DatabaseGridDataHookUp.this.getDbms();
            Project project = DatabaseGridDataHookUp.this.getProject();
            String alias = DbImplUtil.findFreeAlias(project, dbms, text2, "t");
            DdlBuilder builder = DbImplUtil.createBuilderForUIExec(DbImplUtil.getDatabaseDialect(dbms), (DasObject)system);
            SelectTask task = DmlTaskKt.countAll().system((DasDataSource)system).alias(alias).build();
            final DmlGenerator.Companion.Result result2 = DmlUtilKt.dmlGenerator(dbms).wrap(builder, text2, project, task);
            DataRequest.RawRequest request = new DataRequest.RawRequest(DatabaseGridDataHookUp.this){

                @Override
                public void processRaw(DataRequest.Context context, DatabaseConnection connection2) {
                    try {
                        long count2 = DbImplUtil.getCount(connection2, ((DmlGenerator.Companion.Result)ObjectUtils.assertNotNull((Object)result2)).getStatement());
                        DatabaseGridDataHookUp.this.myPageModel.setTotalRowCount(count2, true);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            };
            DatabaseGridDataHookUp.this.processRequest(source, request, DataBusGridDataHookUp.ReloadPolicy.DO_NOT_RELOAD);
        }

        @Override
        protected boolean canUpdateQueryText() {
            return DatabaseGridDataHookUp.this.getDatabaseTable() != null && (this.getQueryText() == null || this.isQueryInvalidated());
        }

        @Override
        @Nullable
        protected String createQueryText(@NotNull DataBusGridDataHookUp.QueryAttributes attributes2) {
            Pair<String, Boolean> pure2;
            if (attributes2 == null) {
                DatabaseLoader.$$$reportNull$$$0(3);
            }
            if ((pure2 = this.createQueryTextPure(attributes2)) == null) {
                return null;
            }
            this.myLastColumnIsRowId = (Boolean)pure2.getSecond();
            return (String)pure2.getFirst();
        }

        @Nullable
        public Pair<String, Boolean> createQueryTextPure(@NotNull DataBusGridDataHookUp.QueryAttributes attributes2) {
            DasTable dbTable;
            if (attributes2 == null) {
                DatabaseLoader.$$$reportNull$$$0(4);
            }
            if ((dbTable = DatabaseGridDataHookUp.this.getDatabaseTable()) == null) {
                return null;
            }
            DatabaseDialectEx dbDialect = DatabaseGridDataHookUp.this.getDatabaseDialect();
            boolean needId = this.needRowId(dbTable);
            SelectTask task = DmlTaskKt.allColumns(dbTable).system((DasDataSource)DatabaseGridDataHookUp.this.getDataSource()).limit(attributes2.limit().orElse(-1)).offset(attributes2.offset().orElse(0)).whereClause(this.getWhereClause()).appendRowId(needId).orderBy(this.getOrderBy()).insertNewLines(true).build();
            DdlBuilder builder = DmlUtilKt.dmlGenerator(DatabaseGridDataHookUp.this.getDbms()).generate(DbImplUtil.createBuilderForUIExec(dbDialect, (DasObject)dbTable), task);
            return Pair.create((Object)builder.getStatement(), (Object)(needId && dbDialect.hasRowId((DasDataSource)DatabaseGridDataHookUp.this.getDataSource()) ? 1 : 0));
        }

        private int getJdbcType(@NotNull DasColumn column2) {
            BasicTypedElement element2;
            if (column2 == null) {
                DatabaseLoader.$$$reportNull$$$0(5);
            }
            if ((element2 = (BasicTypedElement)ObjectUtils.tryCast((Object)DbImplUtil.unwrap((DasObject)column2), BasicTypedElement.class)) == null) {
                return column2.getDataType().jdbcType;
            }
            return DbImplUtil.getModelHelper(element2).getJdbcType(element2);
        }

        private boolean needRowId(@NotNull DasTable table) {
            if (table == null) {
                DatabaseLoader.$$$reportNull$$$0(6);
            }
            return table.getKind() == ObjectKind.TABLE && DasUtil.getPrimaryKey((DasTable)table) == null;
        }

        @Nullable
        protected OrderBy getOrderBy() {
            return null;
        }

        @Nullable
        protected WhereClause getWhereClause() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseLoader";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setColumns";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "prepareColumns";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateTotalRowCount";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createQueryText";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createQueryTextPure";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getJdbcType";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "needRowId";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

