/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.OperandType;
import com.intellij.database.data.types.PredicatesHelper;
import com.intellij.database.data.types.PredicatesUtilKt;
import com.intellij.database.data.types.domain.LikeOpType;
import com.intellij.database.dialects.base.BasePredicatesHelper$WhenMappings;
import com.intellij.database.model.DasColumn;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.util.Version;
import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J>\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J.\u0010\u001a\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0014J&\u0010\u001b\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0014JD\u0010\u001c\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00130\u001e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0014Jg\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u001e0 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001e2\u0010\u0010\"\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110#2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00130\u001e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016\u00a2\u0006\u0002\u0010$J>\u0010%\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0014J>\u0010'\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006("}, d2={"Lcom/intellij/database/dialects/base/BasePredicatesHelper;", "Lcom/intellij/database/data/types/PredicatesHelper;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "getDbms", "()Lcom/intellij/database/Dbms;", "formatTypes", "", "Lcom/intellij/database/data/types/LogicalType;", "getFormatTypes", "()Ljava/util/Set;", "equalsOrLike", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "column", "Lcom/intellij/database/model/DasColumn;", "value", "", "type", "Lcom/intellij/database/data/types/OperandType;", "likeType", "Lcom/intellij/database/data/types/domain/LikeOpType;", "matchCase", "", "version", "Lcom/intellij/database/util/Version;", "equalsPredicate", "ftsPredicate", "getPredicateProducer", "types", "", "getPredicateProducers", "", "columns", "values", "", "(Ljava/util/List;[Ljava/lang/Object;Ljava/util/List;Lcom/intellij/database/data/types/domain/LikeOpType;ZLcom/intellij/database/util/Version;)Ljava/util/Map;", "likePredicate", "canCastToText", "otherPredicate", "intellij.database.dialects.base"})
public class BasePredicatesHelper
implements PredicatesHelper {
    @NotNull
    private final Set<LogicalType> formatTypes;
    @NotNull
    private final Dbms dbms;

    @NotNull
    protected Set<LogicalType> getFormatTypes() {
        return this.formatTypes;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<DasColumn, List<PredicatesHelper.PredicateProducer>> getPredicateProducers(@NotNull List<? extends DasColumn> columns, @NotNull Object[] values2, @NotNull List<? extends OperandType> types, @NotNull LikeOpType likeType, boolean matchCase, @Nullable Version version) {
        Intrinsics.checkParameterIsNotNull(columns, (String)"columns");
        Intrinsics.checkParameterIsNotNull((Object)values2, (String)"values");
        Intrinsics.checkParameterIsNotNull(types, (String)"types");
        Intrinsics.checkParameterIsNotNull((Object)((Object)likeType), (String)"likeType");
        boolean bl = false;
        Map predicates = new LinkedHashMap();
        Iterable $this$forEachIndexed$iv = columns;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void c2;
            int n = index$iv++;
            boolean bl2 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            DasColumn dasColumn = (DasColumn)item$iv;
            int i2 = n2;
            boolean bl3 = false;
            PredicatesHelper.PredicateProducer predicate = this.getPredicateProducer((DasColumn)c2, values2[i2], types, likeType, matchCase, version);
            if (predicate == null) continue;
            predicates.put(c2, CollectionsKt.listOf((Object)predicate));
        }
        return predicates;
    }

    @Nullable
    protected PredicatesHelper.PredicateProducer getPredicateProducer(@NotNull DasColumn column2, @Nullable Object value, @NotNull List<? extends OperandType> types, @NotNull LikeOpType likeType, boolean matchCase, @Nullable Version version) {
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        Intrinsics.checkParameterIsNotNull(types, (String)"types");
        Intrinsics.checkParameterIsNotNull((Object)((Object)likeType), (String)"likeType");
        for (OperandType operandType : types) {
            PredicatesHelper.PredicateProducer predicate;
            PredicatesHelper.PredicateProducer predicateProducer;
            switch (BasePredicatesHelper$WhenMappings.$EnumSwitchMapping$0[operandType.ordinal()]) {
                case 1: {
                    predicateProducer = this.ftsPredicate(column2, value, version);
                    break;
                }
                case 2: {
                    predicateProducer = PredicatesUtilKt.defaultEqualsPredicate(column2, value, operandType, this.dbms, version);
                    break;
                }
                case 3: {
                    if (PredicatesUtilKt.getRequiredFormat(column2, this.dbms, version, this.getFormatTypes()) != null) {
                        predicateProducer = null;
                        break;
                    }
                    predicateProducer = this.equalsOrLike(column2, value, operandType, likeType, matchCase, version);
                    break;
                }
                case 4: {
                    predicateProducer = this.otherPredicate(column2, value, operandType, likeType, matchCase, version);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            if ((predicate = predicateProducer) == null) continue;
            return predicate;
        }
        return null;
    }

    @Nullable
    protected PredicatesHelper.PredicateProducer equalsPredicate(@NotNull DasColumn column2, @Nullable Object value, @NotNull OperandType type, @Nullable Version version) {
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        return PredicatesUtilKt.defaultEqualsPredicate(column2, value, type, this.dbms, version);
    }

    @Nullable
    protected PredicatesHelper.PredicateProducer likePredicate(@NotNull DasColumn column2, @Nullable Object value, @NotNull LikeOpType likeType, boolean matchCase, boolean canCastToText, @Nullable Version version) {
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        Intrinsics.checkParameterIsNotNull((Object)((Object)likeType), (String)"likeType");
        return PredicatesUtilKt.defaultLikePredicate(column2, value, likeType, matchCase, this.dbms, version);
    }

    @Nullable
    protected PredicatesHelper.PredicateProducer ftsPredicate(@NotNull DasColumn column2, @Nullable Object value, @Nullable Version version) {
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        return null;
    }

    private final PredicatesHelper.PredicateProducer equalsOrLike(DasColumn column2, Object value, OperandType type, LikeOpType likeType, boolean matchCase, Version version) {
        PredicatesHelper.PredicateProducer predicateProducer;
        if (likeType == LikeOpType.MATCHES) {
            predicateProducer = this.equalsPredicate(column2, value, type, version);
            if (predicateProducer == null) {
                predicateProducer = this.likePredicate(column2, value, likeType, matchCase, type != OperandType.TEXT, version);
            }
        } else {
            predicateProducer = this.likePredicate(column2, value, likeType, matchCase, type != OperandType.TEXT, version);
            if (predicateProducer == null) {
                predicateProducer = this.equalsPredicate(column2, value, type, version);
            }
        }
        return predicateProducer;
    }

    private final PredicatesHelper.PredicateProducer otherPredicate(DasColumn column2, Object value, OperandType type, LikeOpType likeType, boolean matchCase, Version version) {
        Formatter format;
        if (value instanceof String && (format = PredicatesUtilKt.getRequiredFormat(column2, this.dbms, version, this.getFormatTypes())) != null) {
            try {
                if (format.parse((String)value) != null) {
                    return PredicatesUtilKt.defaultEqualsPredicate(column2, value, type, this.dbms, version);
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return this.likePredicate(column2, value, likeType, matchCase, type != OperandType.TEXT, version);
        }
        return this.equalsOrLike(column2, value, type, likeType, matchCase, version);
    }

    @NotNull
    public final Dbms getDbms() {
        return this.dbms;
    }

    public BasePredicatesHelper(@NotNull Dbms dbms) {
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        this.dbms = dbms;
        this.formatTypes = SetsKt.setOf((Object[])new LogicalType[]{LogicalType.TIME_WITH_TIMEZONE, LogicalType.TIMESTAMP_WITH_TIMEZONE, LogicalType.TIMESTAMP, LogicalType.TIME, LogicalType.DATE, LogicalType.UUID, LogicalType.BOOLEAN});
    }
}

