/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseSingleDatabaseIntrospectorKt;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModDatabase;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicModSingleDatabaseRoot;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSingleDatabaseRoot;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.util.TreePattern;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.DBTransaction;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0005:\u0001(B\u001f\b\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014H\u0014J!\u0010\u0016\u001a\u00020\u00102\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u0018\"\u00020\u0019H\u0016\u00a2\u0006\u0002\u0010\u001aJ8\u0010\u001b\u001a\u00020\u00102\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0018\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\u00180\"H\u0016J\u001e\u0010$\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00010&H$J\b\u0010'\u001a\u00020\u0010H&\u00a8\u0006)"}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector;", "R", "Lcom/intellij/database/model/basic/BasicModSingleDatabaseRoot;", "S", "Lcom/intellij/database/model/basic/BasicModSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector;", "dbms", "Lcom/intellij/database/Dbms;", "project", "Lcom/intellij/openapi/project/Project;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "(Lcom/intellij/database/Dbms;Lcom/intellij/openapi/project/Project;Lcom/intellij/database/model/ModelFactory;)V", "getDefaultScope", "Lcom/intellij/database/util/TreePattern;", "introspectAutoInTran", "", "tran", "Lorg/jetbrains/dekaf/core/DBTransaction;", "namespaces", "", "Lcom/intellij/database/model/basic/BasicNamespace;", "introspectDatabaseSchemas", "databases", "", "Lcom/intellij/database/model/basic/BasicDatabase;", "([Lcom/intellij/database/model/basic/BasicDatabase;)V", "introspectNativeDefinitions", "elements", "", "Lcom/intellij/database/model/basic/BasicElement;", "withNestedElements", "", "result", "", "", "introspectSchemasAuto", "schemas", "", "retrieveAndApplySchemas", "BaseDatabaseRetriever", "intellij.database.dialects.base"})
public abstract class BaseSingleDatabaseIntrospector<R extends BasicModSingleDatabaseRoot, S extends BasicModSchema>
extends BaseIntrospector<R, R, S> {
    @Override
    public void introspectDatabaseSchemas(BasicDatabase ... databases) {
        Intrinsics.checkParameterIsNotNull((Object)databases, (String)"databases");
        boolean bl = this.getInitialized();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-BaseSingleDatabaseIntrospector$introspectDatabaseSchemas$32 = false;
            String $i$a$-assert-BaseSingleDatabaseIntrospector$introspectDatabaseSchemas$32 = "Introspector is not initialized yet.";
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-BaseSingleDatabaseIntrospector$introspectDatabaseSchemas$32));
        }
        BasicDatabase[] basicDatabaseArray = databases;
        bl2 = false;
        boolean bl3 = basicDatabaseArray.length == 0 || databases.length == 1 && Intrinsics.areEqual((Object)databases[0], (Object)this.getModel().getRoot());
        bl2 = false;
        if (_Assertions.ENABLED && !bl3) {
            boolean bl4 = false;
            String string = "Invalid or alien databases.";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.retrieveAndApplySchemas();
    }

    public abstract void retrieveAndApplySchemas();

    @Override
    protected void introspectAutoInTran(@NotNull DBTransaction tran, @Nullable Collection<? extends BasicNamespace> namespaces) {
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        ArrayList<BasicModSchema> schemas2 = new ArrayList<BasicModSchema>();
        BasicRoot basicRoot = this.getModel().getRoot();
        if (basicRoot == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.basic.BasicSingleDatabaseRoot");
        }
        BasicSingleDatabaseRoot root2 = (BasicSingleDatabaseRoot)basicRoot;
        Collection<? extends BasicNamespace> collection = namespaces;
        if (collection != null) {
            $this$forEach$iv = collection;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BasicSchema schema;
                BasicNamespace namespace = (BasicNamespace)element$iv;
                boolean bl = false;
                boolean bl2 = this.getModel().contains(namespace);
                boolean bl3 = false;
                boolean bl4 = false;
                if (_Assertions.ENABLED && !bl2) {
                    boolean bl5 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                BasicNamespace basicNamespace = namespace;
                if (!(basicNamespace instanceof BasicSchema)) {
                    basicNamespace = null;
                }
                if ((BasicSchema)basicNamespace == null) {
                    continue;
                }
                BasicSchema basicSchema = schema;
                if (basicSchema == null) {
                    throw new TypeCastException("null cannot be cast to non-null type S");
                }
                schemas2.add((BasicModSchema)basicSchema);
            }
        }
        if (schemas2.isEmpty()) {
            this.introspectNamespacesInTran(tran);
            this.introspectSessionState(tran);
            NamingFamily<? extends BasicSchema> namingFamily = root2.getSchemas();
            Intrinsics.checkExpressionValueIsNotNull(namingFamily, (String)"root.schemas");
            $this$forEach$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)namingFamily), (Function1)((Function1)new Function1<BasicSchema, Boolean>(this){
                final /* synthetic */ BaseSingleDatabaseIntrospector this$0;

                public final boolean invoke(BasicSchema it2) {
                    BasicSchema basicSchema = it2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)basicSchema, (String)"it");
                    return this.this$0.isIntrospected(basicSchema);
                }
                {
                    this.this$0 = baseSingleDatabaseIntrospector;
                    super(1);
                }
            }));
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BasicSchema it2 = (BasicSchema)element$iv;
                boolean bl = false;
                BasicSchema basicSchema = it2;
                if (basicSchema == null) {
                    throw new TypeCastException("null cannot be cast to non-null type S");
                }
                schemas2.add((BasicModSchema)basicSchema);
            }
        }
        if (!schemas2.isEmpty()) {
            this.introspectSchemasAuto(tran, (List)schemas2);
        }
        this.postIntrospectionProcess();
    }

    protected abstract void introspectSchemasAuto(@NotNull DBTransaction var1, @NotNull List<? extends S> var2);

    @Override
    @NotNull
    public TreePattern getDefaultScope() {
        return BaseSingleDatabaseIntrospectorKt.getSINGLE_DB_SCOPE();
    }

    @Override
    public void introspectNativeDefinitions(@NotNull Iterable<? extends BasicElement> elements, boolean withNestedElements, @NotNull Map<BasicElement, String[]> result2) {
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        Intrinsics.checkParameterIsNotNull(result2, (String)"result");
        this.inTransactionUnit((Function1<DBTransaction, Unit>)((Function1)new Function1<DBTransaction, Unit>(this, elements, withNestedElements, result2){
            final /* synthetic */ BaseSingleDatabaseIntrospector this$0;
            final /* synthetic */ Iterable $elements;
            final /* synthetic */ boolean $withNestedElements;
            final /* synthetic */ Map $result;

            public final void invoke(@NotNull DBTransaction transaction) {
                Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
                BasicRoot basicRoot = this.this$0.getModel().getRoot();
                if (basicRoot == null) {
                    throw new TypeCastException("null cannot be cast to non-null type R");
                }
                BaseIntrospector.AbstractDatabaseRetriever<BasicModDatabase> retriever = this.this$0.createDatabaseRetriever(transaction, (BasicModDatabase)((BasicModSingleDatabaseRoot)basicRoot));
                retriever.retrieveNativeDefinitions(this.$elements, this.$withNestedElements, this.$result);
            }
            {
                this.this$0 = baseSingleDatabaseIntrospector;
                this.$elements = iterable;
                this.$withNestedElements = bl;
                this.$result = map2;
                super(1);
            }
        }));
    }

    protected BaseSingleDatabaseIntrospector(@NotNull Dbms dbms, @NotNull Project project, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)modelFactory, (String)"modelFactory");
        super(dbms, project, modelFactory);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00a4\u0004\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u00022\u001e\u0012\u0004\u0012\u0002H\u00010\u0003R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004B\u000f\b\u0014\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector$BaseDatabaseRetriever;", "D", "Lcom/intellij/database/model/basic/BasicModSingleDatabaseRoot;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$AbstractDatabaseRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "(Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;)V", "intellij.database.dialects.base"})
    protected abstract class BaseDatabaseRetriever<D extends BasicModSingleDatabaseRoot>
    extends BaseIntrospector.AbstractDatabaseRetriever<D> {
        final /* synthetic */ BaseSingleDatabaseIntrospector this$0;

        protected BaseDatabaseRetriever(@NotNull BaseSingleDatabaseIntrospector $outer, DBTransaction transaction) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            BasicRoot basicRoot = $outer.getModel().getRoot();
            if (basicRoot == null) {
                throw new TypeCastException("null cannot be cast to non-null type D");
            }
            super((BaseIntrospector)$outer, transaction, (BasicModDatabase)((BasicModSingleDatabaseRoot)basicRoot));
            this.this$0 = $outer;
        }
    }
}

