/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector.jdbc.wrappers;

import com.intellij.database.dialects.base.introspector.jdbc.wrappers.ClosableIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.DatabaseMetaDataWrapper;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.MetaDataUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.TIntHashSet;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableKeyColumnIt
extends ClosableIt.ResultSetClosableIt<DatabaseMetaDataWrapper.TableKeyColumn> {
    private final TIntHashSet myPoses;
    private final DatabaseMetaDataWrapper.Table myTable;

    public TableKeyColumnIt(@Nullable ResultSet rs, @NotNull DatabaseMetaDataWrapper.Table table) throws SQLException {
        if (table == null) {
            TableKeyColumnIt.$$$reportNull$$$0(0);
        }
        super(rs);
        this.myPoses = new TIntHashSet();
        this.myTable = table;
    }

    @Override
    @NotNull
    protected DatabaseMetaDataWrapper.TableKeyColumn createStorage() {
        DatabaseMetaDataWrapper.TableKeyColumn tableKeyColumn = new DatabaseMetaDataWrapper.TableKeyColumn(new DatabaseMetaDataWrapper.TableKey(this.myTable, ""));
        if (tableKeyColumn == null) {
            TableKeyColumnIt.$$$reportNull$$$0(1);
        }
        return tableKeyColumn;
    }

    @Override
    protected DatabaseMetaDataWrapper.TableKeyColumn calcValue() {
        DatabaseMetaDataWrapper.TableKeyColumn res2 = (DatabaseMetaDataWrapper.TableKeyColumn)this.getStorageToFill();
        try {
            String table = this.myRs.getString("TABLE_NAME", 3);
            if (StringUtil.isEmpty((String)table)) {
                return (DatabaseMetaDataWrapper.TableKeyColumn)this.skip();
            }
            String cat = this.myRs.getString("TABLE_CAT", 1);
            String schema = StringUtil.notNullize((String)this.myRs.getString("TABLE_SCHEM", 2), (String)this.myTable.schema.schema);
            if (!Comparing.equal((String)schema, (String)this.myTable.schema.schema) || !Comparing.equal((String)table, (String)this.myTable.name)) {
                return (DatabaseMetaDataWrapper.TableKeyColumn)this.skip();
            }
            res2.name = this.myRs.getString("COLUMN_NAME", 4);
            res2.position = this.myRs.getShort("KEY_SEQ", 5);
            while (this.myPoses.contains((int)res2.position)) {
                res2.position = (short)(res2.position + 1);
            }
            this.myPoses.add((int)res2.position);
            res2.key.name = this.myRs.getString("PK_NAME", 6);
            res2.name = this.myRs.getString("COLUMN_NAME", 4);
            res2.key.primary = true;
        }
        catch (SQLException e) {
            this.onError(res2, e);
            return (DatabaseMetaDataWrapper.TableKeyColumn)this.skip();
        }
        return res2;
    }

    @Override
    public void onError(DatabaseMetaDataWrapper.TableKeyColumn cur, SQLException e) {
        String title = cur == null ? null : MetaDataUtil.qName(cur.key.table.schema.database, cur.key.table.schema.schema, cur.key.table.name);
        this.addError(title, e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/TableKeyColumnIt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/TableKeyColumnIt";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createStorage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Grouping
    extends ClosableIt.GroupingItImpl<DatabaseMetaDataWrapper.TableKey, DatabaseMetaDataWrapper.TableKeyColumn, DatabaseMetaDataWrapper.TableKeyColumn> {
        protected Grouping(@NotNull ClosableIt<DatabaseMetaDataWrapper.TableKeyColumn> delegate) {
            if (delegate == null) {
                Grouping.$$$reportNull$$$0(0);
            }
            super(delegate);
        }

        @Override
        @NotNull
        protected ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.TableKeyColumn> createGroupIt(ClosableIt<DatabaseMetaDataWrapper.TableKeyColumn> it2) {
            final String keyName = ((DatabaseMetaDataWrapper.TableKeyColumn)it2.current()).key.name;
            ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.TableKeyColumn> groupIt = new ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.TableKeyColumn>(it2){

                @Override
                protected boolean isInGroup(DatabaseMetaDataWrapper.TableKeyColumn item) {
                    return Comparing.equal((String)keyName, (String)item.key.name);
                }
            };
            if (groupIt == null) {
                Grouping.$$$reportNull$$$0(1);
            }
            return groupIt;
        }

        @Override
        protected DatabaseMetaDataWrapper.TableKey getItem(ClosableIt<DatabaseMetaDataWrapper.TableKeyColumn> it2) {
            return ((DatabaseMetaDataWrapper.TableKeyColumn)it2.current()).key;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/TableKeyColumnIt$Grouping";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/TableKeyColumnIt$Grouping";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createGroupIt";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

