/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.generic;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.base.BaseDmlGenerator;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J:\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0012\u0010\u0011\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014J\b\u0010\u0014\u001a\u00020\u0010H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/dialects/generic/GenericDmlGenerator;", "Lcom/intellij/database/dialects/base/BaseDmlGenerator;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "appendLimit", "Lcom/intellij/database/util/DdlBuilder;", "builder", "dialect", "Lcom/intellij/database/dialects/DatabaseDialectEx;", "system", "Lcom/intellij/database/model/DasDataSource;", "limit", "", "offset", "atBeginning", "", "getDbms", "getPlaceForLimit", "Lcom/intellij/database/dialects/base/BaseDmlGenerator$Companion$LimitPlace;", "shouldUseLimit", "Companion", "intellij.database.dialects.generic"})
public final class GenericDmlGenerator
extends BaseDmlGenerator {
    @JvmField
    @NotNull
    public static final Set<Dbms> DEFAULT_LIMIT_DBS;
    @JvmField
    @NotNull
    public static final Set<Dbms> TOP_LIMIT_DBS;
    public static final Companion Companion;

    @Override
    @NotNull
    protected BaseDmlGenerator.Companion.LimitPlace getPlaceForLimit(@Nullable DasDataSource system) {
        Dbms dbms = this.getDbms(system);
        return Intrinsics.areEqual((Object)dbms, (Object)Dbms.TIBERO) ? BaseDmlGenerator.Companion.LimitPlace.BOTH : (DEFAULT_LIMIT_DBS.contains(dbms) || Intrinsics.areEqual((Object)dbms, (Object)Dbms.FILEMAKER) ? BaseDmlGenerator.Companion.LimitPlace.END : BaseDmlGenerator.Companion.LimitPlace.BEGIN);
    }

    private final Dbms getDbms(DasDataSource system) {
        DasDataSource dasDataSource;
        if (Intrinsics.areEqual((Object)this.getDbms(), (Object)Dbms.UNKNOWN)) {
            dasDataSource = system;
            if (dasDataSource == null || (dasDataSource = dasDataSource.getDbms()) == null) {
                Dbms dbms = Dbms.UNKNOWN;
                dasDataSource = dbms;
                Intrinsics.checkExpressionValueIsNotNull((Object)dbms, (String)"Dbms.UNKNOWN");
            }
        } else {
            dasDataSource = this.getDbms();
        }
        return dasDataSource;
    }

    @Override
    @NotNull
    protected DdlBuilder appendLimit(@NotNull DdlBuilder builder, @NotNull DatabaseDialectEx dialect, @Nullable DasDataSource system, int limit, int offset, boolean atBeginning) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)dialect, (String)"dialect");
        Dbms dbms = this.getDbms(system);
        if (!this.shouldUseLimit()) {
            return builder;
        }
        return DbImplUtil.isPageSizeUnlimited(limit) ? builder : (DEFAULT_LIMIT_DBS.contains(dbms) ? super.appendLimit(builder, dialect, system, limit, offset, atBeginning) : (TOP_LIMIT_DBS.contains(dbms) ? this.top(builder, "TOP", limit) : (Intrinsics.areEqual((Object)dbms, (Object)Dbms.INGRES) ? this.top(builder, "FIRST", limit) : (Intrinsics.areEqual((Object)dbms, (Object)Dbms.TIBERO) ? this.rowNumLimit(builder, limit, atBeginning) : (Intrinsics.areEqual((Object)dbms, (Object)Dbms.FILEMAKER) ? this.fetchFirst(builder, limit) : builder)))));
    }

    private final boolean shouldUseLimit() {
        return Registry.is((String)"database.generic_dialect.limit", (boolean)true);
    }

    public GenericDmlGenerator(@NotNull Dbms dbms) {
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        super(dbms);
    }

    static {
        Companion = new Companion(null);
        LinkedHashSet linkedHashSet = ContainerUtil.newLinkedHashSet((Object[])new Dbms[]{Dbms.INFORMIX, Dbms.PRESTO, Dbms.IMPALA, Dbms.NETEZZA, Dbms.PHOENIX, Dbms.EXASOL, Dbms.H2, Dbms.HIVE, Dbms.HSQL, Dbms.MARIA, Dbms.MYSQL, Dbms.REDSHIFT, Dbms.SNOWFLAKE, Dbms.SPARK, Dbms.VERTICA, Dbms.COCKROACH});
        Intrinsics.checkExpressionValueIsNotNull((Object)linkedHashSet, (String)"ContainerUtil.newLinkedH\u2026     Dbms.COCKROACH\n    )");
        DEFAULT_LIMIT_DBS = linkedHashSet;
        LinkedHashSet linkedHashSet2 = ContainerUtil.newLinkedHashSet((Object[])new Dbms[]{Dbms.TERADATA, Dbms.OPENEDGE, Dbms.FRONTBASE});
        Intrinsics.checkExpressionValueIsNotNull((Object)linkedHashSet2, (String)"ContainerUtil.newLinkedH\u2026     Dbms.FRONTBASE\n    )");
        TOP_LIMIT_DBS = linkedHashSet2;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/dialects/generic/GenericDmlGenerator$Companion;", "", "()V", "DEFAULT_LIMIT_DBS", "", "Lcom/intellij/database/Dbms;", "TOP_LIMIT_DBS", "intellij.database.dialects.generic"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

