/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.ssrp;

import com.intellij.database.dialects.mssql.ssrp.SsrpConstants;
import com.intellij.database.dialects.mssql.ssrp.SsrpDecoder;
import com.intellij.database.dialects.mssql.ssrp.SsrpEncoder;
import com.intellij.database.dialects.mssql.ssrp.SsrpInfo;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Consumer;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SsrpNet {
    public static Set<Response> queryNetworkInstances(int port, int timeout) throws SsrpConstants.SsrpException {
        DatagramSocket sock = null;
        HashSet<Response> result2 = new HashSet<Response>();
        Consumer consumer2 = response -> result2.add((Response)response);
        try {
            sock = new DatagramSocket();
            sock.setBroadcast(true);
            byte[] req = SsrpEncoder.createClientBroadcastReq();
            sock.setSoTimeout(timeout);
            sock.send(new DatagramPacket(req, req.length, InetAddress.getByName("255.255.255.255"), port));
            DatagramPacket packet = SsrpNet.allocateLargePacket();
            while (SsrpNet.appendResponseOrTimeout(Collections.emptyMap(), sock, packet, (Consumer<Response>)consumer2) != Boolean.FALSE) {
            }
            HashSet<Response> hashSet = result2;
            return hashSet;
        }
        catch (UnknownHostException e) {
            throw new SsrpConstants.SsrpException(e);
        }
        catch (SocketException e) {
            throw new SsrpConstants.SsrpException(e);
        }
        catch (IOException e) {
            throw new SsrpConstants.SsrpException(e);
        }
        finally {
            if (sock != null) {
                sock.close();
            }
        }
    }

    @NotNull
    public static Set<Response> queryNetworkInstances(@NotNull Set<String> hosts, int port, int timeout) throws SsrpConstants.SsrpException {
        Object object;
        if (hosts == null) {
            SsrpNet.$$$reportNull$$$0(0);
        }
        DatagramSocket sock = null;
        HashSet result2 = new HashSet();
        HashSet added = new HashSet();
        Consumer consumer2 = response -> {
            result2.add(response);
            added.add(response.host);
        };
        try {
            Boolean res2;
            sock = new DatagramSocket();
            byte[] req = SsrpEncoder.createClientUnicastReq();
            sock.setSoTimeout(timeout);
            HashMap<InetAddress, String> addr2host = new HashMap<InetAddress, String>();
            HashMap<String, InetAddress> host2addr = new HashMap<String, InetAddress>();
            int count2 = 0;
            for (String host : hosts) {
                try {
                    InetAddress address = InetAddress.getByName(host);
                    addr2host.put(address, host);
                    host2addr.put(host, address);
                    sock.send(new DatagramPacket(req, req.length, address, port));
                    ++count2;
                }
                catch (UnknownHostException e) {
                    consumer2.consume((Object)SsrpNet.createUnknownHost(host));
                }
            }
            DatagramPacket packet = SsrpNet.allocateLargePacket();
            int i2 = 0;
            while (i2 < count2 && (res2 = SsrpNet.appendResponseOrTimeout(addr2host, sock, packet, (Consumer<Response>)consumer2)) != Boolean.FALSE) {
                if (res2 == null) continue;
                ++i2;
            }
            for (String host : hosts) {
                if (added.contains(host)) continue;
                consumer2.consume((Object)SsrpNet.createNoResponse(host, (InetAddress)host2addr.get(host)));
            }
            HashSet hashSet = result2;
            object = hashSet;
        }
        catch (SocketException e) {
            throw new SsrpConstants.SsrpException(e);
        }
        catch (IOException e) {
            throw new SsrpConstants.SsrpException(e);
        }
        finally {
            if (sock != null) {
                sock.close();
            }
        }
        if (object == null) {
            SsrpNet.$$$reportNull$$$0(1);
        }
        return object;
    }

    public static Response queryInstances(@NotNull String host, int port, int timeout) throws SsrpConstants.SsrpException {
        if (host == null) {
            SsrpNet.$$$reportNull$$$0(2);
        }
        DatagramSocket sock = null;
        Ref result2 = Ref.create();
        Consumer consumer2 = response -> result2.set(response);
        try {
            sock = new DatagramSocket();
            byte[] req = SsrpEncoder.createClientUnicastReq();
            sock.setSoTimeout(timeout);
            InetAddress address = InetAddress.getByName(host);
            sock.send(new DatagramPacket(req, req.length, address, port));
            DatagramPacket packet = SsrpNet.allocateLargePacket();
            while (SsrpNet.appendResponseOrTimeout(Collections.singletonMap(address, host), sock, packet, (Consumer<Response>)consumer2) == null) {
            }
            if (result2.get() != null) {
                Response response2 = (Response)result2.get();
                return response2;
            }
            Response response3 = SsrpNet.createNoResponse(host, address);
            return response3;
        }
        catch (UnknownHostException e) {
            Response response4 = SsrpNet.createUnknownHost(host);
            return response4;
        }
        catch (SocketException e) {
            throw new SsrpConstants.SsrpException(e);
        }
        catch (IOException e) {
            throw new SsrpConstants.SsrpException(e);
        }
        finally {
            if (sock != null) {
                sock.close();
            }
        }
    }

    @NotNull
    private static Response createNoResponse(@NotNull String host, InetAddress address) {
        if (host == null) {
            SsrpNet.$$$reportNull$$$0(3);
        }
        Response response = new Response(SsrpInfo.concat("ServerName", host, "SsrpError", "NoResponse"), host, address);
        if (response == null) {
            SsrpNet.$$$reportNull$$$0(4);
        }
        return response;
    }

    @NotNull
    private static Response createUnknownHost(@NotNull String host) {
        if (host == null) {
            SsrpNet.$$$reportNull$$$0(5);
        }
        Response response = new Response(SsrpInfo.concat("ServerName", host, "SsrpError", "UnknownHost"), host, null);
        if (response == null) {
            SsrpNet.$$$reportNull$$$0(6);
        }
        return response;
    }

    @NotNull
    private static DatagramPacket allocateLargePacket() {
        byte[] responseBuffer = new byte[65600];
        DatagramPacket datagramPacket = new DatagramPacket(responseBuffer, responseBuffer.length);
        if (datagramPacket == null) {
            SsrpNet.$$$reportNull$$$0(7);
        }
        return datagramPacket;
    }

    private static Boolean appendResponseOrTimeout(@NotNull Map<InetAddress, String> addr2host, @NotNull DatagramSocket sock, @NotNull DatagramPacket buffer, @NotNull Consumer<Response> consumer2) throws SsrpConstants.SsrpException {
        if (addr2host == null) {
            SsrpNet.$$$reportNull$$$0(8);
        }
        if (sock == null) {
            SsrpNet.$$$reportNull$$$0(9);
        }
        if (buffer == null) {
            SsrpNet.$$$reportNull$$$0(10);
        }
        if (consumer2 == null) {
            SsrpNet.$$$reportNull$$$0(11);
        }
        try {
            sock.receive(buffer);
            String resp = SsrpDecoder.decodeResponseString(ByteBuffer.wrap(buffer.getData()));
            if (resp == null) {
                return null;
            }
            consumer2.consume((Object)new Response(resp, addr2host.get(buffer.getAddress()), buffer.getAddress()));
        }
        catch (SocketTimeoutException e) {
            return false;
        }
        catch (IOException e) {
            throw new SsrpConstants.SsrpException(e);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hosts";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mssql/ssrp/SsrpNet";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addr2host";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sock";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mssql/ssrp/SsrpNet";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "queryNetworkInstances";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createNoResponse";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createUnknownHost";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "allocateLargePacket";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "queryNetworkInstances";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "queryInstances";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createNoResponse";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createUnknownHost";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "appendResponseOrTimeout";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Response {
        public String response;
        public String host;
        public InetAddress addr;

        public Response(String response, String host, InetAddress addr) {
            this.response = response;
            this.host = host;
            this.addr = addr;
        }
    }
}

