/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle;

import com.intellij.database.dialects.oracle.ObjectInfo;
import com.intellij.database.dialects.oracle.OracleStatementAnalysis;
import com.intellij.database.model.ObjectKind;
import com.intellij.openapi.project.Project;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlAlterInstruction;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t\u001a \u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\"\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\u00a8\u0006\u0014"}, d2={"catalogName", "", "Lcom/intellij/sql/psi/SqlDefinition;", "getCatalogName", "(Lcom/intellij/sql/psi/SqlDefinition;)Ljava/lang/String;", "Lcom/intellij/sql/psi/SqlNameElement;", "(Lcom/intellij/sql/psi/SqlNameElement;)Ljava/lang/String;", "getOracleTypeLikeConditionFor", "kind", "Lcom/intellij/database/model/ObjectKind;", "parseAffectedObjectInfo", "Lcom/intellij/database/dialects/oracle/ObjectInfo;", "text", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "project", "Lcom/intellij/openapi/project/Project;", "parseStatementForAffectedObjectInfo", "element", "Lcom/intellij/sql/psi/SqlElement;", "intellij.database.dialects.oracle"})
@JvmName(name="OracleStatementAnalysis")
public final class OracleStatementAnalysis {
    @Nullable
    public static final ObjectInfo parseAffectedObjectInfo(@NotNull String text2, @NotNull SqlLanguageDialect dialect, @NotNull Project project) {
        Object v3;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)dialect, (String)"dialect");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            SqlPsiFacade sqlPsiFacade = SqlPsiFacade.getInstance((Project)project);
            Intrinsics.checkExpressionValueIsNotNull((Object)sqlPsiFacade, (String)"SqlPsiFacade.getInstance(project)");
            SqlPsiFacade psiFacade = sqlPsiFacade;
            SqlFile sqlFile = psiFacade.createROFile(dialect, (CharSequence)text2);
            Intrinsics.checkExpressionValueIsNotNull((Object)sqlFile, (String)"psiFacade.createROFile(dialect, text)");
            SqlFile psiFile = sqlFile;
            List list = psiFile.getDdl();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"psiFile.ddl");
            Sequence $this$firstOrNull$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)parseAffectedObjectInfo.1.INSTANCE);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ObjectInfo it2 = (ObjectInfo)element$iv;
                boolean bl = false;
                if (!(it2 != null)) continue;
                v3 = element$iv;
                break block1;
            }
            v3 = null;
        }
        return v3;
    }

    private static final ObjectInfo parseStatementForAffectedObjectInfo(SqlElement element2) {
        ObjectKind objectKind = ObjectKind.NONE;
        Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"NONE");
        ObjectKind kind = objectKind;
        String schemaName = null;
        String objectName = null;
        SqlElement sqlElement = element2;
        if (sqlElement instanceof SqlCreateStatement) {
            SqlExpression sqlExpression;
            SqlExpression q;
            ObjectKind objectKind2 = ((SqlCreateStatement)element2).getKind();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind2, (String)"element.kind");
            kind = objectKind2;
            objectName = OracleStatementAnalysis.getCatalogName((SqlDefinition)element2);
            SqlNameElement sqlNameElement = ((SqlCreateStatement)element2).getNameElement();
            if (!(sqlNameElement instanceof SqlReferenceExpression)) {
                sqlNameElement = null;
            }
            SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)sqlNameElement;
            Object object = q = sqlReferenceExpression != null ? sqlReferenceExpression.getQualifierExpression() : null;
            if (Intrinsics.areEqual((Object)kind, (Object)ObjectKind.BODY)) {
                SqlExpression sqlExpression2 = q;
                if (!(sqlExpression2 instanceof SqlReferenceExpression)) {
                    sqlExpression2 = null;
                }
                SqlReferenceExpression sqlReferenceExpression2 = (SqlReferenceExpression)sqlExpression2;
                q = sqlReferenceExpression2 != null ? sqlReferenceExpression2.getQualifierExpression() : null;
            }
            if (!((sqlExpression = q) instanceof SqlNameElement)) {
                sqlExpression = null;
            }
            SqlNameElement sqlNameElement2 = (SqlNameElement)sqlExpression;
            schemaName = sqlNameElement2 != null ? OracleStatementAnalysis.getCatalogName(sqlNameElement2) : null;
        } else if (sqlElement instanceof SqlAlterStatement) {
            SqlReferenceExpression sqlReferenceExpression = ((SqlAlterStatement)element2).getAlterTargetReference();
            if (sqlReferenceExpression == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)sqlReferenceExpression, (String)"element.alterTargetReference ?: return null");
            SqlReferenceExpression ref = sqlReferenceExpression;
            SqlReferenceElementType sqlReferenceElementType = ref.getReferenceElementType();
            Intrinsics.checkExpressionValueIsNotNull((Object)sqlReferenceElementType, (String)"ref.referenceElementType");
            ObjectKind objectKind3 = sqlReferenceElementType.getTargetKind();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind3, (String)"ref.referenceElementType.targetKind");
            kind = objectKind3;
            if (Intrinsics.areEqual((Object)kind, (Object)ObjectKind.MAT_VIEW)) {
                ObjectKind objectKind4 = ObjectKind.VIEW;
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind4, (String)"VIEW");
                kind = objectKind4;
            }
            if (Intrinsics.areEqual((Object)kind, (Object)ObjectKind.PACKAGE)) {
                SqlAlterInstruction instruction2;
                Object[] objectArray = ((SqlAlterStatement)element2).getAlterInstructions();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"element.alterInstructions");
                SqlAlterInstruction sqlAlterInstruction = instruction2 = (SqlAlterInstruction)ArraysKt.firstOrNull((Object[])objectArray);
                if (Intrinsics.areEqual((Object)(sqlAlterInstruction != null ? sqlAlterInstruction.getInstructionType() : null), (Object)SqlCommonKeywords.SQL_COMPILE)) {
                    SqlAlterInstruction sqlAlterInstruction2 = instruction2;
                    if (sqlAlterInstruction2 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (sqlAlterInstruction2.getNode().findChildByType((IElementType)SqlCommonKeywords.SQL_BODY) != null) {
                        ObjectKind objectKind5 = ObjectKind.BODY;
                        Intrinsics.checkExpressionValueIsNotNull((Object)objectKind5, (String)"BODY");
                        kind = objectKind5;
                    }
                }
            }
            objectName = OracleStatementAnalysis.getCatalogName((SqlNameElement)ref);
            SqlExpression q = ref.getQualifierExpression();
            SqlExpression sqlExpression = q;
            if (!(sqlExpression instanceof SqlNameElement)) {
                sqlExpression = null;
            }
            SqlNameElement sqlNameElement = (SqlNameElement)sqlExpression;
            schemaName = sqlNameElement != null ? OracleStatementAnalysis.getCatalogName(sqlNameElement) : null;
        }
        return objectName != null ? new ObjectInfo(kind, schemaName, objectName) : null;
    }

    private static final String getCatalogName(@NotNull SqlDefinition $this$catalogName) {
        SqlNameElement sqlNameElement = $this$catalogName.getNameElement();
        return sqlNameElement != null ? OracleStatementAnalysis.getCatalogName(sqlNameElement) : null;
    }

    private static final String getCatalogName(@NotNull SqlNameElement $this$catalogName) {
        String string = $this$catalogName.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this.name");
        String name2 = string;
        CharSequence charSequence = name2;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return null;
        }
        if ($this$catalogName.isQuotedIdentifier()) {
            name2 = StringsKt.replace$default((String)name2, (String)"\"\"", (String)"\"", (boolean)false, (int)4, null);
        } else {
            charSequence = name2;
            bl = false;
            CharSequence charSequence2 = charSequence;
            if (charSequence2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string2 = ((String)charSequence2).toUpperCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toUpperCase()");
            name2 = string2;
        }
        return name2;
    }

    @NotNull
    public static final String getOracleTypeLikeConditionFor(@NotNull ObjectKind kind) {
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        ObjectKind objectKind = kind;
        return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.VIEW) ? "like '%VIEW'" : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.MAT_VIEW) ? "like '%VIEW'" : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.BODY) ? "like '%BODY'" : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.OBJECT_TYPE) ? "= 'TYPE'" : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.COLLECTION_TYPE) ? "= 'TYPE'" : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.ROUTINE) ? "in ('PROCEDURE','FUNCTION')" : "= '" + kind.name() + '\'')))));
    }

    public static final /* synthetic */ ObjectInfo access$parseStatementForAffectedObjectInfo(SqlElement element2) {
        return OracleStatementAnalysis.parseStatementForAffectedObjectInfo(element2);
    }
}

