/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.debugger;

import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.dataSource.connection.statements.CallableStatementBasis;
import com.intellij.database.dataSource.connection.statements.CallableStatementData;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.IndexedOutParameter;
import com.intellij.database.dataSource.connection.statements.NoisyStatement;
import com.intellij.database.dataSource.connection.statements.ParameterizedStatementDecoration;
import com.intellij.database.dataSource.connection.statements.ResultsProducer;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StatementParameters;
import com.intellij.database.dialects.oracle.debugger.CallDefinition;
import com.intellij.database.dialects.oracle.debugger.SingleConnectionModeException;
import com.intellij.database.util.GuardedRef;
import com.intellij.openapi.project.Project;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u0084\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001b\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\f\u001a)\u0010\u0007\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\u000f\u001a&\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u001aO\u0010\u0019\u001a\u0002H\u001a\"\b\b\u0000\u0010\u001b*\u00020\u001c\"\u0004\b\u0001\u0010\u001a*\u00020\u00122\u0006\u0010\u001d\u001a\u0002H\u001b2\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000b2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u0002H\u001a0\u001f\u00a2\u0006\u0002\u0010!\u001a_\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H#\u0012\u0004\u0012\u0002H$0\"\"\u0004\b\u0000\u0010#\"\u0004\b\u0001\u0010$*\u00020\u00122\u0006\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u0002H#0\u00042\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H$0\u00042\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000b\u00a2\u0006\u0002\u0010)\u001a?\u0010\u0019\u001a\u0002H*\"\u0004\b\u0000\u0010**\u00020\u00122\u0006\u0010%\u001a\u00020&2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H*0\u00042\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000b\u00a2\u0006\u0002\u0010,\u001a?\u0010-\u001a\u0002H*\"\u0004\b\u0000\u0010**\u00020\u00122\u0006\u0010.\u001a\u00020&2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H*0\u00042\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000b\u00a2\u0006\u0002\u0010,\u001a+\u0010/\u001a\u000200*\u00020\u00122\u0006\u00101\u001a\u00020&2\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000b\u00a2\u0006\u0002\u00102\u001a\u0010\u00103\u001a\b\u0012\u0004\u0012\u00020504*\u00020\u0012\u001a+\u00106\u001a\u000200*\u00020\u00122\u0006\u0010%\u001a\u00020&2\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000b\u00a2\u0006\u0002\u00102\"'\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00040\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u00067"}, d2={"indices", "Ljava/util/SortedSet;", "", "", "Lcom/intellij/database/dataSource/connection/statements/IndexedOutParameter;", "getIndices", "(Ljava/util/List;)Ljava/util/SortedSet;", "decorateInParameters", "Lcom/intellij/database/dataSource/connection/statements/ParameterizedStatementDecoration;", "parameters", "", "", "([Ljava/lang/Object;)Lcom/intellij/database/dataSource/connection/statements/ParameterizedStatementDecoration;", "skip", "", "(Ljava/util/Set;[Ljava/lang/Object;)Lcom/intellij/database/dataSource/connection/statements/ParameterizedStatementDecoration;", "obtainGuardedConnection", "Lcom/intellij/database/util/GuardedRef;", "Lcom/intellij/database/dataSource/DatabaseConnection;", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "department", "Lcom/intellij/database/dataSource/connection/DatabaseDepartment;", "call", "R", "D", "Lcom/intellij/database/dialects/oracle/debugger/CallDefinition;", "definition", "handler", "Lkotlin/Function1;", "Lcom/intellij/database/dataSource/connection/statements/ResultsProducer;", "(Lcom/intellij/database/dataSource/DatabaseConnection;Lcom/intellij/database/dialects/oracle/debugger/CallDefinition;[Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Lkotlin/Pair;", "V1", "V2", "statementText", "", "outParam1", "outParam2", "(Lcom/intellij/database/dataSource/DatabaseConnection;Ljava/lang/String;Lcom/intellij/database/dataSource/connection/statements/IndexedOutParameter;Lcom/intellij/database/dataSource/connection/statements/IndexedOutParameter;[Ljava/lang/Object;)Lkotlin/Pair;", "V", "resultParam", "(Lcom/intellij/database/dataSource/DatabaseConnection;Ljava/lang/String;Lcom/intellij/database/dataSource/connection/statements/IndexedOutParameter;[Ljava/lang/Object;)Ljava/lang/Object;", "callFunction", "function", "callProcedure", "", "procedure", "(Lcom/intellij/database/dataSource/DatabaseConnection;Ljava/lang/String;[Ljava/lang/Object;)V", "executor", "Lcom/intellij/database/dataSource/connection/statements/NoisyStatement;", "Lcom/intellij/database/dataSource/connection/statements/CallableStatementData;", "perform", "intellij.database.dialects.oracle"})
public final class OracleConnectionHelperKt {
    @NotNull
    public static final GuardedRef<DatabaseConnection> obtainGuardedConnection(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull DatabaseDepartment department) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
        Intrinsics.checkParameterIsNotNull((Object)department, (String)"department");
        if (dataSource.isSingleConnection()) {
            throw (Throwable)new SingleConnectionModeException("Debugging in the single connection mode is not possible");
        }
        return DatabaseSessionManager.facade(project, dataSource, null, null, null, department).connect();
    }

    public static final void callProcedure(@NotNull DatabaseConnection $this$callProcedure, @NotNull String procedure, Object ... parameters) {
        Intrinsics.checkParameterIsNotNull((Object)$this$callProcedure, (String)"$this$callProcedure");
        Intrinsics.checkParameterIsNotNull((Object)procedure, (String)"procedure");
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        String statementText = "{ call " + procedure + " }";
        OracleConnectionHelperKt.perform($this$callProcedure, statementText, Arrays.copyOf(parameters, parameters.length));
    }

    public static final <V> V callFunction(@NotNull DatabaseConnection $this$callFunction, @NotNull String function2, @NotNull IndexedOutParameter<V> resultParam, Object ... parameters) {
        Intrinsics.checkParameterIsNotNull((Object)$this$callFunction, (String)"$this$callFunction");
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        Intrinsics.checkParameterIsNotNull(resultParam, (String)"resultParam");
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        String statementText = "{ ? = call " + function2 + " }";
        return OracleConnectionHelperKt.call($this$callFunction, statementText, resultParam, Arrays.copyOf(parameters, parameters.length));
    }

    public static final <V> V call(@NotNull DatabaseConnection $this$call, @NotNull String statementText, @NotNull IndexedOutParameter<V> resultParam, Object ... parameters) {
        Intrinsics.checkParameterIsNotNull((Object)$this$call, (String)"$this$call");
        Intrinsics.checkParameterIsNotNull((Object)statementText, (String)"statementText");
        Intrinsics.checkParameterIsNotNull(resultParam, (String)"resultParam");
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        CallableStatementBasis basis = new CallableStatementBasis(statementText, Integer.MAX_VALUE, CollectionsKt.listOf(resultParam));
        ParameterizedStatementDecoration decor = OracleConnectionHelperKt.decorateInParameters(SetsKt.setOf((Object)resultParam.getIndex()), parameters);
        CallableStatementData csd = new CallableStatementData(basis, decor);
        NoisyStatement<CallableStatementData> executor = OracleConnectionHelperKt.executor($this$call);
        return (V)executor.execute(csd, (Function1)new Function1<ResultsProducer, V>(resultParam){
            final /* synthetic */ IndexedOutParameter $resultParam;

            public final V invoke(@NotNull ResultsProducer it2) {
                Intrinsics.checkParameterIsNotNull((Object)it2, (String)"it");
                return (V)it2.getParameterValue(this.$resultParam);
            }
            {
                this.$resultParam = indexedOutParameter;
                super(1);
            }
        });
    }

    @NotNull
    public static final <V1, V2> Pair<V1, V2> call(@NotNull DatabaseConnection $this$call, @NotNull String statementText, @NotNull IndexedOutParameter<V1> outParam1, @NotNull IndexedOutParameter<V2> outParam2, Object ... parameters) {
        Intrinsics.checkParameterIsNotNull((Object)$this$call, (String)"$this$call");
        Intrinsics.checkParameterIsNotNull((Object)statementText, (String)"statementText");
        Intrinsics.checkParameterIsNotNull(outParam1, (String)"outParam1");
        Intrinsics.checkParameterIsNotNull(outParam2, (String)"outParam2");
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        List outParameters = CollectionsKt.listOf((Object[])new IndexedOutParameter[]{outParam1, outParam2});
        CallableStatementBasis basis = new CallableStatementBasis(statementText, Integer.MAX_VALUE, outParameters);
        ParameterizedStatementDecoration decor = OracleConnectionHelperKt.decorateInParameters((Set<Integer>)OracleConnectionHelperKt.getIndices(outParameters), parameters);
        CallableStatementData csd = new CallableStatementData(basis, decor);
        NoisyStatement<CallableStatementData> executor = OracleConnectionHelperKt.executor($this$call);
        return (Pair)executor.execute(csd, (Function1)new Function1<ResultsProducer, Pair<? extends V1, ? extends V2>>(outParam1, outParam2){
            final /* synthetic */ IndexedOutParameter $outParam1;
            final /* synthetic */ IndexedOutParameter $outParam2;

            @NotNull
            public final Pair<V1, V2> invoke(@NotNull ResultsProducer it2) {
                Intrinsics.checkParameterIsNotNull((Object)it2, (String)"it");
                T value1 = it2.getParameterValue(this.$outParam1);
                T value2 = it2.getParameterValue(this.$outParam2);
                return new Pair(value1, value2);
            }
            {
                this.$outParam1 = indexedOutParameter;
                this.$outParam2 = indexedOutParameter2;
                super(1);
            }
        });
    }

    public static final <D extends CallDefinition, R> R call(@NotNull DatabaseConnection $this$call, @NotNull D definition, @NotNull Object[] parameters, @NotNull Function1<? super ResultsProducer, ? extends R> handler) throws SQLException {
        Intrinsics.checkParameterIsNotNull((Object)$this$call, (String)"$this$call");
        Intrinsics.checkParameterIsNotNull(definition, (String)"definition");
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
        CallableStatementBasis basis = new CallableStatementBasis(definition.getText(), Integer.MAX_VALUE, definition.getOutParams());
        ParameterizedStatementDecoration decor = OracleConnectionHelperKt.decorateInParameters((Set<Integer>)OracleConnectionHelperKt.getIndices(definition.getOutParams()), parameters);
        CallableStatementData csd = new CallableStatementData(basis, decor);
        NoisyStatement<CallableStatementData> executor = OracleConnectionHelperKt.executor($this$call);
        return executor.execute(csd, handler);
    }

    public static final void perform(@NotNull DatabaseConnection $this$perform, @NotNull String statementText, Object ... parameters) {
        Intrinsics.checkParameterIsNotNull((Object)$this$perform, (String)"$this$perform");
        Intrinsics.checkParameterIsNotNull((Object)statementText, (String)"statementText");
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        CallableStatementBasis basis = new CallableStatementBasis(statementText, Integer.MAX_VALUE, CollectionsKt.emptyList());
        ParameterizedStatementDecoration decor = OracleConnectionHelperKt.decorateInParameters(parameters);
        CallableStatementData csd = new CallableStatementData(basis, decor);
        NoisyStatement<CallableStatementData> executor = OracleConnectionHelperKt.executor($this$perform);
        NoisyStatement.execute$default(executor, csd, null, 2, null);
    }

    @NotNull
    public static final NoisyStatement<CallableStatementData> executor(@NotNull DatabaseConnection $this$executor) {
        Intrinsics.checkParameterIsNotNull((Object)$this$executor, (String)"$this$executor");
        return SmartStatements.Companion.poweredBy($this$executor).call(Configuration.Companion.sourced(SmartStatements.Source.SYSTEM)).noisy();
    }

    @NotNull
    public static final ParameterizedStatementDecoration decorateInParameters(@NotNull Object[] parameters) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        return OracleConnectionHelperKt.decorateInParameters(SetsKt.emptySet(), parameters);
    }

    @NotNull
    public static final ParameterizedStatementDecoration decorateInParameters(@NotNull Set<Integer> skip, @NotNull Object[] parameters) {
        Intrinsics.checkParameterIsNotNull(skip, (String)"skip");
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        StatementParameters x = new StatementParameters();
        int k = 0;
        for (Object p2 : parameters) {
            ++k;
            while (skip.contains(k)) {
                ++k;
            }
            Object object = p2;
            if (object instanceof Boolean) {
                x.integer(k, (Boolean)p2 != false ? 1 : 0);
                continue;
            }
            if (object instanceof Byte) {
                x.byteValue(k, (Byte)p2);
                continue;
            }
            if (object instanceof Short) {
                x.shortValue(k, (Short)p2);
                continue;
            }
            if (object instanceof Integer) {
                x.integer(k, (Integer)p2);
                continue;
            }
            if (object instanceof String) {
                x.text(k, (String)p2);
                continue;
            }
            x.obj(k, p2);
        }
        return x.asDecoration();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SortedSet<Integer> getIndices(@NotNull List<? extends IndexedOutParameter<?>> $this$indices) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull($this$indices, (String)"$this$indices");
        Iterable $this$map$iv = $this$indices;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void receiver;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Integer n = ((IndexedOutParameter)receiver).getIndex();
            collection.add(n);
        }
        return CollectionsKt.toSortedSet((Iterable)((List)destination$iv$iv));
    }
}

