/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.debugger;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.StringOutParam;
import com.intellij.database.dialects.oracle.debugger.OracleBaseSession;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u0018J\u000e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\rJ\u0006\u0010\u001c\u001a\u00020\u0018J\u0010\u0010\u001d\u001a\u00020\u00182\b\b\u0002\u0010\u001e\u001a\u00020\bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\n\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\r8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OracleExecutingSession;", "Lcom/intellij/database/dialects/oracle/debugger/OracleBaseSession;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "(Lcom/intellij/database/dataSource/DatabaseConnection;)V", "_active", "Ljava/util/concurrent/atomic/AtomicBoolean;", "active", "", "getActive", "()Z", "alteredToDebuggable", "<set-?>", "", "debugId", "getDebugId", "()Ljava/lang/String;", "debugImmediate", "getDebugImmediate", "setDebugImmediate", "(Z)V", "tracePrefix", "getTracePrefix", "initRemote", "", "makeSessionDebuggable", "performTargetStatement", "statement", "turnDebugOFF", "turnDebugON", "immediate", "intellij.database.dialects.oracle"})
public final class OracleExecutingSession
extends OracleBaseSession {
    @Nullable
    private String debugId;
    private boolean alteredToDebuggable;
    private boolean debugImmediate;
    private final AtomicBoolean _active;

    @Nullable
    public final String getDebugId() {
        return this.debugId;
    }

    public final boolean getDebugImmediate() {
        return this.debugImmediate;
    }

    public final void setDebugImmediate(boolean bl) {
        this.debugImmediate = bl;
    }

    public final boolean getActive() {
        return this._active.get();
    }

    @Override
    public void initRemote() {
        super.initRemote();
        this.trace("The session id: " + this.getSessionId());
    }

    public final void makeSessionDebuggable() {
        if (!this.alteredToDebuggable) {
            this.trace("alter session set plsql_debug = true");
            this.call("alter session set plsql_debug = true", new Object[0]);
            this.alteredToDebuggable = true;
        }
        if (this.debugId == null) {
            this.trace("dbms_debug.initialize");
            this.debugId = (String)this.callFunction("dbms_debug.initialize", new StringOutParam(1, 60, null, 4, null), new Object[0]);
            this.trace("Debug id: " + this.debugId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void performTargetStatement(@NotNull String statement) {
        Intrinsics.checkParameterIsNotNull((Object)statement, (String)"statement");
        this.turnDebugON(this.debugImmediate);
        this.trace("Starting the target statement");
        this._active.set(true);
        try {
            this.call(statement, new Object[0]);
        }
        finally {
            this._active.set(false);
        }
        this.trace("The target statement is completed");
    }

    public final void turnDebugON(boolean immediate) {
        String procedure = "dbms_debug.debug_on(immediate => " + immediate + ')';
        this.trace(procedure);
        this.callProcedure(procedure, new Object[0]);
    }

    public static /* synthetic */ void turnDebugON$default(OracleExecutingSession oracleExecutingSession, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        oracleExecutingSession.turnDebugON(bl);
    }

    public final void turnDebugOFF() {
        String procedure = "dbms_debug.debug_off";
        this.trace(procedure);
        this.callProcedure(procedure, new Object[0]);
    }

    @Override
    @NotNull
    protected String getTracePrefix() {
        return "Executing";
    }

    public OracleExecutingSession(@NotNull DatabaseConnection connection2) {
        Intrinsics.checkParameterIsNotNull((Object)connection2, (String)"connection");
        super(connection2);
        this._active = new AtomicBoolean(false);
    }
}

