/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.debugger;

import com.intellij.database.debugger.SqlProgramPosition;
import com.intellij.database.dialects.oracle.debugger.OracleProgramPosition;
import com.intellij.database.dialects.oracle.debugger.OracleProgramStackFrame$WhenMappings;
import com.intellij.database.dialects.oracle.debugger.OracleStackFrame;
import com.intellij.icons.AllIcons;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.XSourcePosition;
import icons.DatabaseIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OracleProgramStackFrame;", "Lcom/intellij/database/dialects/oracle/debugger/OracleStackFrame;", "position", "Lcom/intellij/database/dialects/oracle/debugger/OracleProgramPosition;", "programPosition", "Lcom/intellij/database/debugger/SqlProgramPosition;", "(Lcom/intellij/database/dialects/oracle/debugger/OracleProgramPosition;Lcom/intellij/database/debugger/SqlProgramPosition;)V", "getPosition", "()Lcom/intellij/database/dialects/oracle/debugger/OracleProgramPosition;", "customizePresentation", "", "component", "Lcom/intellij/ui/ColoredTextContainer;", "getSourcePosition", "Lcom/intellij/xdebugger/XSourcePosition;", "intellij.database.dialects.oracle"})
public final class OracleProgramStackFrame
extends OracleStackFrame {
    @NotNull
    private final OracleProgramPosition position;
    private final SqlProgramPosition programPosition;

    @NotNull
    public XSourcePosition getSourcePosition() {
        return this.programPosition.getXPosition();
    }

    public void customizePresentation(@NotNull ColoredTextContainer component) {
        Icon icon;
        Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
        switch (OracleProgramStackFrame$WhenMappings.$EnumSwitchMapping$0[this.getPosition().getProgram().getNamespace().ordinal()]) {
            case 1: {
                icon = DatabaseIcons.SqlSelectStatement;
                break;
            }
            case 2: {
                icon = DatabaseIcons.Body;
                break;
            }
            case 3: {
                icon = DatabaseIcons.Routine;
                break;
            }
            case 4: {
                icon = DatabaseIcons.Trigger;
                break;
            }
            case 5: {
                icon = AllIcons.General.Error;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Icon icon2 = icon;
        component.setIcon(icon2);
        component.append(this.programPosition.getSource().getModelElement().getKind().toString(), SimpleTextAttributes.GRAY_ATTRIBUTES);
        component.append(": ", SimpleTextAttributes.GRAY_ATTRIBUTES);
        component.append(this.getPosition().getSchemaName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        component.append(".", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        component.append(this.getPosition().getProgramName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        component.append(": ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        component.append(String.valueOf(this.getPosition().getLineNr()), SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    @Override
    @NotNull
    public OracleProgramPosition getPosition() {
        return this.position;
    }

    public OracleProgramStackFrame(@NotNull OracleProgramPosition position, @NotNull SqlProgramPosition programPosition) {
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        Intrinsics.checkParameterIsNotNull((Object)programPosition, (String)"programPosition");
        super(null);
        this.position = position;
        this.programPosition = programPosition;
    }
}

