/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.model;

import com.intellij.database.dialects.oracle.model.OraClusterColumn;
import com.intellij.database.dialects.oracle.model.OraClusterIndex;
import com.intellij.database.dialects.oracle.model.OraMajorObject;
import com.intellij.database.dialects.oracle.model.OraSchema;
import com.intellij.database.dialects.oracle.model.OraStoredSchemaObject;
import com.intellij.database.model.ClusterType;
import com.intellij.database.model.DasCluster;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.ModSingletonFamily;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.properties.PropertyConverter;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OraCluster
extends OraMajorObject,
DasCluster,
OraStoredSchemaObject {
    @Override
    @Nullable
    default public OraSchema getSchema() {
        return this.getParent();
    }

    @Override
    @Nullable
    public OraSchema getParent();

    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends OraCluster> getParentFamily() {
        return null;
    }

    @NotNull
    public @NotNull ModPositioningNamingFamily<@NotNull ? extends OraClusterColumn> getColumns();

    @NotNull
    public @NotNull ModSingletonFamily<@NotNull ? extends OraClusterIndex> getIndices();

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Arrays.asList(ObjectKind.COLUMN, ObjectKind.INDEX);
        if (list == null) {
            OraCluster.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<ModFamily> list = Arrays.asList(this.getColumns(), this.getIndices());
        if (list == null) {
            OraCluster.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Nullable
    public ClusterType getClusterType();

    public boolean isSingleTable();

    public int getBlockSize();

    @Nullable
    public String getHashExpression();

    public int getHashCardinality();

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer2) {
        int hashCardinality;
        String hashExpression;
        int blockSize;
        boolean singleTable;
        ClusterType clusterType;
        String tablespaceName;
        Date modifiedTimestamp;
        Date createdTimestamp;
        boolean outdated;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name2;
        long objectId;
        if (consumer2 == null) {
            OraCluster.$$$reportNull$$$0(2);
        }
        if ((objectId = this.getObjectId()) != Long.MIN_VALUE) {
            consumer2.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if ((name2 = this.getName()) != null && name2 != ModelConsts.NO_NAME) {
            consumer2.accept("Name", PropertyConverter.export(name2));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer2.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer2.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer2.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer2.accept("Comment", PropertyConverter.export(comment));
        }
        if (outdated = this.isOutdated()) {
            consumer2.accept("Outdated", PropertyConverter.export(outdated));
        }
        if ((createdTimestamp = this.getCreatedTimestamp()) != null) {
            consumer2.accept("CreatedTimestamp", PropertyConverter.export(createdTimestamp));
        }
        if ((modifiedTimestamp = this.getModifiedTimestamp()) != null) {
            consumer2.accept("ModifiedTimestamp", PropertyConverter.export(modifiedTimestamp));
        }
        if ((tablespaceName = this.getTablespaceName()) != null) {
            consumer2.accept("TablespaceName", PropertyConverter.export(tablespaceName));
        }
        if ((clusterType = this.getClusterType()) != null) {
            consumer2.accept("ClusterType", PropertyConverter.export((Enum)clusterType));
        }
        if (singleTable = this.isSingleTable()) {
            consumer2.accept("SingleTable", PropertyConverter.export(singleTable));
        }
        if ((blockSize = this.getBlockSize()) != 0) {
            consumer2.accept("BlockSize", PropertyConverter.export(blockSize));
        }
        if ((hashExpression = this.getHashExpression()) != null) {
            consumer2.accept("HashExpression", PropertyConverter.export(hashExpression));
        }
        if ((hashCardinality = this.getHashCardinality()) != 0) {
            consumer2.accept("HashCardinality", PropertyConverter.export(hashCardinality));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("ObjectId", "Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "Outdated", "CreatedTimestamp", "ModifiedTimestamp", "TablespaceName", "ClusterType", "SingleTable", "BlockSize", "HashExpression", "HashCardinality");
        if (list == null) {
            OraCluster.$$$reportNull$$$0(3);
        }
        return list;
    }

    public void setClusterType(@Nullable ClusterType var1);

    public void setSingleTable(boolean var1);

    public void setBlockSize(int var1);

    public void setHashExpression(@Nullable String var1);

    public void setHashCardinality(int var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> _properties) {
        if (_properties == null) {
            OraCluster.$$$reportNull$$$0(4);
        }
        String objectId = _properties.get("ObjectId");
        String name2 = _properties.get("Name");
        String nameSurrogate = _properties.get("NameSurrogate");
        String nameScripted = _properties.get("NameScripted");
        String nameQuoted = _properties.get("NameQuoted");
        String comment = _properties.get("Comment");
        String outdated = _properties.get("Outdated");
        String createdTimestamp = _properties.get("CreatedTimestamp");
        String modifiedTimestamp = _properties.get("ModifiedTimestamp");
        String tablespaceName = _properties.get("TablespaceName");
        String clusterType = _properties.get("ClusterType");
        String singleTable = _properties.get("SingleTable");
        String blockSize = _properties.get("BlockSize");
        String hashExpression = _properties.get("HashExpression");
        String hashCardinality = _properties.get("HashCardinality");
        this.setObjectId(objectId != null ? PropertyConverter.importLong(objectId) : Long.MIN_VALUE);
        this.setName(name2 != null ? PropertyConverter.importString(name2) : ModelConsts.NO_NAME);
        this.setNameSurrogate(nameSurrogate != null ? PropertyConverter.importBoolean(nameSurrogate) : false);
        this.setNameScripted(nameScripted != null ? PropertyConverter.importBoolean(nameScripted) : false);
        this.setNameQuoted(nameQuoted != null ? PropertyConverter.importBoolean(nameQuoted) : false);
        this.setComment(comment != null ? PropertyConverter.importString(comment) : null);
        this.setOutdated(outdated != null ? PropertyConverter.importBoolean(outdated) : false);
        this.setCreatedTimestamp(createdTimestamp != null ? PropertyConverter.importDate(createdTimestamp) : null);
        this.setModifiedTimestamp(modifiedTimestamp != null ? PropertyConverter.importDate(modifiedTimestamp) : null);
        this.setTablespaceName(tablespaceName != null ? PropertyConverter.importString(tablespaceName) : null);
        this.setClusterType(clusterType != null ? PropertyConverter.importClusterType(clusterType) : null);
        this.setSingleTable(singleTable != null ? PropertyConverter.importBoolean(singleTable) : false);
        this.setBlockSize(blockSize != null ? PropertyConverter.importInt(blockSize) : 0);
        this.setHashExpression(hashExpression != null ? PropertyConverter.importString(hashExpression) : null);
        this.setHashCardinality(hashCardinality != null ? PropertyConverter.importInt(hashCardinality) : 0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/oracle/model/OraCluster";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/oracle/model/OraCluster";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNames";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "importProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

