/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.model;

import com.intellij.database.dialects.oracle.model.OraCheck;
import com.intellij.database.dialects.oracle.model.OraForeignKey;
import com.intellij.database.dialects.oracle.model.OraIndex;
import com.intellij.database.dialects.oracle.model.OraKey;
import com.intellij.database.dialects.oracle.model.OraMajorObject;
import com.intellij.database.dialects.oracle.model.OraMatLog;
import com.intellij.database.dialects.oracle.model.OraMixinTable;
import com.intellij.database.dialects.oracle.model.OraSchema;
import com.intellij.database.dialects.oracle.model.OraStoredSchemaObject;
import com.intellij.database.dialects.oracle.model.OraTableColumn;
import com.intellij.database.dialects.oracle.model.OraTableTrigger;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModTable;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.ModSingletonFamily;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.properties.OraTableType;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.TableOrganization;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OraTable
extends BasicModTable,
OraMajorObject,
OraMixinTable,
OraStoredSchemaObject {
    @Override
    @Nullable
    default public OraSchema getSchema() {
        return this.getParent();
    }

    @Override
    @Nullable
    public OraSchema getParent();

    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends OraTable> getParentFamily() {
        return null;
    }

    @Override
    @NotNull
    public @NotNull ModPositioningNamingFamily<@NotNull ? extends OraTableColumn> getColumns();

    @NotNull
    public @NotNull ModNamingIdentifyingFamily<@NotNull ? extends OraIndex> getIndices();

    @NotNull
    public @NotNull ModNamingIdentifyingFamily<@NotNull ? extends OraKey> getKeys();

    @NotNull
    public @NotNull ModNamingIdentifyingFamily<@NotNull ? extends OraForeignKey> getForeignKeys();

    @NotNull
    public @NotNull ModNamingIdentifyingFamily<@NotNull ? extends OraCheck> getChecks();

    @NotNull
    public @NotNull ModNamingIdentifyingFamily<@NotNull ? extends OraTableTrigger> getTriggers();

    @NotNull
    public @NotNull ModSingletonFamily<@NotNull ? extends OraMatLog> getMatLogs();

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Arrays.asList(ObjectKind.COLUMN, ObjectKind.INDEX, ObjectKind.KEY, ObjectKind.FOREIGN_KEY, ObjectKind.CHECK, ObjectKind.TRIGGER, ObjectKind.MAT_LOG);
        if (list == null) {
            OraTable.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<ModFamily> list = Arrays.asList(this.getColumns(), this.getIndices(), this.getKeys(), this.getForeignKeys(), this.getChecks(), this.getTriggers(), this.getMatLogs());
        if (list == null) {
            OraTable.$$$reportNull$$$0(1);
        }
        return list;
    }

    public boolean isSecondary();

    public boolean isTemporaryPreserve();

    @NotNull
    public TableOrganization getOrganization();

    @Nullable
    public String getClusterName();

    @NotNull
    public List<String> getClusterColNames();

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer2) {
        List<String> clusterColNames;
        String clusterName;
        TableOrganization organization;
        boolean temporaryPreserve;
        boolean temporary;
        boolean secondary;
        String masterTableName;
        OraTableType tableType;
        String tablespaceName;
        Date modifiedTimestamp;
        Date createdTimestamp;
        boolean system;
        String rowTypeObjectName;
        String rowTypeSchemaName;
        boolean outdated;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name2;
        long objectId;
        if (consumer2 == null) {
            OraTable.$$$reportNull$$$0(2);
        }
        if ((objectId = this.getObjectId()) != Long.MIN_VALUE) {
            consumer2.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if ((name2 = this.getName()) != null && name2 != ModelConsts.NO_NAME) {
            consumer2.accept("Name", PropertyConverter.export(name2));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer2.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer2.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer2.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer2.accept("Comment", PropertyConverter.export(comment));
        }
        if (outdated = this.isOutdated()) {
            consumer2.accept("Outdated", PropertyConverter.export(outdated));
        }
        if ((rowTypeSchemaName = this.getRowTypeSchemaName()) != null) {
            consumer2.accept("RowTypeSchemaName", PropertyConverter.export(rowTypeSchemaName));
        }
        if ((rowTypeObjectName = this.getRowTypeObjectName()) != null) {
            consumer2.accept("RowTypeObjectName", PropertyConverter.export(rowTypeObjectName));
        }
        if (system = this.isSystem()) {
            consumer2.accept("System", PropertyConverter.export(system));
        }
        if ((createdTimestamp = this.getCreatedTimestamp()) != null) {
            consumer2.accept("CreatedTimestamp", PropertyConverter.export(createdTimestamp));
        }
        if ((modifiedTimestamp = this.getModifiedTimestamp()) != null) {
            consumer2.accept("ModifiedTimestamp", PropertyConverter.export(modifiedTimestamp));
        }
        if ((tablespaceName = this.getTablespaceName()) != null) {
            consumer2.accept("TablespaceName", PropertyConverter.export(tablespaceName));
        }
        if ((tableType = this.getTableType()) != null && tableType != OraTableType.BASIC) {
            consumer2.accept("TableType", PropertyConverter.export(tableType));
        }
        if ((masterTableName = this.getMasterTableName()) != null) {
            consumer2.accept("MasterTableName", PropertyConverter.export(masterTableName));
        }
        if (secondary = this.isSecondary()) {
            consumer2.accept("Secondary", PropertyConverter.export(secondary));
        }
        if (temporary = this.isTemporary()) {
            consumer2.accept("Temporary", PropertyConverter.export(temporary));
        }
        if (temporaryPreserve = this.isTemporaryPreserve()) {
            consumer2.accept("TemporaryPreserve", PropertyConverter.export(temporaryPreserve));
        }
        if ((organization = this.getOrganization()) != null && organization != TableOrganization.DEFAULT) {
            consumer2.accept("Organization", PropertyConverter.export(organization));
        }
        if ((clusterName = this.getClusterName()) != null) {
            consumer2.accept("ClusterName", PropertyConverter.export(clusterName));
        }
        if (!(clusterColNames = this.getClusterColNames()).isEmpty()) {
            consumer2.accept("ClusterColNames", PropertyConverter.exportListOfString(clusterColNames));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("ObjectId", "Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "Outdated", "RowTypeSchemaName", "RowTypeObjectName", "System", "CreatedTimestamp", "ModifiedTimestamp", "TablespaceName", "TableType", "MasterTableName", "Secondary", "Temporary", "TemporaryPreserve", "Organization", "ClusterName", "ClusterColNames");
        if (list == null) {
            OraTable.$$$reportNull$$$0(3);
        }
        return list;
    }

    public void setTableType(@NotNull OraTableType var1);

    public void setMasterTableName(@Nullable String var1);

    public void setSecondary(boolean var1);

    public void setTemporary(boolean var1);

    public void setTemporaryPreserve(boolean var1);

    public void setOrganization(@NotNull TableOrganization var1);

    public void setClusterName(@Nullable String var1);

    public void setClusterColNames(@NotNull List<String> var1);

    default public void setClusterColNames(String ... clusterColNames) {
        this.setClusterColNames(Arrays.asList(clusterColNames));
    }

    @Override
    default public void importProperties(@NotNull Map<String, String> _properties) {
        if (_properties == null) {
            OraTable.$$$reportNull$$$0(4);
        }
        String objectId = _properties.get("ObjectId");
        String name2 = _properties.get("Name");
        String nameSurrogate = _properties.get("NameSurrogate");
        String nameScripted = _properties.get("NameScripted");
        String nameQuoted = _properties.get("NameQuoted");
        String comment = _properties.get("Comment");
        String outdated = _properties.get("Outdated");
        String rowTypeSchemaName = _properties.get("RowTypeSchemaName");
        String rowTypeObjectName = _properties.get("RowTypeObjectName");
        String system = _properties.get("System");
        String createdTimestamp = _properties.get("CreatedTimestamp");
        String modifiedTimestamp = _properties.get("ModifiedTimestamp");
        String tablespaceName = _properties.get("TablespaceName");
        String tableType = _properties.get("TableType");
        String masterTableName = _properties.get("MasterTableName");
        String secondary = _properties.get("Secondary");
        String temporary = _properties.get("Temporary");
        String temporaryPreserve = _properties.get("TemporaryPreserve");
        String organization = _properties.get("Organization");
        String clusterName = _properties.get("ClusterName");
        String clusterColNames = _properties.get("ClusterColNames");
        this.setObjectId(objectId != null ? PropertyConverter.importLong(objectId) : Long.MIN_VALUE);
        this.setName(name2 != null ? PropertyConverter.importString(name2) : ModelConsts.NO_NAME);
        this.setNameSurrogate(nameSurrogate != null ? PropertyConverter.importBoolean(nameSurrogate) : false);
        this.setNameScripted(nameScripted != null ? PropertyConverter.importBoolean(nameScripted) : false);
        this.setNameQuoted(nameQuoted != null ? PropertyConverter.importBoolean(nameQuoted) : false);
        this.setComment(comment != null ? PropertyConverter.importString(comment) : null);
        this.setOutdated(outdated != null ? PropertyConverter.importBoolean(outdated) : false);
        this.setRowTypeSchemaName(rowTypeSchemaName != null ? PropertyConverter.importString(rowTypeSchemaName) : null);
        this.setRowTypeObjectName(rowTypeObjectName != null ? PropertyConverter.importString(rowTypeObjectName) : null);
        this.setSystem(system != null ? PropertyConverter.importBoolean(system) : false);
        this.setCreatedTimestamp(createdTimestamp != null ? PropertyConverter.importDate(createdTimestamp) : null);
        this.setModifiedTimestamp(modifiedTimestamp != null ? PropertyConverter.importDate(modifiedTimestamp) : null);
        this.setTablespaceName(tablespaceName != null ? PropertyConverter.importString(tablespaceName) : null);
        this.setTableType(tableType != null ? PropertyConverter.importOraTableType(tableType) : OraTableType.BASIC);
        this.setMasterTableName(masterTableName != null ? PropertyConverter.importString(masterTableName) : null);
        this.setSecondary(secondary != null ? PropertyConverter.importBoolean(secondary) : false);
        this.setTemporary(temporary != null ? PropertyConverter.importBoolean(temporary) : false);
        this.setTemporaryPreserve(temporaryPreserve != null ? PropertyConverter.importBoolean(temporaryPreserve) : false);
        this.setOrganization(organization != null ? PropertyConverter.importTableOrganization(organization) : TableOrganization.DEFAULT);
        this.setClusterName(clusterName != null ? PropertyConverter.importString(clusterName) : null);
        this.setClusterColNames(clusterColNames != null ? PropertyConverter.importListOfString(clusterColNames) : Collections.emptyList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/oracle/model/OraTable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/oracle/model/OraTable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNames";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "importProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

