/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgres;

import com.intellij.database.dialects.base.SqlObjectBuilderImpl;
import com.intellij.database.dialects.postgres.PgObjectBuilder;
import com.intellij.database.dialects.postgres.model.PgAccessMethod;
import com.intellij.database.dialects.postgres.model.PgAggregate;
import com.intellij.database.dialects.postgres.model.PgForeignDataWrapper;
import com.intellij.database.dialects.postgres.model.PgForeignServer;
import com.intellij.database.dialects.postgres.model.PgLocalTableColumn;
import com.intellij.database.dialects.postgres.model.PgMatView;
import com.intellij.database.dialects.postgres.model.PgRole;
import com.intellij.database.dialects.postgres.model.PgRoutine;
import com.intellij.database.dialects.postgres.model.PgUserMapping;
import com.intellij.database.dialects.postgresgreenplumbase.PgGPlumBaseObjectBuilder;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.properties.PgAccessMethodType;
import com.intellij.database.model.properties.PgIdentityKind;
import com.intellij.database.model.properties.PgRoutineConcurrencyKind;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.postgres.PgElementTypes;
import com.intellij.sql.dialects.postgres.PgTypes;
import com.intellij.sql.dialects.postgres.psi.PgCreateAggregateStatementImpl;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateProcedureStatement;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlCreateViewStatement;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.impl.SqlCreateStatementImpl;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u001a\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u001c\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u001d2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\b\u0010\u000b\u001a\u0004\u0018\u00010!H\u0002J\u0014\u0010%\u001a\u0004\u0018\u00010$2\b\u0010\u000b\u001a\u0004\u0018\u00010!H\u0002R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006&"}, d2={"Lcom/intellij/database/dialects/postgres/PgObjectBuilder;", "Lcom/intellij/database/dialects/postgresgreenplumbase/PgGPlumBaseObjectBuilder;", "()V", "lazyCodeBlock", "Lcom/intellij/psi/tree/IElementType;", "getLazyCodeBlock", "()Lcom/intellij/psi/tree/IElementType;", "build", "", "obj", "Lcom/intellij/database/model/basic/BasicModElement;", "source", "Lcom/intellij/database/model/DasObject;", "buildAccessMethod", "Lcom/intellij/database/dialects/postgres/model/PgAccessMethod;", "buildAggregate", "Lcom/intellij/database/dialects/postgres/model/PgAggregate;", "buildBasicElement", "buildForeignDataWrapper", "Lcom/intellij/database/dialects/postgres/model/PgForeignDataWrapper;", "buildForeignServer", "Lcom/intellij/database/dialects/postgres/model/PgForeignServer;", "buildMatView", "Lcom/intellij/database/dialects/postgres/model/PgMatView;", "buildRole", "Lcom/intellij/database/dialects/postgres/model/PgRole;", "buildRoutine", "Lcom/intellij/database/dialects/postgres/model/PgRoutine;", "buildUserMapping", "Lcom/intellij/database/dialects/postgres/model/PgUserMapping;", "findConcurrencyKind", "Lcom/intellij/database/model/properties/PgRoutineConcurrencyKind;", "element", "Lcom/intellij/psi/PsiElement;", "findOptions", "", "", "findUser", "intellij.database.dialects.postgres"})
public class PgObjectBuilder
extends PgGPlumBaseObjectBuilder {
    @Override
    @Nullable
    protected IElementType getLazyCodeBlock() {
        return PgElementTypes.Misc.PG_LAZY_CODE_BLOCK;
    }

    @Override
    public void build(@NotNull BasicModElement obj2, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        BasicModElement basicModElement = obj2;
        if (basicModElement instanceof PgRoutine) {
            this.buildRoutine((PgRoutine)obj2, source);
        } else if (basicModElement instanceof PgForeignDataWrapper) {
            this.buildForeignDataWrapper((PgForeignDataWrapper)obj2, source);
        } else if (basicModElement instanceof PgForeignServer) {
            this.buildForeignServer((PgForeignServer)obj2, source);
        } else if (basicModElement instanceof PgUserMapping) {
            this.buildUserMapping((PgUserMapping)obj2, source);
        } else if (basicModElement instanceof PgRole) {
            this.buildRole((PgRole)obj2, source);
        } else if (basicModElement instanceof PgAggregate) {
            this.buildAggregate((PgAggregate)obj2, source);
        } else if (basicModElement instanceof PgAccessMethod) {
            this.buildAccessMethod((PgAccessMethod)obj2, source);
        } else if (basicModElement instanceof PgMatView) {
            this.buildMatView((PgMatView)obj2, source);
        } else {
            super.build(obj2, source);
        }
    }

    @Override
    protected void buildBasicElement(@NotNull BasicModElement obj2, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        super.buildBasicElement(obj2, source);
        if (obj2 instanceof PgLocalTableColumn && source instanceof SqlColumnDefinition) {
            boolean wasNotNull = ((PgLocalTableColumn)obj2).isNotNull();
            PgIdentityKind identityKind = null;
            PgObjectBuilder this_$iv = this;
            boolean $i$f$forEachChild = false;
            PgObjectBuilder pgObjectBuilder = this_$iv;
            PsiElement first$iv$iv = ((PsiElement)source).getFirstChild();
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement maybeClause = tmp$iv$iv;
                boolean bl = false;
                if (!(maybeClause instanceof SqlClause)) continue;
                PgObjectBuilder this_$iv2 = this;
                boolean $i$f$forEachChild2 = false;
                PgObjectBuilder pgObjectBuilder2 = this_$iv2;
                PsiElement first$iv$iv2 = maybeClause.getFirstChild();
                boolean $i$f$forEachSibling2 = false;
                for (PsiElement tmp$iv$iv2 = first$iv$iv2; tmp$iv$iv2 != null; tmp$iv$iv2 = tmp$iv$iv2.getNextSibling()) {
                    PsiElement byDefaultStart;
                    PsiElement child = tmp$iv$iv2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)this.getElementType(child), (Object)PgTypes.PG_GENERATED)) continue;
                    IElementType iElementType = PgTypes.PG_ALWAYS;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"PG_ALWAYS");
                    PsiElement always = this.findSibling(child, iElementType);
                    if (always != null) {
                        identityKind = PgIdentityKind.ALWAYS;
                        continue;
                    }
                    IElementType iElementType2 = PgTypes.PG_BY;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iElementType2, (String)"PG_BY");
                    if (this.findSibling(child, iElementType2) == null) {
                        continue;
                    }
                    IElementType iElementType3 = PgTypes.PG_DEFAULT;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iElementType3, (String)"PG_DEFAULT");
                    if (this.findSibling(byDefaultStart, iElementType3) == null) {
                        continue;
                    }
                    identityKind = PgIdentityKind.BY_DEFAULT;
                }
            }
            ((PgLocalTableColumn)obj2).setIdentityKind(identityKind);
            ((PgLocalTableColumn)obj2).setNotNull(identityKind != null || wasNotNull);
        }
    }

    private final void buildMatView(PgMatView obj2, DasObject source) {
        this.buildBasicElement(obj2, source);
        ((BasicModModel)obj2.getModel()).writeSources(new Runnable(this, obj2, source){
            final /* synthetic */ PgObjectBuilder this$0;
            final /* synthetic */ PgMatView $obj;
            final /* synthetic */ DasObject $source;

            public final void run() {
                Object object;
                DasObject dasObject = this.$source;
                if (!(dasObject instanceof SqlCreateViewStatement)) {
                    dasObject = null;
                }
                this.$obj.setSourceText((object = (SqlCreateViewStatement)dasObject) != null && (object = object.getQueryExpression()) != null && (object = object.getText()) != null ? SqlObjectBuilderImpl.asComposite$default(this.this$0, (String)object, null, 1, null) : null);
            }
            {
                this.this$0 = pgObjectBuilder;
                this.$obj = pgMatView;
                this.$source = dasObject;
            }
        });
    }

    private final void buildAccessMethod(PgAccessMethod obj2, DasObject source) {
        if (source instanceof SqlCreateStatementImpl) {
            PgAccessMethodType type = PgAccessMethodType.UNKNOWN;
            String handler = null;
            PgObjectBuilder this_$iv = this;
            boolean $i$f$forEachChild = false;
            PgObjectBuilder pgObjectBuilder = this_$iv;
            PsiElement first$iv$iv = ((PsiElement)source).getFirstChild();
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement child = tmp$iv$iv;
                boolean bl = false;
                IElementType iElementType = this.getElementType(child);
                if (!Intrinsics.areEqual((Object)iElementType, (Object)SqlElementTypes.SQL_CLAUSE)) continue;
                PgObjectBuilder this_$iv2 = this;
                boolean $i$f$forEachChild2 = false;
                PgObjectBuilder pgObjectBuilder2 = this_$iv2;
                PsiElement first$iv$iv2 = child.getFirstChild();
                boolean $i$f$forEachSibling2 = false;
                for (PsiElement tmp$iv$iv2 = first$iv$iv2; tmp$iv$iv2 != null; tmp$iv$iv2 = tmp$iv$iv2.getNextSibling()) {
                    PsiElement it2 = tmp$iv$iv2;
                    boolean bl2 = false;
                    IElementType iElementType2 = this.getElementType(it2);
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_INDEX)) {
                        type = PgAccessMethodType.INDEX;
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_HANDLER)) continue;
                    PgGPlumBaseObjectBuilder.Reference reference = this.findFunctionReference(it2);
                    handler = reference != null ? reference.getFullName() : null;
                }
            }
            obj2.setType(type);
            obj2.setHandler(handler);
        }
    }

    private final void buildAggregate(PgAggregate obj2, DasObject source) {
        super.buildAggregate(obj2, source);
        if (source instanceof PgCreateAggregateStatementImpl) {
            boolean finalExtra = false;
            String combineFunction = null;
            String serializationFunction = null;
            String deserializationFunction = null;
            String movingTransition = null;
            String inverseTransition = null;
            DataType movingStateType = DataType.UNKNOWN;
            long stateSize = 0L;
            long movingStateSize = 0L;
            String movingFinalFunction = null;
            boolean movingFinalExtra = false;
            String movingInitialCondition = null;
            PgRoutineConcurrencyKind concurrencyKind = PgRoutineConcurrencyKind.UNSAFE;
            PgObjectBuilder this_$iv = this;
            boolean $i$f$forEachChild = false;
            PgObjectBuilder pgObjectBuilder = this_$iv;
            PsiElement first$iv$iv = ((PsiElement)source).getFirstChild();
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement child = tmp$iv$iv;
                boolean bl = false;
                IElementType iElementType = this.getElementType(child);
                if (!Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_GENERIC_SETTINGS_CLAUSE)) continue;
                PgObjectBuilder this_$iv2 = this;
                boolean $i$f$forEachChild2 = false;
                PgObjectBuilder pgObjectBuilder2 = this_$iv2;
                PsiElement first$iv$iv2 = child.getFirstChild();
                boolean $i$f$forEachSibling2 = false;
                for (PsiElement tmp$iv$iv2 = first$iv$iv2; tmp$iv$iv2 != null; tmp$iv$iv2 = tmp$iv$iv2.getNextSibling()) {
                    PsiElement it2 = tmp$iv$iv2;
                    boolean bl2 = false;
                    IElementType iElementType2 = this.getElementType(it2);
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_FINALFUNC_EXTRA)) {
                        finalExtra = true;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_COMBINEFUNC)) {
                        PgGPlumBaseObjectBuilder.Reference reference = this.findFunctionReference(it2);
                        combineFunction = reference != null ? reference.getFullName() : null;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_SERIALFUNC)) {
                        PgGPlumBaseObjectBuilder.Reference reference = this.findFunctionReference(it2);
                        serializationFunction = reference != null ? reference.getFullName() : null;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_DESERIALFUNC)) {
                        PgGPlumBaseObjectBuilder.Reference reference = this.findFunctionReference(it2);
                        deserializationFunction = reference != null ? reference.getFullName() : null;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_MSFUNC)) {
                        PgGPlumBaseObjectBuilder.Reference reference = this.findFunctionReference(it2);
                        movingTransition = reference != null ? reference.getFullName() : null;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_MINVFUNC)) {
                        PgGPlumBaseObjectBuilder.Reference reference = this.findFunctionReference(it2);
                        inverseTransition = reference != null ? reference.getFullName() : null;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_MSTYPE)) {
                        SqlTypeElement sqlTypeElement;
                        SqlCompositeElementType sqlCompositeElementType = SqlElementTypes.SQL_TYPE_ELEMENT;
                        Intrinsics.checkExpressionValueIsNotNull((Object)sqlCompositeElementType, (String)"SqlElementTypes.SQL_TYPE_ELEMENT");
                        PsiElement psiElement = this.findSibling(it2, (IElementType)sqlCompositeElementType);
                        if (!(psiElement instanceof SqlTypeElement)) {
                            psiElement = null;
                        }
                        if ((sqlTypeElement = (SqlTypeElement)psiElement) != null && (sqlTypeElement = sqlTypeElement.getDataType()) != null) {
                            SqlTypeElement sqlTypeElement2 = sqlTypeElement;
                            boolean bl3 = false;
                            boolean bl4 = false;
                            SqlTypeElement it3 = sqlTypeElement2;
                            boolean bl5 = false;
                            movingStateType = it3;
                        }
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_SSPACE)) {
                        Float f = this.findNumberInSiblings(it2);
                        stateSize = f != null ? (long)f.floatValue() : 0L;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_MSSPACE)) {
                        Float f = this.findNumberInSiblings(it2);
                        movingStateSize = f != null ? (long)f.floatValue() : 0L;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_MFINALFUNC)) {
                        PgGPlumBaseObjectBuilder.Reference reference = this.findFunctionReference(it2);
                        movingFinalFunction = reference != null ? reference.getFullName() : null;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_MFINALFUNC_EXTRA)) {
                        movingFinalExtra = true;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_MINITCOND)) {
                        String string = this.findString(it2);
                        if (string == null) {
                            Float f = this.findNumberInSiblings(it2);
                            string = f != null ? String.valueOf((int)f.floatValue()) : null;
                        }
                        movingInitialCondition = string;
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_PARALLEL)) continue;
                    concurrencyKind = this.findConcurrencyKind(it2);
                }
            }
            obj2.setCombine(combineFunction);
            obj2.setSerialization(serializationFunction);
            obj2.setDeserialization(deserializationFunction);
            obj2.setFinalExtra(finalExtra);
            obj2.setMovingTransition(movingTransition);
            obj2.setInverseTransition(inverseTransition);
            obj2.setMovingStateType(movingStateType);
            obj2.setStateSize(stateSize);
            obj2.setMovingStateSize(movingStateSize);
            obj2.setMovingFinal(movingFinalFunction);
            obj2.setMovingFinalExtra(movingFinalExtra);
            obj2.setMovingInitialValue(movingInitialCondition);
            obj2.setConcurrencyKind(concurrencyKind);
        }
    }

    private final void buildRole(PgRole obj2, DasObject source) {
        super.buildRole(obj2, source);
        boolean isReplication = false;
        boolean isBypassRls = false;
        if (source instanceof SqlCreateStatement) {
            PgObjectBuilder this_$iv = this;
            boolean $i$f$forEachChild = false;
            PgObjectBuilder pgObjectBuilder = this_$iv;
            PsiElement first$iv$iv = ((PsiElement)source).getFirstChild();
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement c2;
                PsiElement it2 = tmp$iv$iv;
                boolean bl = false;
                if (!(it2 instanceof SqlClause)) continue;
                PsiElement psiElement = c2 = ((SqlClause)it2).getFirstChild();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"c");
                IElementType iElementType = this.getElementType(psiElement);
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_REPLICATION)) {
                    isReplication = true;
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_BYPASSRLS)) continue;
                isBypassRls = true;
            }
        }
        obj2.setReplication(isReplication);
        obj2.setBypassRls(isBypassRls);
    }

    private final void buildForeignDataWrapper(PgForeignDataWrapper obj2, DasObject source) {
        if (source instanceof SqlCreateStatementImpl) {
            PgGPlumBaseObjectBuilder.Reference handler = null;
            PgGPlumBaseObjectBuilder.Reference validator = null;
            List<String> options = CollectionsKt.emptyList();
            PgObjectBuilder this_$iv = this;
            boolean $i$f$forEachChild = false;
            PgObjectBuilder pgObjectBuilder = this_$iv;
            PsiElement first$iv$iv = ((PsiElement)source).getFirstChild();
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement it2 = tmp$iv$iv;
                boolean bl = false;
                IElementType iElementType = this.getElementType(it2);
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_HANDLER)) {
                    handler = this.findFunctionReference(it2);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_VALIDATOR)) {
                    validator = this.findFunctionReference(it2);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_OPTIONS)) continue;
                options = this.findOptions(it2);
            }
            PgGPlumBaseObjectBuilder.Reference reference = handler;
            obj2.setHandler(reference != null ? reference.getName() : null);
            PgGPlumBaseObjectBuilder.Reference reference2 = handler;
            obj2.setHandlerSchema(reference2 != null ? reference2.getQualifier() : null);
            PgGPlumBaseObjectBuilder.Reference reference3 = validator;
            obj2.setValidator(reference3 != null ? reference3.getName() : null);
            PgGPlumBaseObjectBuilder.Reference reference4 = validator;
            obj2.setValidatorSchema(reference4 != null ? reference4.getQualifier() : null);
            obj2.setOptions(options);
        }
    }

    private final void buildForeignServer(PgForeignServer obj2, DasObject source) {
        if (source instanceof SqlCreateStatementImpl) {
            String type = null;
            List<String> options = CollectionsKt.emptyList();
            String version = null;
            PgObjectBuilder this_$iv = this;
            boolean $i$f$forEachChild = false;
            PgObjectBuilder pgObjectBuilder = this_$iv;
            PsiElement first$iv$iv = ((PsiElement)source).getFirstChild();
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement it2 = tmp$iv$iv;
                boolean bl = false;
                IElementType iElementType = this.getElementType(it2);
                if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_CLAUSE)) {
                    PsiElement first2;
                    if (it2.getFirstChild() == null) {
                        continue;
                    }
                    IElementType iElementType2 = this.getElementType(first2);
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_TYPE)) {
                        type = this.findString(first2);
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_VERSION)) continue;
                    version = this.findString(first2);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_OPTIONS)) continue;
                options = this.findOptions(it2);
            }
            obj2.setType(type);
            obj2.setOptions(options);
            obj2.setVersion(version);
        }
    }

    private final void buildUserMapping(PgUserMapping obj2, DasObject source) {
        if (source instanceof SqlCreateStatementImpl) {
            String user = null;
            List<String> options = CollectionsKt.emptyList();
            PgObjectBuilder this_$iv = this;
            boolean $i$f$forEachChild = false;
            PgObjectBuilder pgObjectBuilder = this_$iv;
            PsiElement first$iv$iv = ((PsiElement)source).getFirstChild();
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement it2 = tmp$iv$iv;
                boolean bl = false;
                IElementType iElementType = this.getElementType(it2);
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_FOR)) {
                    user = this.findUser(it2);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_OPTIONS)) continue;
                options = this.findOptions(it2);
            }
            obj2.setUser(user);
            obj2.setOptions(options);
        }
    }

    private final void buildRoutine(PgRoutine obj2, DasObject source) {
        super.buildRoutine(obj2, source);
        if (source instanceof SqlCreateProcedureStatement) {
            ArrayList<String> assignments = new ArrayList<String>();
            PgRoutineConcurrencyKind concurrencyKind = PgRoutineConcurrencyKind.UNSAFE;
            boolean isWindow = false;
            float rows = 0.0f;
            PgObjectBuilder this_$iv = this;
            boolean $i$f$forEachChild = false;
            PgObjectBuilder pgObjectBuilder = this_$iv;
            PsiElement first$iv$iv = ((PsiElement)source).getFirstChild();
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                IElementType iElementType;
                PsiElement s;
                PsiElement it2 = tmp$iv$iv;
                boolean bl = false;
                PsiElement psiElement = s = it2.getFirstChild();
                IElementType iElementType2 = iElementType = psiElement != null ? this.getElementType(psiElement) : null;
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_SET)) {
                    PgObjectBuilder this_$iv2 = this;
                    boolean $i$f$forEachSibling2 = false;
                    for (PsiElement tmp$iv = s; tmp$iv != null; tmp$iv = tmp$iv.getNextSibling()) {
                        PsiElement it3 = tmp$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)this.getElementType(it3), (Object)PgTypes.PG_SET_ASSIGNMENT)) continue;
                        assignments.add(it3.getText());
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_PARALLEL)) {
                    PsiElement psiElement2 = s;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"s");
                    concurrencyKind = this.findConcurrencyKind(psiElement2);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_WINDOW)) {
                    isWindow = true;
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_SECURITY) && !Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_ROWS)) continue;
                Float f = this.findNumberInSiblings(s);
                rows = f != null ? f.floatValue() : 0.0f;
            }
            obj2.setConcurrencyKind(concurrencyKind);
            obj2.setWindow(isWindow);
            obj2.setRows(rows);
        }
    }

    private final PgRoutineConcurrencyKind findConcurrencyKind(PsiElement element2) {
        PgObjectBuilder this_$iv = this;
        boolean $i$f$forEachSibling = false;
        for (PsiElement tmp$iv = element2; tmp$iv != null; tmp$iv = tmp$iv.getNextSibling()) {
            PsiElement it2 = tmp$iv;
            boolean bl = false;
            ASTNode aSTNode = it2.getNode();
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"it.node");
            IElementType iElementType = aSTNode.getElementType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_SAFE)) {
                return PgRoutineConcurrencyKind.SAFE;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_RESTRICTED)) {
                return PgRoutineConcurrencyKind.RESTRICTED;
            }
            if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_UNSAFE)) continue;
            return PgRoutineConcurrencyKind.UNSAFE;
        }
        return PgRoutineConcurrencyKind.UNSAFE;
    }

    private final List<String> findOptions(PsiElement source) {
        return this.findOptions(source, (Function1<? super PsiElement, ? extends PsiElement>)((Function1)new Function1<PsiElement, PsiElement>(this){
            final /* synthetic */ PgObjectBuilder this$0;

            @Nullable
            public final PsiElement invoke(@NotNull PsiElement current) {
                PsiElement psiElement;
                block1: {
                    Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                    PgObjectBuilder this_$iv = this.this$0;
                    boolean $i$f$findSibling = false;
                    for (PsiElement tmp$iv = current; tmp$iv != null; tmp$iv = tmp$iv.getNextSibling()) {
                        PsiElement it2 = tmp$iv;
                        boolean bl = false;
                        if (!(Intrinsics.areEqual((Object)it2, (Object)current) ^ true && Intrinsics.areEqual((Object)PgObjectBuilder.access$getElementType$p(this.this$0, it2), (Object)SqlElementTypes.SQL_STRING_LITERAL) ^ true && Intrinsics.areEqual((Object)PgObjectBuilder.access$getElementType$p(this.this$0, it2), (Object)SqlElementTypes.WHITE_SPACE) ^ true)) continue;
                        psiElement = tmp$iv;
                        break block1;
                    }
                    psiElement = null;
                }
                return psiElement;
            }
            {
                this.this$0 = pgObjectBuilder;
                super(1);
            }
        }), (Function1<? super String, String>)((Function1)findOptions.2.INSTANCE));
    }

    private final String findUser(PsiElement source) {
        SqlReferenceElementType sqlReferenceElementType = SqlElementTypes.SQL_USER_REFERENCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlReferenceElementType, (String)"SqlElementTypes.SQL_USER_REFERENCE");
        PsiElement userReference = this.findSibling(source, (IElementType)sqlReferenceElementType);
        if (userReference instanceof SqlReferenceExpression) {
            return ((SqlReferenceExpression)userReference).getName();
        }
        PgObjectBuilder this_$iv = this;
        boolean $i$f$forEachSibling = false;
        for (PsiElement tmp$iv = source; tmp$iv != null; tmp$iv = tmp$iv.getNextSibling()) {
            PsiElement it2 = tmp$iv;
            boolean bl = false;
            ASTNode aSTNode = it2.getNode();
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"it.node");
            IElementType iElementType = aSTNode.getElementType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)SqlElementTypes.SQL_USER_REFERENCE)) {
                if (!(userReference instanceof SqlReferenceExpression)) continue;
                return ((SqlReferenceExpression)userReference).getName();
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_USER)) {
                return "user";
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_CURRENT_USER)) {
                return "current_user";
            }
            if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_PUBLIC)) continue;
            return "public";
        }
        return null;
    }

    public static final /* synthetic */ PsiElement access$findSibling(PgObjectBuilder $this, PsiElement element2, Function1 action2) {
        return $this.findSibling(element2, (Function1<? super PsiElement, Boolean>)action2);
    }

    public static final /* synthetic */ IElementType access$getElementType$p(PgObjectBuilder $this, PsiElement $this$access_u24elementType_u24p) {
        return $this.getElementType($this$access_u24elementType_u24p);
    }
}

