/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.vertica.plan;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.base.plan.AbstractPlanModelBuilder;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ThrowableConsumer;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VertPlanModelBuilder
extends AbstractPlanModelBuilder<JSONObject> {
    public static final Map<String, PlanModel.NodeType> TYPE_MAPPING = new HashMap<String, PlanModel.NodeType>();
    private final String myStatement;
    private final Version myVersion;
    private String myJson;

    public VertPlanModelBuilder(@NotNull DataRequest.OwnerEx owner, @NotNull Consumer<PlanModel> consumer2, @NotNull String statement, @NotNull Version version) {
        if (owner == null) {
            VertPlanModelBuilder.$$$reportNull$$$0(0);
        }
        if (consumer2 == null) {
            VertPlanModelBuilder.$$$reportNull$$$0(1);
        }
        if (statement == null) {
            VertPlanModelBuilder.$$$reportNull$$$0(2);
        }
        if (version == null) {
            VertPlanModelBuilder.$$$reportNull$$$0(3);
        }
        super(owner, consumer2, EnumSet.noneOf(PlanModel.Feature.class));
        this.myStatement = statement;
        this.myVersion = version;
    }

    @NotNull
    private String getPlanAsJson(@NotNull DatabaseConnection connection2) throws PlanRetrievalException {
        if (connection2 == null) {
            VertPlanModelBuilder.$$$reportNull$$$0(4);
        }
        final StringBuilder result2 = new StringBuilder();
        VertPlanModelBuilder.useStatementWithPreserved(connection2, new AbstractPlanModelBuilder.ResourceUser<ReusableSmartStatement<String>>(){

            @Override
            public void use(ReusableSmartStatement<String> statement) throws PlanRetrievalException, SQLException {
                statement.noisy().execute("EXPLAIN VERBOSE JSON " + VertPlanModelBuilder.this.myStatement, VertPlanModelBuilder.processing((ThrowableConsumer<ResultSet, SQLException>)rs -> {
                    if (rs.getMetaData().getColumnCount() != 1) {
                        throw new PlanRetrievalException("Database returned data in unknown format");
                    }
                    while (rs.next()) {
                        String s = rs.getString(1);
                        result2.append(s).append("\n");
                    }
                    String startMarker = "JSON format:\n";
                    int start = result2.indexOf(startMarker);
                    if (start != -1) {
                        result2.replace(0, start + startMarker.length(), "");
                        int end = result2.indexOf("End JSON format\n", start);
                        if (end != -1) {
                            result2.replace(end, result2.length(), "");
                        }
                    }
                    if (result2.length() == 0) {
                        VertPlanModelBuilder.failWithEmptyResultSetError();
                    }
                }));
            }
        }, new AbstractPlanModelBuilder.StateSaver[0]);
        String string = result2.toString();
        if (string == null) {
            VertPlanModelBuilder.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static BigDecimal optBig(@NotNull JSONObject obj2, @NotNull String key2, @Nullable BigDecimal def) {
        String val;
        if (obj2 == null) {
            VertPlanModelBuilder.$$$reportNull$$$0(6);
        }
        if (key2 == null) {
            VertPlanModelBuilder.$$$reportNull$$$0(7);
        }
        return (val = obj2.optString(key2)) == null ? def : new BigDecimal(val);
    }

    private static Double optDouble(@NotNull JSONObject obj2, @NotNull String key2, @Nullable Double def) {
        if (obj2 == null) {
            VertPlanModelBuilder.$$$reportNull$$$0(8);
        }
        if (key2 == null) {
            VertPlanModelBuilder.$$$reportNull$$$0(9);
        }
        return obj2.opt(key2) == null ? def : Double.valueOf(obj2.optDouble(key2, -1.0));
    }

    private void parseRoot(@NotNull String json) throws PlanRetrievalException {
        JSONObject data;
        if (json == null) {
            VertPlanModelBuilder.$$$reportNull$$$0(10);
        }
        try {
            data = new JSONObject(json);
        }
        catch (JSONException e) {
            throw new PlanRetrievalException("Database returned invalid JSON", e);
        }
        this.openNode(null);
        this.parseStatement(data);
        this.closeNode(new PlanModel.GenericNode(PlanModel.NodeType.ROOT, null));
    }

    @Override
    @NotNull
    protected String dump() {
        String string = this.myJson;
        if (string == null) {
            VertPlanModelBuilder.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    public void processRaw(@NotNull DataRequest.Context context, @NotNull DatabaseConnection connection2) {
        if (context == null) {
            VertPlanModelBuilder.$$$reportNull$$$0(12);
        }
        if (connection2 == null) {
            VertPlanModelBuilder.$$$reportNull$$$0(13);
        }
        this.myJson = this.getPlanAsJson(connection2);
        this.showRaw();
        this.parseRoot(this.myJson);
        this.modelReady();
    }

    @Override
    @NotNull
    protected String parseRawDescription(@NotNull JSONObject object) {
        if (object == null) {
            VertPlanModelBuilder.$$$reportNull$$$0(14);
        }
        StringBuilder desc = new StringBuilder();
        Iterator it2 = object.keys();
        while (it2.hasNext()) {
            String str;
            String key2 = (String)it2.next();
            if ("INPUT".equals(key2) || (str = object.optString(key2, null)) == null) continue;
            desc.append(key2).append(" = ").append(str).append(";\n");
        }
        String string = desc.toString();
        if (string == null) {
            VertPlanModelBuilder.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Override
    @Nullable
    protected String parseAccessRelation(@NotNull JSONObject object) {
        String extra;
        if (object == null) {
            VertPlanModelBuilder.$$$reportNull$$$0(16);
        }
        if ((extra = object.optString("EXTRA", null)) == null) {
            return null;
        }
        return StringUtil.trimStart((String)extra, (String)"for ");
    }

    @Override
    @Nullable
    protected BigDecimal parsePlanNumRows(@NotNull JSONObject object) {
        if (object == null) {
            VertPlanModelBuilder.$$$reportNull$$$0(17);
        }
        return VertPlanModelBuilder.optBig(object, "ROWS", null);
    }

    @Override
    @Nullable
    protected String parseAccessIndex(@NotNull JSONObject object) {
        if (object == null) {
            VertPlanModelBuilder.$$$reportNull$$$0(18);
        }
        return object.optString("PROJECTION", null);
    }

    @Override
    protected void parseSubPlans(@NotNull JSONObject object) {
        if (object == null) {
            VertPlanModelBuilder.$$$reportNull$$$0(19);
        }
        this.parseSubPlans(object, "Outer");
        this.parseSubPlans(object, "Inner");
        this.parseSubPlans(object, "INPUT");
    }

    private void parseSubPlans(@NotNull JSONObject object, String key2) {
        Object p2;
        if (object == null) {
            VertPlanModelBuilder.$$$reportNull$$$0(20);
        }
        if ((p2 = object.opt(key2)) instanceof JSONObject) {
            this.parsePlan((JSONObject)p2);
        } else if (p2 instanceof JSONArray) {
            JSONArray array = (JSONArray)p2;
            int end = array.length();
            for (int i2 = 0; i2 < end; ++i2) {
                this.parsePlan(array.optJSONObject(i2));
            }
        }
    }

    @Override
    protected void parseStatement(@NotNull JSONObject object) {
        if (object == null) {
            VertPlanModelBuilder.$$$reportNull$$$0(21);
        }
        if (this.myVersion.isOrGreater(new int[]{9})) {
            JSONObject plan = object.optJSONObject("PLAN");
            if (plan == null) {
                VertPlanModelBuilder.failWithEmptyResultSetError();
            }
            this.parsePlan(plan);
        } else {
            this.parsePlan(object);
        }
    }

    @Override
    @Nullable
    protected Double parseTotalCost(@NotNull JSONObject object) {
        if (object == null) {
            VertPlanModelBuilder.$$$reportNull$$$0(22);
        }
        return VertPlanModelBuilder.optDouble(object, "COST", null);
    }

    @Override
    @Nullable
    protected Double parseStartupCost(@NotNull JSONObject object) {
        if (object == null) {
            VertPlanModelBuilder.$$$reportNull$$$0(23);
        }
        return null;
    }

    @Override
    protected boolean parseSubqueryCorrelated(@NotNull JSONObject object) {
        if (object == null) {
            VertPlanModelBuilder.$$$reportNull$$$0(24);
        }
        return false;
    }

    @Override
    protected boolean parseSubqueryScalar(@NotNull JSONObject object) {
        if (object == null) {
            VertPlanModelBuilder.$$$reportNull$$$0(25);
        }
        return false;
    }

    @Override
    protected void parsePlan(@NotNull JSONObject state2) {
        if (state2 == null) {
            VertPlanModelBuilder.$$$reportNull$$$0(26);
        }
        if (!this.openNode(state2)) {
            return;
        }
        this.parseSubPlans(state2);
        String nodeType = state2.optString("PATH_NAME");
        PlanModel.NodeType type = TYPE_MAPPING.get(nodeType);
        if (type == PlanModel.NodeType.ACCESS && state2.opt("PROJECTION") != null) {
            type = PlanModel.NodeType.INDEX_SCAN;
        } else if (type == PlanModel.NodeType.UNION && "ALL".equals(state2.opt("EXTRA"))) {
            type = PlanModel.NodeType.UNION_ALL;
        } else if (type == null) {
            type = PlanModel.NodeType.UNKNOWN;
        }
        PlanModel.GenericNode node = this.createNode(state2, type, nodeType);
        this.closeNode(node);
    }

    static {
        TYPE_MAPPING.put("STORAGE ACCESS", PlanModel.NodeType.ACCESS);
        TYPE_MAPPING.put("SELECT", PlanModel.NodeType.SELECT);
        TYPE_MAPPING.put("UNION", PlanModel.NodeType.UNION);
        TYPE_MAPPING.put("GROUPBY", PlanModel.NodeType.GROUP_BY);
        TYPE_MAPPING.put("JOIN", PlanModel.NodeType.JOIN);
        TYPE_MAPPING.put("SORT", PlanModel.NodeType.SORT);
        TYPE_MAPPING.put("ANALYTICAL", PlanModel.NodeType.TRANSFORM);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 11: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 11: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 5: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/vertica/plan/VertPlanModelBuilder";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "json";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/vertica/plan/VertPlanModelBuilder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlanAsJson";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "dump";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRawDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPlanAsJson";
                break;
            }
            case 5: 
            case 11: 
            case 15: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "optBig";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "optDouble";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseRoot";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processRaw";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parseRawDescription";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessRelation";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "parsePlanNumRows";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessIndex";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "parseSubPlans";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "parseStatement";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "parseTotalCost";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "parseStartupCost";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryCorrelated";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryScalar";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "parsePlan";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 11: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

